/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.JmsMessageConsumer;
import org.apache.qpid.jms.JmsSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsQueueBrowser
implements AutoCloseable,
QueueBrowser,
Enumeration<Message> {
    protected static final Logger LOG = LoggerFactory.getLogger(JmsQueueBrowser.class);
    private final JmsSession session;
    private final JmsDestination destination;
    private final String selector;
    private volatile JmsMessageConsumer consumer;
    private Message next;
    private final AtomicBoolean closed = new AtomicBoolean();

    protected JmsQueueBrowser(JmsSession session, JmsDestination destination, String selector) throws JMSException {
        this.session = session;
        this.destination = destination;
        this.selector = selector;
    }

    public Enumeration<Message> getEnumeration() throws JMSException {
        this.checkClosed();
        this.createConsumer();
        return this;
    }

    @Override
    public boolean hasMoreElements() {
        JmsMessageConsumer consumer = this.consumer;
        if (consumer == null) {
            return false;
        }
        if (this.next == null) {
            try {
                this.next = consumer.receiveNoWait();
            }
            catch (JMSException e) {
                LOG.warn("Error while receive the next message: {}", (Object)e.getMessage());
            }
            if (this.next != null) {
                return true;
            }
            this.destroyConsumer();
            return false;
        }
        return true;
    }

    @Override
    public Message nextElement() {
        if (this.hasMoreElements()) {
            Message message = this.next;
            this.next = null;
            return message;
        }
        if (!this.session.isStarted()) {
            this.destroyConsumer();
            return null;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.destroyConsumer();
        }
    }

    public Queue getQueue() throws JMSException {
        return (Queue)this.destination;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    public String toString() {
        JmsMessageConsumer consumer = this.consumer;
        return "JmsQueueBrowser { value=" + String.valueOf(consumer != null ? consumer.getConsumerId() : "null") + " }";
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void destroyConsumer() {
        JmsQueueBrowser jmsQueueBrowser = this;
        synchronized (jmsQueueBrowser) {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (JMSException e) {
                LOG.trace("Error closing down internal consumer: ", (Throwable)e);
            }
            finally {
                this.consumer = null;
            }
        }
    }

    private synchronized void createConsumer() throws JMSException {
        if (this.consumer == null) {
            JmsMessageConsumer result = new JmsMessageConsumer(this.session.getNextConsumerId(), this.session, this.destination, this.selector, false){

                @Override
                public boolean isBrowser() {
                    return true;
                }
            };
            result.init();
            this.consumer = result;
        }
    }
}

