/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.management.common.mbeans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.openmbean.TabularData;
import org.apache.qpid.management.common.mbeans.annotations.MBeanAttribute;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperationParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ManagedExchange {
    public static final String TYPE = "Exchange";
    public static final String BINDING_KEY = "Binding Key";
    public static final String QUEUE_NAMES = "Queue Names";
    public static final List<String> COMPOSITE_ITEM_NAMES = Collections.unmodifiableList(Arrays.asList("Binding Key", "Queue Names"));
    public static final List<String> COMPOSITE_ITEM_DESCRIPTIONS = Collections.unmodifiableList(Arrays.asList("Binding Key", "Queue Names"));
    public static final List<String> TABULAR_UNIQUE_INDEX = Collections.unmodifiableList(Arrays.asList("Binding Key"));
    public static final String HDR_BINDING_NUMBER = "Binding No";
    public static final String HDR_QUEUE_NAME = "Queue  Name";
    public static final String HDR_QUEUE_BINDINGS = "Queue Bindings";
    public static final List<String> HEADERS_COMPOSITE_ITEM_NAMES = Collections.unmodifiableList(Arrays.asList("Binding No", "Queue  Name", "Queue Bindings"));
    public static final List<String> HEADERS_COMPOSITE_ITEM_DESC = Collections.unmodifiableList(Arrays.asList("Binding No", "Queue  Name", "Queue Bindings"));
    public static final List<String> HEADERS_TABULAR_UNIQUE_INDEX = Collections.unmodifiableList(Arrays.asList("Binding No"));

    @MBeanAttribute(name="Name", description="Exchange Name")
    public String getName() throws IOException;

    @MBeanAttribute(name="ExchangeType", description="Exchange Type")
    public String getExchangeType() throws IOException;

    @MBeanAttribute(name="TicketNo", description="Exchange Ticket No")
    public Integer getTicketNo() throws IOException;

    @MBeanAttribute(name="Durable", description="true if Exchange is durable")
    public boolean isDurable() throws IOException;

    @MBeanAttribute(name="AutoDelete", description="true if Exchange is AutoDelete")
    public boolean isAutoDelete() throws IOException;

    @MBeanOperation(name="bindings", description="view the queue bindings for this exchange")
    public TabularData bindings() throws IOException, JMException;

    @MBeanOperation(name="createNewBinding", description="create a new binding with this exchange", impact=1)
    public void createNewBinding(@MBeanOperationParameter(name="Queue", description="Queue name") String var1, @MBeanOperationParameter(name="Binding", description="New binding") String var2) throws JMException;

    @MBeanOperation(name="createNewBinding", description="create a new binding with this exchange", impact=1)
    public void createNewBinding(@MBeanOperationParameter(name="Queue", description="Queue name") String var1, @MBeanOperationParameter(name="Binding", description="New binding") String var2, @MBeanOperationParameter(name="Arguments", description="Binding arguments") Map<String, Object> var3) throws JMException;

    @MBeanOperation(name="removeBinding", description="Removes an exchange binding from the Queue", impact=1)
    public void removeBinding(@MBeanOperationParameter(name="Queue", description="Queue name") String var1, @MBeanOperationParameter(name="Binding", description="Binding key") String var2) throws IOException, JMException;
}

