/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Header;
import org.apache.ws.secpolicy.model.SignedEncryptedParts;

public class EncryptedPartsBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SignedEncryptedParts signedEncryptedParts = new SignedEncryptedParts(false, 2);
        Iterator iterator = element.getChildElements();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                this.processElement((OMElement)iterator.next(), signedEncryptedParts);
            }
        } else {
            signedEncryptedParts.setBody(true);
        }
        return signedEncryptedParts;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.ENCRYPTED_PARTS};
    }

    private void processElement(OMElement element, SignedEncryptedParts parent) {
        QName name = element.getQName();
        if (SP12Constants.HEADER.equals(name)) {
            Header header = new Header();
            OMAttribute nameAttribute = element.getAttribute(SPConstants.NAME);
            if (nameAttribute != null) {
                header.setName(nameAttribute.getAttributeValue());
            }
            OMAttribute namespaceAttribute = element.getAttribute(SPConstants.NAMESPACE);
            header.setNamespace(namespaceAttribute.getAttributeValue());
            parent.addHeader(header);
        } else if (SP12Constants.BODY.equals(name)) {
            parent.setBody(true);
        }
    }
}

