/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.HttpsToken;

public class HttpsTokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        HttpsToken httpsToken = new HttpsToken(2);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), httpsToken);
        }
        return httpsToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.HTTPS_TOKEN};
    }

    private void processAlternative(List assertions, HttpsToken parent) {
        for (XmlPrimtiveAssertion primtive : assertions) {
            QName qname = primtive.getName();
            if (qname == null) continue;
            if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(qname)) {
                parent.setHttpBasicAuthentication(true);
                continue;
            }
            if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(qname)) {
                parent.setHttpDigestAuthentication(true);
                continue;
            }
            if (!SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(qname)) continue;
            parent.setRequireClientCertificate(true);
        }
    }
}

