/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;
import org.apache.ws.secpolicy.model.Header;

public class SignedEncryptedParts
extends AbstractSecurityAssertion {
    private boolean body;
    private boolean attachments;
    private ArrayList headers = new ArrayList();
    private boolean signedParts;
    private boolean signAllHeaders;

    public boolean isSignAllHeaders() {
        return this.signAllHeaders;
    }

    public void setSignAllHeaders(boolean signAllHeaders) {
        this.signAllHeaders = signAllHeaders;
    }

    public SignedEncryptedParts(boolean signedParts, int version) {
        this.signedParts = signedParts;
        this.setVersion(version);
    }

    public boolean isBody() {
        return this.body;
    }

    public void setBody(boolean body) {
        this.body = body;
    }

    public boolean isAttachments() {
        return this.attachments;
    }

    public void setAttachments(boolean attachments) {
        this.attachments = attachments;
    }

    public ArrayList getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public boolean isSignedParts() {
        return this.signedParts;
    }

    public QName getName() {
        if (this.signedParts) {
            if (this.version == 2) {
                return SP12Constants.SIGNED_PARTS;
            }
            return SP11Constants.SIGNED_PARTS;
        }
        if (this.version == 2) {
            return SP12Constants.ENCRYPTED_PARTS;
        }
        return SP11Constants.ENCRYPTED_PARTS;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        SignedEncryptedParts.writeStartElement(writer, prefix, localName, namespaceURI);
        if (this.isBody()) {
            SignedEncryptedParts.writeEmptyElement(writer, prefix, "Body", namespaceURI);
        }
        for (Header header : this.headers) {
            SignedEncryptedParts.writeStartElement(writer, prefix, "Header", namespaceURI);
            if (header.getName() != null) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        if (this.isAttachments() && this.version == 2) {
            SignedEncryptedParts.writeEmptyElement(writer, prefix, "Attachments", namespaceURI);
        }
        writer.writeEndElement();
    }
}

