/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.model.Token;

public class UsernameToken
extends Token {
    private boolean useUTProfile10 = false;
    private boolean useUTProfile11 = false;
    private boolean noPassword;
    private boolean hashPassword;

    public UsernameToken(int version) {
        this.setVersion(version);
    }

    public boolean isUseUTProfile11() {
        return this.useUTProfile11;
    }

    public void setUseUTProfile11(boolean useUTProfile11) {
        this.useUTProfile11 = useUTProfile11;
    }

    public boolean isNoPassword() {
        return this.noPassword;
    }

    public void setNoPassword(boolean noPassword) {
        this.noPassword = noPassword;
    }

    public boolean isHashPassword() {
        return this.hashPassword;
    }

    public void setHashPassword(boolean hashPassword) {
        this.hashPassword = hashPassword;
    }

    public boolean isUseUTProfile10() {
        return this.useUTProfile10;
    }

    public void setUseUTProfile10(boolean useUTProfile10) {
        this.useUTProfile10 = useUTProfile10;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.USERNAME_TOKEN;
        }
        return SP11Constants.USERNAME_TOKEN;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localname = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        UsernameToken.writeStartElement(writer, prefix, localname, namespaceURI);
        String inclusion = this.version == 2 ? SP12Constants.getAttributeValueFromInclusion(this.getInclusion()) : SP11Constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            UsernameToken.writeAttribute(writer, prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.isUseUTProfile10() || this.isUseUTProfile11()) {
            UsernameToken.writeStartElement(writer, SPConstants.POLICY);
            if (this.isUseUTProfile10()) {
                UsernameToken.writeStartElement(writer, prefix, "WssUsernameToken10", namespaceURI);
            } else {
                UsernameToken.writeStartElement(writer, prefix, "WssUsernameToken11", namespaceURI);
            }
            if (this.version == 2) {
                if (this.isNoPassword()) {
                    UsernameToken.writeEmptyElement(writer, prefix, "NoPassword", namespaceURI);
                } else if (this.isHashPassword()) {
                    UsernameToken.writeEmptyElement(writer, prefix, "HashPassword", namespaceURI);
                }
                if (this.isDerivedKeys()) {
                    UsernameToken.writeEmptyElement(writer, prefix, "RequireDerivedKeys", namespaceURI);
                } else if (this.isExplicitDerivedKeys()) {
                    UsernameToken.writeEmptyElement(writer, prefix, "RequireExplicitDerivedKeys", namespaceURI);
                } else if (this.isImpliedDerivedKeys()) {
                    UsernameToken.writeEmptyElement(writer, prefix, "RequireImpliedDerivedKeys", namespaceURI);
                }
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

