/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.util.Date;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SCTIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.ws.security.conversation.ConversationConstants;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SCTIssuer
implements TokenIssuer {
    public static final String COMPUTED_KEY = "ComputedKey";
    private String configFile;
    private OMElement configElement;
    private String configParamName;

    public SOAPEnvelope issue(RahasData data) throws TrustException {
        SCTIssuerConfig config = null;
        if (this.configElement != null) {
            config = SCTIssuerConfig.load(this.configElement.getFirstChildWithName(SCTIssuerConfig.SCT_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = SCTIssuerConfig.load(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = data.getInMessageContext().getParameter(this.configParamName);
            if (param != null && param.getParameterElement() != null) {
                config = SCTIssuerConfig.load(param.getParameterElement().getFirstChildWithName(SCTIssuerConfig.SCT_ISSUER_CONFIG));
            } else {
                throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            }
        }
        if (config == null) {
            throw new TrustException("missingConfiguration", new String[]{SCTIssuerConfig.SCT_ISSUER_CONFIG.getLocalPart()});
        }
        return this.createEnvelope(data, config);
    }

    private SOAPEnvelope createEnvelope(RahasData data, SCTIssuerConfig config) throws TrustException {
        try {
            OMElement rstrElem;
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(data.getSoapNs());
            int wstVersion = data.getVersion();
            Document doc = ((Element)env).getOwnerDocument();
            SecurityContextToken sct = new SecurityContextToken(this.getWSCVersion(data.getTokenType()), doc);
            if (wstVersion == 2) {
                OMElement requestedSecurityTokenResponseCollection = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, requestedSecurityTokenResponseCollection);
            } else {
                rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
            }
            OMElement rstElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
            rstElem.addChild((OMNode)((OMElement)sct.getElement()));
            String tokenType = data.getTokenType();
            OMElement reqAttachedRef = null;
            OMElement reqUnattachedRef = null;
            if (config.addRequestedAttachedRef) {
                reqAttachedRef = TrustUtil.createRequestedAttachedRef(wstVersion, rstrElem, "#" + sct.getID(), tokenType);
            }
            if (config.addRequestedUnattachedRef) {
                reqUnattachedRef = TrustUtil.createRequestedUnattachedRef(wstVersion, rstrElem, sct.getIdentifier(), tokenType);
            }
            Date creationTime = new Date();
            Date expirationTime = new Date();
            expirationTime.setTime(creationTime.getTime() + config.ttl);
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
            Token sctToken = new Token(sct.getIdentifier(), (OMElement)sct.getElement(), creationTime, expirationTime);
            if (config.addRequestedAttachedRef) {
                sctToken.setAttachedReference(reqAttachedRef.getFirstElement());
            }
            if (config.addRequestedUnattachedRef) {
                sctToken.setUnattachedReference(reqUnattachedRef.getFirstElement());
            }
            byte[] secret = TokenIssuerUtil.getSharedSecret(data, config.keyComputation, config.keySize);
            sctToken.setSecret(secret);
            TokenIssuerUtil.handleRequestedProofToken(data, wstVersion, config, rstrElem, sctToken, doc);
            sctToken.setState(1);
            TrustUtil.getTokenStore(data.getInMessageContext()).add(sctToken);
            return env;
        }
        catch (ConversationException e) {
            throw new TrustException(e.getMessage(), e);
        }
    }

    public String getResponseAction(RahasData data) throws TrustException {
        return TrustUtil.getActionValue(data.getVersion(), "/RSTR/SCT");
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    private int getWSCVersion(String tokenTypeValue) throws ConversationException {
        if (tokenTypeValue == null) {
            return 1;
        }
        if (tokenTypeValue.startsWith("http://schemas.xmlsoap.org/ws/2005/02/sc")) {
            return ConversationConstants.getWSTVersion((String)"http://schemas.xmlsoap.org/ws/2005/02/sc");
        }
        if (tokenTypeValue.startsWith("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512")) {
            return ConversationConstants.getWSTVersion((String)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
        }
        throw new ConversationException("unsupportedSecConvVersion");
    }
}

