/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.ranger.plugin.classloader.RangerPluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAuthorizationCoprocessor
implements RegionCoprocessor,
MasterCoprocessor,
RegionServerCoprocessor,
MasterObserver,
RegionObserver,
RegionServerObserver,
EndpointObserver,
BulkLoadObserver,
AccessControlProtos.AccessControlService.Interface {
    public static final Logger LOG = LoggerFactory.getLogger(RangerAuthorizationCoprocessor.class);
    private static final String RANGER_PLUGIN_TYPE = "hbase";
    private static final String RANGER_HBASE_AUTHORIZER_IMPL_CLASSNAME = "org.apache.ranger.authorization.hbase.RangerAuthorizationCoprocessor";
    private RangerPluginClassLoader rangerPluginClassLoader = null;
    private Object impl = null;
    private MasterObserver implMasterObserver = null;
    private RegionObserver implRegionObserver = null;
    private RegionServerObserver implRegionServerObserver = null;
    private BulkLoadObserver implBulkLoadObserver = null;
    private AccessControlProtos.AccessControlService.Interface implAccessControlService = null;
    private MasterCoprocessor implMasterCoprocessor = null;
    private RegionCoprocessor implRegionCoprocessor = null;
    private RegionServerCoprocessor implRegionServerCoporcessor = null;

    public RangerAuthorizationCoprocessor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.RangerAuthorizationCoprocessor()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.RangerAuthorizationCoprocessor()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.init()");
        }
        try {
            this.rangerPluginClassLoader = RangerPluginClassLoader.getInstance((String)RANGER_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(RANGER_HBASE_AUTHORIZER_IMPL_CLASSNAME, true, (ClassLoader)this.rangerPluginClassLoader);
            this.activatePluginClassLoader();
            this.impl = cls.newInstance();
            this.implAccessControlService = (AccessControlProtos.AccessControlService.Interface)this.impl;
            this.implMasterCoprocessor = (MasterCoprocessor)this.impl;
            this.implRegionCoprocessor = (RegionCoprocessor)this.impl;
            this.implRegionServerCoporcessor = (RegionServerCoprocessor)this.impl;
            this.implMasterObserver = (MasterObserver)this.impl;
            this.implRegionObserver = (RegionObserver)this.impl;
            this.implRegionServerObserver = (RegionServerObserver)this.impl;
            this.implBulkLoadObserver = (BulkLoadObserver)this.impl;
        }
        catch (Exception e) {
            LOG.error("Error Enabling RangerHbasePlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.init()");
        }
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public Optional<EndpointObserver> getEndpointObserver() {
        return Optional.of(this);
    }

    public Optional<BulkLoadObserver> getBulkLoadObserver() {
        return Optional.of(this);
    }

    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.start()");
        }
        try {
            this.activatePluginClassLoader();
            if (env instanceof MasterCoprocessorEnvironment) {
                this.implMasterCoprocessor.start(env);
            } else if (env instanceof RegionServerCoprocessorEnvironment) {
                this.implRegionServerCoporcessor.start(env);
            } else if (env instanceof RegionCoprocessorEnvironment) {
                this.implRegionCoprocessor.start(env);
            }
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.start()");
        }
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(AccessControlProtos.AccessControlService.newReflectiveService((AccessControlProtos.AccessControlService.Interface)this));
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postScannerClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postScannerClose(c, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postScannerClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        RegionScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerOpen(c, scan, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postScannerOpen()");
        }
        return ret;
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postStartMaster()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postStartMaster(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postStartMaster()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preAppend()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preAppend(c, append);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preAppend()");
        }
        return ret;
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preAssign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAssign(c, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preAssign()");
        }
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preBalance()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preBalance(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preBalance()");
        }
    }

    public void preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preBalanceSwitch()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preBalanceSwitch(c, newValue);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preBalanceSwitch()");
        }
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preBulkLoadHFile()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preBulkLoadHFile(ctx, familyPaths);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preBulkLoadHFile()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCheckAndDelete()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCheckAndDelete()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCheckAndPut()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCheckAndPut()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCloneSnapshot()");
        }
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preClose(e, abortRequested);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateTable(c, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDelete()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preDelete(c, delete, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDelete()");
        }
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDeleteSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDeleteSnapshot()");
        }
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDeleteTable()");
        }
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDisableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDisableTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDisableTable()");
        }
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preEnableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preEnableTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preEnableTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preExists()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preExists(c, get, exists);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preExists()");
        }
        return ret;
    }

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e, FlushLifeCycleTracker tracker) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preFlush(e, tracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preIncrement()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrement(c, increment);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preIncrement()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, TableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyTable(c, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preModifyTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preMove()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preMove(c, region, srcServer, destServer);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preMove()");
        }
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preOpen(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preOpen()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preRestoreSnapshot()");
        }
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preScannerClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preScannerClose(c, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preScannerClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preScannerNext()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preScannerNext(c, s, result, limit, hasNext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preScannerNext()");
        }
        return ret;
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preScannerOpen(c, scan);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preScannerOpen()");
        }
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preShutdown()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preShutdown(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preShutdown()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preSnapshot()");
        }
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preStopMaster()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preStopMaster(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preStopMaster()");
        }
    }

    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preStopRegionServer()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preStopRegionServer(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preStopRegionServer()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo, boolean force) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preUnassign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preUnassign(c, regionInfo, force);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preUnassign()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preSetTableQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetTableQuota(ctx, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preSetTableQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preSetNamespaceQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetNamespaceQuota(ctx, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preSetNamespaceQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.prePut()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.prePut(c, put, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.prePut()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> rEnv, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preGetOp()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preGetOp(rEnv, get, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preGetOp()");
        }
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, RegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preRegionOffline()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preRegionOffline(c, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preRegionOffline()");
        }
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCreateNamespace()");
        }
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteNamespace(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDeleteNamespace()");
        }
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preModifyNamespace()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postGetTableDescriptors()");
        }
    }

    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.prePrepareBulkLoad()");
        }
        try {
            this.activatePluginClassLoader();
            this.implBulkLoadObserver.prePrepareBulkLoad(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.prePrepareBulkLoad()");
        }
    }

    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCleanupBulkLoad()");
        }
        try {
            this.activatePluginClassLoader();
            this.implBulkLoadObserver.preCleanupBulkLoad(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCleanupBulkLoad()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grant(RpcController controller, AccessControlProtos.GrantRequest request, RpcCallback<AccessControlProtos.GrantResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.grant()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.grant(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.grant()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(RpcController controller, AccessControlProtos.RevokeRequest request, RpcCallback<AccessControlProtos.RevokeResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.revoke()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.revoke(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.revoke()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPermissions(RpcController controller, AccessControlProtos.CheckPermissionsRequest request, RpcCallback<AccessControlProtos.CheckPermissionsResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.checkPermissions()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.checkPermissions(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.checkPermissions()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hasPermission(RpcController controller, AccessControlProtos.HasPermissionRequest request, RpcCallback<AccessControlProtos.HasPermissionResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.hasPermission()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.hasPermission(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.hasPermission()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request, RpcCallback<AccessControlProtos.GetUserPermissionsResponse> done) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.getUserPermissions()");
        }
        try {
            this.activatePluginClassLoader();
            this.implAccessControlService.getUserPermissions(controller, request, done);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.getUserPermissions()");
        }
    }

    public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preRollWALWriterRequest()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preRollWALWriterRequest(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preRollWALWriterRequest()");
        }
    }

    public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postRollWALWriterRequest()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postRollWALWriterRequest(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postRollWALWriterRequest()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        ReplicationEndpoint ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCreateReplicationEndPoint()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionServerObserver.postCreateReplicationEndPoint(ctx, endpoint);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCreateReplicationEndPoint()");
        }
        return ret;
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postOpen(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postOpen()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preFlush()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preFlush(c, store, scanner, tracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preFlush()");
        }
        return ret;
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, FlushLifeCycleTracker tracker) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postFlush(c, tracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, FlushLifeCycleTracker tracker) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postFlush(c, store, resultFile, tracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preCompactSelection(c, store, candidates, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> selected, CompactionLifeCycleTracker tracker, CompactionRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompactSelection(c, store, selected, tracker, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCompact()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompact(c, store, scanner, scanType, tracker, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCompact()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCompact()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompact(c, store, resultFile, tracker, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCompact()");
        }
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postClose(c, abortRequested);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postGetOp()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postGetOp(c, get, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postGetOp()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postExists()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postExists(c, get, exists);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postExists()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postPut()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postPut(c, put, edit, durability);
        }
        catch (IOException e) {
            LOG.error("Failed during postPut()", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postPut()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> c, Mutation mutation, Cell cell, byte[] byteNow, Get get) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.prePrepareTimeStampForDeleteVersion()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.prePrepareTimeStampForDeleteVersion(c, mutation, cell, byteNow, get);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.prePrepareTimeStampForDeleteVersion()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDelete()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postDelete(c, delete, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDelete()");
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preBatchMutate()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preBatchMutate(c, miniBatchOp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preBatchMutate()");
        }
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postBatchMutate()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBatchMutate(c, miniBatchOp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postBatchMutate()");
        }
    }

    public void postStartRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postStartRegionOperation()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postStartRegionOperation(ctx, operation);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postStartRegionOperation()");
        }
    }

    public void postCloseRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCloseRegionOperation()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCloseRegionOperation(ctx, operation);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCloseRegionOperation()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> ctx, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postBatchMutateIndispensably()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBatchMutateIndispensably(ctx, miniBatchOp, success);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postBatchMutateIndispensably()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCheckAndPutAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndPutAfterRowLock(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCheckAndPutAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCheckAndPut()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCheckAndPut()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCheckAndDeleteAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndDeleteAfterRowLock(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCheckAndDeleteAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCheckAndDelete()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCheckAndDelete()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preAppendAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preAppendAfterRowLock(c, append);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preAppendAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postAppend()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postAppend(c, append, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postAppend()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preIncrementAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrementAfterRowLock(c, increment);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preIncrementAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postIncrement()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postIncrement(c, increment, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postIncrement()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postScannerNext()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerNext(c, s, result, limit, hasNext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postScannerNext()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, Cell currentCell, boolean hasMore) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postScannerFilterRow()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerFilterRow(c, s, currentCell, hasMore);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postScannerFilterRow()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, Map<byte[], List<Path>> finalPaths) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postBulkLoadHFile()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBulkLoadHFile(ctx, familyPaths, finalPaths);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postBulkLoadHFile()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFileReader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        StoreFileReader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preStoreFileReaderOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preStoreFileReaderOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFileReader postStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        StoreFileReader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postStoreFileReaderOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postStoreFileReaderOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        Cell ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postMutationBeforeWAL()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postMutationBeforeWAL(ctx, opType, mutation, oldCell, newCell);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postMutationBeforeWAL()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        DeleteTracker ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postInstantiateDeleteTracker()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postInstantiateDeleteTracker(ctx, delTracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postInstantiateDeleteTracker()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateTable(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preCreateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateTableAction(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preCreateTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompletedCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCreateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCompletedCreateTableAction(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCreateTableHandler()");
        }
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDeleteTable()");
        }
    }

    public void preDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDeleteTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDeleteTableHandler()");
        }
    }

    public void postCompletedDeleteTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDeleteTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCompletedDeleteTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDeleteTableHandler()");
        }
    }

    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preTruncateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTruncateTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preTruncateTable()");
        }
    }

    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postTruncateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTruncateTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postTruncateTable()");
        }
    }

    public void preTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preTruncateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTruncateTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preTruncateTableHandler()");
        }
    }

    public void postCompletedTruncateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postTruncateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCompletedTruncateTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postTruncateTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyTable(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postModifyTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preModifyTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyTableAction(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preModifyTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompletedModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postModifyTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCompletedModifyTableAction(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postModifyTableHandler()");
        }
    }

    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postEnableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postEnableTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postEnableTable()");
        }
    }

    public void preEnableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preEnableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preEnableTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preEnableTableHandler()");
        }
    }

    public void postCompletedEnableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postEnableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCompletedEnableTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postEnableTableHandler()");
        }
    }

    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDisableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDisableTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDisableTable()");
        }
    }

    public void preDisableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preDisableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDisableTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preDisableTableHandler()");
        }
    }

    public void postCompletedDisableTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDisableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCompletedDisableTableAction(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDisableTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postMove()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postMove(ctx, region, srcServer, destServer);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postMove()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext, long procId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preAbortProcedure()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAbortProcedure(observerContext, procId);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preAbortProcedure()");
        }
    }

    public void postAbortProcedure(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postAbortProcedure()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAbortProcedure(observerContext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postAbortProcedure()");
        }
    }

    public void preGetProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preListProcedures()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetProcedures(observerContext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preListProcedures()");
        }
    }

    public void postGetProcedures(ObserverContext<MasterCoprocessorEnvironment> observerContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postListProcedures()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetProcedures(observerContext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postListProcedures()");
        }
    }

    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postAssign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAssign(ctx, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postAssign()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo regionInfo, boolean force) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postUnassign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postUnassign(ctx, regionInfo, force);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postUnassign()");
        }
    }

    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postRegionOffline()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRegionOffline(ctx, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postRegionOffline()");
        }
    }

    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> ctx, List<RegionPlan> plans) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postBalance()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postBalance(ctx, plans);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postBalance()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean oldValue, boolean newValue) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postBalanceSwitch()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postBalanceSwitch(ctx, oldValue, newValue);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postBalanceSwitch()");
        }
    }

    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preMasterInitialization()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preMasterInitialization(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preMasterInitialization()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postSnapshot()");
        }
    }

    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preListSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preListSnapshot()");
        }
    }

    public void postListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postListSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postListSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCloneSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postRestoreSnapshot()");
        }
    }

    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDeleteSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDeleteSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preGetTableNames()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableNames(ctx, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preGetTableNames()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postGetTableNames()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableNames(ctx, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postGetTableNames()");
        }
    }

    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postCreateNamespace()");
        }
    }

    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteNamespace(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postDeleteNamespace()");
        }
    }

    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postModifyNamespace()");
        }
    }

    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preGetNamespaceDescriptor()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetNamespaceDescriptor(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preGetNamespaceDescriptor()");
        }
    }

    public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postGetNamespaceDescriptor()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetNamespaceDescriptor(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postGetNamespaceDescriptor()");
        }
    }

    public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preListNamespaceDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListNamespaceDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preListNamespaceDescriptors()");
        }
    }

    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postListNamespaceDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListNamespaceDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postListNamespaceDescriptors()");
        }
    }

    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.preTableFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTableFlush(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.preTableFlush()");
        }
    }

    public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postTableFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTableFlush(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postTableFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postSetTableQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetTableQuota(ctx, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postSetTableQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, GlobalQuotaSettings quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAuthorizationCoprocessor.postSetNamespaceQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetNamespaceQuota(ctx, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAuthorizationCoprocessor.postSetNamespaceQuota()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.rangerPluginClassLoader != null) {
            this.rangerPluginClassLoader.deactivate();
        }
    }

    public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
    }

    public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<Address> servers, String targetGroup) throws IOException {
    }

    public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
    }

    public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
    }

    public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> arg0, HRegionInfo arg1, HRegionInfo arg2) throws IOException {
    }

    public void postSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> arg0, boolean arg1, MasterSwitchType arg2) throws IOException {
    }

    public void preDispatchMerge(ObserverContext<MasterCoprocessorEnvironment> arg0, HRegionInfo arg1, HRegionInfo arg2) throws IOException {
    }

    public void preSetSplitOrMergeEnabled(ObserverContext<MasterCoprocessorEnvironment> arg0, boolean arg1, MasterSwitchType arg2) throws IOException {
    }
}

