/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.ranger.RangerServiceException;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.plugin.model.RangerPluginInfo;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerClient {
    private static final Logger LOG = LoggerFactory.getLogger(RangerClient.class);
    private static final String AUTH_KERBEROS = "kerberos";
    private static final String PARAM_DAYS = "days";
    private static final String PARAM_EXEC_USER = "execUser";
    private static final String PARAM_POLICY_NAME = "policyname";
    private static final String PARAM_SERVICE_NAME = "serviceName";
    private static final String PARAM_RELOAD_SERVICE_POLICIES_CACHE = "reloadServicePoliciesCache";
    private static final String URI_BASE = "/service/public/v2/api";
    private static final String URI_SERVICEDEF = "/service/public/v2/api/servicedef";
    private static final String URI_SERVICEDEF_BY_ID = "/service/public/v2/api/servicedef/%d";
    private static final String URI_SERVICEDEF_BY_NAME = "/service/public/v2/api/servicedef/name/%s";
    private static final String URI_SERVICE = "/service/public/v2/api/service";
    private static final String URI_SERVICE_BY_ID = "/service/public/v2/api/service/%d";
    private static final String URI_SERVICE_BY_NAME = "/service/public/v2/api/service/name/%s";
    private static final String URI_POLICIES_IN_SERVICE = "/service/public/v2/api/service/%s/policy";
    private static final String URI_POLICY = "/service/public/v2/api/policy";
    private static final String URI_APPLY_POLICY = "/service/public/v2/api/policy/apply";
    private static final String URI_POLICY_BY_ID = "/service/public/v2/api/policy/%d";
    private static final String URI_POLICY_BY_NAME = "/service/public/v2/api/service/%s/policy/%s";
    private static final String URI_ROLE = "/service/public/v2/api/roles";
    private static final String URI_ROLE_NAMES = "/service/public/v2/api/roles/names";
    private static final String URI_ROLE_BY_ID = "/service/public/v2/api/roles/%d";
    private static final String URI_ROLE_BY_NAME = "/service/public/v2/api/roles/name/%s";
    private static final String URI_USER_ROLES = "/service/public/v2/api/roles/user/%s";
    private static final String URI_GRANT_ROLE = "/service/public/v2/api/roles/grant/%s";
    private static final String URI_REVOKE_ROLE = "/service/public/v2/api/roles/revoke/%s";
    private static final String URI_ZONE = "/service/public/v2/api/zones";
    private static final String URI_ZONE_BY_ID = "/service/public/v2/api/zones/%d";
    private static final String URI_ZONE_BY_NAME = "/service/public/v2/api/zones/name/%s";
    private static final String URI_PLUGIN_INFO = "/service/public/v2/api/plugins/info";
    private static final String URI_POLICY_DELTAS = "/service/public/v2/api/server/policydeltas";
    public static final API CREATE_SERVICEDEF = new API("/service/public/v2/api/servicedef", "POST", Response.Status.OK);
    public static final API UPDATE_SERVICEDEF_BY_ID = new API("/service/public/v2/api/servicedef/%d", "PUT", Response.Status.OK);
    public static final API UPDATE_SERVICEDEF_BY_NAME = new API("/service/public/v2/api/servicedef/name/%s", "PUT", Response.Status.OK);
    public static final API DELETE_SERVICEDEF_BY_ID = new API("/service/public/v2/api/servicedef/%d", "DELETE", Response.Status.NO_CONTENT);
    public static final API DELETE_SERVICEDEF_BY_NAME = new API("/service/public/v2/api/servicedef/name/%s", "DELETE", Response.Status.NO_CONTENT);
    public static final API GET_SERVICEDEF_BY_ID = new API("/service/public/v2/api/servicedef/%d", "GET", Response.Status.OK);
    public static final API GET_SERVICEDEF_BY_NAME = new API("/service/public/v2/api/servicedef/name/%s", "GET", Response.Status.OK);
    public static final API FIND_SERVICEDEFS = new API("/service/public/v2/api/servicedef", "GET", Response.Status.OK);
    public static final API CREATE_SERVICE = new API("/service/public/v2/api/service", "POST", Response.Status.OK);
    public static final API UPDATE_SERVICE_BY_ID = new API("/service/public/v2/api/service/%d", "PUT", Response.Status.OK);
    public static final API UPDATE_SERVICE_BY_NAME = new API("/service/public/v2/api/service/name/%s", "PUT", Response.Status.OK);
    public static final API DELETE_SERVICE_BY_ID = new API("/service/public/v2/api/service/%d", "DELETE", Response.Status.NO_CONTENT);
    public static final API DELETE_SERVICE_BY_NAME = new API("/service/public/v2/api/service/name/%s", "DELETE", Response.Status.NO_CONTENT);
    public static final API GET_SERVICE_BY_ID = new API("/service/public/v2/api/service/%d", "GET", Response.Status.OK);
    public static final API GET_SERVICE_BY_NAME = new API("/service/public/v2/api/service/name/%s", "GET", Response.Status.OK);
    public static final API FIND_SERVICES = new API("/service/public/v2/api/service", "GET", Response.Status.OK);
    public static final API CREATE_POLICY = new API("/service/public/v2/api/policy", "POST", Response.Status.OK);
    public static final API UPDATE_POLICY_BY_ID = new API("/service/public/v2/api/policy/%d", "PUT", Response.Status.OK);
    public static final API UPDATE_POLICY_BY_NAME = new API("/service/public/v2/api/service/%s/policy/%s", "PUT", Response.Status.OK);
    public static final API APPLY_POLICY = new API("/service/public/v2/api/policy/apply", "POST", Response.Status.OK);
    public static final API DELETE_POLICY_BY_ID = new API("/service/public/v2/api/policy/%d", "DELETE", Response.Status.NO_CONTENT);
    public static final API DELETE_POLICY_BY_NAME = new API("/service/public/v2/api/policy", "DELETE", Response.Status.NO_CONTENT);
    public static final API GET_POLICY_BY_ID = new API("/service/public/v2/api/policy/%d", "GET", Response.Status.OK);
    public static final API GET_POLICY_BY_NAME = new API("/service/public/v2/api/service/%s/policy/%s", "GET", Response.Status.OK);
    public static final API GET_POLICIES_IN_SERVICE = new API("/service/public/v2/api/service/%s/policy", "GET", Response.Status.OK);
    public static final API FIND_POLICIES = new API("/service/public/v2/api/policy", "GET", Response.Status.OK);
    public static final API CREATE_ZONE = new API("/service/public/v2/api/zones", "POST", Response.Status.OK);
    public static final API UPDATE_ZONE_BY_ID = new API("/service/public/v2/api/zones/%d", "PUT", Response.Status.OK);
    public static final API UPDATE_ZONE_BY_NAME = new API("/service/public/v2/api/zones/name/%s", "PUT", Response.Status.OK);
    public static final API DELETE_ZONE_BY_ID = new API("/service/public/v2/api/zones/%d", "DELETE", Response.Status.NO_CONTENT);
    public static final API DELETE_ZONE_BY_NAME = new API("/service/public/v2/api/zones/name/%s", "DELETE", Response.Status.NO_CONTENT);
    public static final API GET_ZONE_BY_ID = new API("/service/public/v2/api/zones/%d", "GET", Response.Status.OK);
    public static final API GET_ZONE_BY_NAME = new API("/service/public/v2/api/zones/name/%s", "GET", Response.Status.OK);
    public static final API FIND_ZONES = new API("/service/public/v2/api/zones", "GET", Response.Status.OK);
    public static final API CREATE_ROLE = new API("/service/public/v2/api/roles", "POST", Response.Status.OK);
    public static final API UPDATE_ROLE_BY_ID = new API("/service/public/v2/api/roles/%d", "PUT", Response.Status.OK);
    public static final API DELETE_ROLE_BY_ID = new API("/service/public/v2/api/roles/%d", "DELETE", Response.Status.NO_CONTENT);
    public static final API DELETE_ROLE_BY_NAME = new API("/service/public/v2/api/roles/name/%s", "DELETE", Response.Status.NO_CONTENT);
    public static final API GET_ROLE_BY_ID = new API("/service/public/v2/api/roles/%d", "GET", Response.Status.OK);
    public static final API GET_ROLE_BY_NAME = new API("/service/public/v2/api/roles/name/%s", "GET", Response.Status.OK);
    public static final API GET_ALL_ROLE_NAMES = new API("/service/public/v2/api/roles/names", "GET", Response.Status.OK);
    public static final API GET_USER_ROLES = new API("/service/public/v2/api/roles/user/%s", "GET", Response.Status.OK);
    public static final API GRANT_ROLE = new API("/service/public/v2/api/roles/grant/%s", "PUT", Response.Status.OK);
    public static final API REVOKE_ROLE = new API("/service/public/v2/api/roles/revoke/%s", "PUT", Response.Status.OK);
    public static final API FIND_ROLES = new API("/service/public/v2/api/roles", "GET", Response.Status.OK);
    public static final API GET_PLUGIN_INFO = new API("/service/public/v2/api/plugins/info", "GET", Response.Status.OK);
    public static final API DELETE_POLICY_DELTAS = new API("/service/public/v2/api/server/policydeltas", "DELETE", Response.Status.NO_CONTENT);
    private final RangerRESTClient restClient;
    private boolean isSecureMode = false;
    private Subject sub = null;

    public RangerClient(String hostName, String authType, String username, String password, String configFile) {
        this.restClient = new RangerRESTClient(hostName, configFile, new Configuration());
        if (AUTH_KERBEROS.equalsIgnoreCase(authType)) {
            if (SecureClientLogin.isKerberosCredentialExists((String)username, (String)password)) {
                this.isSecureMode = true;
                try {
                    this.sub = SecureClientLogin.loginUserFromKeytab((String)username, (String)password);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            } else {
                LOG.error("Authentication credentials missing/invalid");
            }
        } else {
            this.restClient.setBasicAuthInfo(username, password);
        }
    }

    public RangerClient(RangerRESTClient restClient) {
        this.restClient = restClient;
    }

    public RangerServiceDef createServiceDef(RangerServiceDef serviceDef) throws RangerServiceException {
        return this.callAPI(CREATE_SERVICEDEF, null, (Object)serviceDef, RangerServiceDef.class);
    }

    public RangerServiceDef updateServiceDef(long serviceDefId, RangerServiceDef serviceDef) throws RangerServiceException {
        return this.callAPI(UPDATE_SERVICEDEF_BY_ID.applyUrlFormat(serviceDefId), null, (Object)serviceDef, RangerServiceDef.class);
    }

    public RangerServiceDef updateServiceDef(String serviceDefName, RangerServiceDef serviceDef) throws RangerServiceException {
        return this.callAPI(UPDATE_SERVICEDEF_BY_NAME.applyUrlFormat(serviceDefName), null, (Object)serviceDef, RangerServiceDef.class);
    }

    public void deleteServiceDef(long serviceDefId) throws RangerServiceException {
        this.callAPI(DELETE_SERVICEDEF_BY_ID.applyUrlFormat(serviceDefId), null);
    }

    public void deleteServiceDef(String serviceDefName) throws RangerServiceException {
        this.callAPI(DELETE_SERVICEDEF_BY_NAME.applyUrlFormat(serviceDefName), null);
    }

    public RangerServiceDef getServiceDef(long serviceDefId) throws RangerServiceException {
        return this.callAPI(GET_SERVICEDEF_BY_ID.applyUrlFormat(serviceDefId), null, null, RangerServiceDef.class);
    }

    public RangerServiceDef getServiceDef(String serviceDefName) throws RangerServiceException {
        return this.callAPI(GET_SERVICEDEF_BY_NAME.applyUrlFormat(serviceDefName), null, null, RangerServiceDef.class);
    }

    public List<RangerServiceDef> findServiceDefs(Map<String, String> filter) throws RangerServiceException {
        return this.callAPI(FIND_SERVICEDEFS, filter, null, new GenericType<List<RangerServiceDef>>(){});
    }

    public RangerService createService(RangerService service) throws RangerServiceException {
        return this.callAPI(CREATE_SERVICE, null, (Object)service, RangerService.class);
    }

    public RangerService updateService(long serviceId, RangerService service) throws RangerServiceException {
        return this.callAPI(UPDATE_SERVICE_BY_ID.applyUrlFormat(serviceId), null, (Object)service, RangerService.class);
    }

    public RangerService updateService(String serviceName, RangerService service) throws RangerServiceException {
        return this.callAPI(UPDATE_SERVICE_BY_NAME.applyUrlFormat(serviceName), null, (Object)service, RangerService.class);
    }

    public void deleteService(long serviceId) throws RangerServiceException {
        this.callAPI(DELETE_SERVICE_BY_ID.applyUrlFormat(serviceId), null);
    }

    public void deleteService(String serviceName) throws RangerServiceException {
        this.callAPI(DELETE_SERVICE_BY_NAME.applyUrlFormat(serviceName), null);
    }

    public RangerService getService(long serviceId) throws RangerServiceException {
        return this.callAPI(GET_SERVICE_BY_ID.applyUrlFormat(serviceId), null, null, RangerService.class);
    }

    public RangerService getService(String serviceName) throws RangerServiceException {
        return this.callAPI(GET_SERVICE_BY_NAME.applyUrlFormat(serviceName), null, null, RangerService.class);
    }

    public List<RangerService> findServices(Map<String, String> filter) throws RangerServiceException {
        return this.callAPI(FIND_SERVICES, filter, null, new GenericType<List<RangerService>>(){});
    }

    public RangerPolicy createPolicy(RangerPolicy policy) throws RangerServiceException {
        return this.callAPI(CREATE_POLICY, null, (Object)policy, RangerPolicy.class);
    }

    public RangerPolicy updatePolicy(long policyId, RangerPolicy policy) throws RangerServiceException {
        return this.callAPI(UPDATE_POLICY_BY_ID.applyUrlFormat(policyId), null, (Object)policy, RangerPolicy.class);
    }

    public RangerPolicy updatePolicy(String serviceName, String policyName, RangerPolicy policy) throws RangerServiceException {
        return this.callAPI(UPDATE_POLICY_BY_NAME.applyUrlFormat(serviceName, policyName), null, (Object)policy, RangerPolicy.class);
    }

    public RangerPolicy applyPolicy(RangerPolicy policy) throws RangerServiceException {
        return this.callAPI(APPLY_POLICY, null, (Object)policy, RangerPolicy.class);
    }

    public void deletePolicy(long policyId) throws RangerServiceException {
        this.callAPI(DELETE_POLICY_BY_ID.applyUrlFormat(policyId), null);
    }

    public void deletePolicy(String serviceName, String policyName) throws RangerServiceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(PARAM_POLICY_NAME, policyName);
        queryParams.put("servicename", serviceName);
        this.callAPI(DELETE_POLICY_BY_NAME, queryParams);
    }

    public RangerPolicy getPolicy(long policyId) throws RangerServiceException {
        return this.callAPI(GET_POLICY_BY_ID.applyUrlFormat(policyId), null, null, RangerPolicy.class);
    }

    public RangerPolicy getPolicy(String serviceName, String policyName) throws RangerServiceException {
        return this.callAPI(GET_POLICY_BY_NAME.applyUrlFormat(serviceName, policyName), null, null, RangerPolicy.class);
    }

    public List<RangerPolicy> getPoliciesInService(String serviceName) throws RangerServiceException {
        return this.callAPI(GET_POLICIES_IN_SERVICE.applyUrlFormat(serviceName), null, null, new GenericType<List<RangerPolicy>>(){});
    }

    public List<RangerPolicy> findPolicies(Map<String, String> filter) throws RangerServiceException {
        return this.callAPI(FIND_POLICIES, filter, null, new GenericType<List<RangerPolicy>>(){});
    }

    public RangerSecurityZone createSecurityZone(RangerSecurityZone securityZone) throws RangerServiceException {
        return this.callAPI(CREATE_ZONE, null, (Object)securityZone, RangerSecurityZone.class);
    }

    public RangerSecurityZone updateSecurityZone(long zoneId, RangerSecurityZone securityZone) throws RangerServiceException {
        return this.callAPI(UPDATE_ZONE_BY_ID.applyUrlFormat(zoneId), null, (Object)securityZone, RangerSecurityZone.class);
    }

    public RangerSecurityZone updateSecurityZone(String zoneName, RangerSecurityZone securityZone) throws RangerServiceException {
        return this.callAPI(UPDATE_ZONE_BY_NAME.applyUrlFormat(zoneName), null, (Object)securityZone, RangerSecurityZone.class);
    }

    public void deleteSecurityZone(long zoneId) throws RangerServiceException {
        this.callAPI(DELETE_ZONE_BY_ID.applyUrlFormat(zoneId), null);
    }

    public void deleteSecurityZone(String zoneName) throws RangerServiceException {
        this.callAPI(DELETE_ZONE_BY_NAME.applyUrlFormat(zoneName), null);
    }

    public RangerSecurityZone getSecurityZone(long zoneId) throws RangerServiceException {
        return this.callAPI(GET_ZONE_BY_ID.applyUrlFormat(zoneId), null, null, RangerSecurityZone.class);
    }

    public RangerSecurityZone getSecurityZone(String zoneName) throws RangerServiceException {
        return this.callAPI(GET_ZONE_BY_NAME.applyUrlFormat(zoneName), null, null, RangerSecurityZone.class);
    }

    public List<RangerSecurityZone> findSecurityZones(Map<String, String> filter) throws RangerServiceException {
        return this.callAPI(FIND_ZONES, filter, null, new GenericType<List<RangerSecurityZone>>(){});
    }

    public RangerRole createRole(String serviceName, RangerRole role) throws RangerServiceException {
        return this.callAPI(CREATE_ROLE, Collections.singletonMap(PARAM_SERVICE_NAME, serviceName), (Object)role, RangerRole.class);
    }

    public RangerRole updateRole(long roleId, RangerRole role) throws RangerServiceException {
        return this.callAPI(UPDATE_ROLE_BY_ID.applyUrlFormat(roleId), null, (Object)role, RangerRole.class);
    }

    public void deleteRole(long roleId) throws RangerServiceException {
        this.callAPI(DELETE_ROLE_BY_ID.applyUrlFormat(roleId), null);
    }

    public void deleteRole(String roleName, String execUser, String serviceName) throws RangerServiceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(PARAM_EXEC_USER, execUser);
        queryParams.put(PARAM_SERVICE_NAME, serviceName);
        this.callAPI(DELETE_ROLE_BY_NAME.applyUrlFormat(roleName), queryParams);
    }

    public RangerRole getRole(long roleId) throws RangerServiceException {
        return this.callAPI(GET_ROLE_BY_ID.applyUrlFormat(roleId), null, null, RangerRole.class);
    }

    public RangerRole getRole(String roleName, String execUser, String serviceName) throws RangerServiceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(PARAM_EXEC_USER, execUser);
        queryParams.put(PARAM_SERVICE_NAME, serviceName);
        return this.callAPI(GET_ROLE_BY_NAME.applyUrlFormat(roleName), queryParams, null, RangerRole.class);
    }

    public List<String> getAllRoleNames(String execUser, String serviceName) throws RangerServiceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(PARAM_EXEC_USER, execUser);
        queryParams.put(PARAM_SERVICE_NAME, serviceName);
        return this.callAPI(GET_ALL_ROLE_NAMES.applyUrlFormat(serviceName), queryParams, null, new GenericType<List<String>>(){});
    }

    public List<String> getUserRoles(String user) throws RangerServiceException {
        return this.callAPI(GET_USER_ROLES.applyUrlFormat(user), null, null, new GenericType<List<String>>(){});
    }

    public List<RangerRole> findRoles(Map<String, String> filter) throws RangerServiceException {
        return this.callAPI(FIND_ROLES, filter, null, new GenericType<List<RangerRole>>(){});
    }

    public RESTResponse grantRole(String serviceName, GrantRevokeRoleRequest request) throws RangerServiceException {
        return this.callAPI(GRANT_ROLE.applyUrlFormat(serviceName), null, (Object)request, RESTResponse.class);
    }

    public RESTResponse revokeRole(String serviceName, GrantRevokeRoleRequest request) throws RangerServiceException {
        return this.callAPI(REVOKE_ROLE.applyUrlFormat(serviceName), null, (Object)request, RESTResponse.class);
    }

    public List<RangerPluginInfo> getPluginsInfo() throws RangerServiceException {
        return this.callAPI(GET_PLUGIN_INFO, null, null, new GenericType<List<RangerPluginInfo>>(){});
    }

    public void deletePolicyDeltas(int days, boolean reloadServicePoliciesCache) throws RangerServiceException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(PARAM_DAYS, String.valueOf(days));
        queryParams.put(PARAM_RELOAD_SERVICE_POLICIES_CACHE, String.valueOf(reloadServicePoliciesCache));
        this.callAPI(DELETE_POLICY_DELTAS, queryParams);
    }

    private ClientResponse invokeREST(API api, Map<String, String> params, Object request) throws RangerServiceException {
        ClientResponse clientResponse;
        try {
            switch (api.getMethod()) {
                case "POST": {
                    clientResponse = this.restClient.post(api.getPath(), params, request);
                    break;
                }
                case "PUT": {
                    clientResponse = this.restClient.put(api.getPath(), params, request);
                    break;
                }
                case "GET": {
                    clientResponse = this.restClient.get(api.getPath(), params);
                    break;
                }
                case "DELETE": {
                    clientResponse = this.restClient.delete(api.getPath(), params);
                    break;
                }
                default: {
                    LOG.error(api.getMethod() + ": unsupported HTTP method");
                    clientResponse = null;
                    break;
                }
            }
        }
        catch (Exception excp) {
            throw new RangerServiceException(excp);
        }
        return clientResponse;
    }

    private ClientResponse responseHandler(API api, Map<String, String> params, Object request) throws RangerServiceException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Call         : {} {}", (Object)api.getMethod(), (Object)api.getNormalizedPath());
            LOG.debug("Content-type : {} ", (Object)api.getConsumes());
            LOG.debug("Accept       : {} ", (Object)api.getProduces());
            if (request != null) {
                LOG.debug("Request      : {}", request);
            }
        }
        ClientResponse clientResponse = this.isSecureMode ? Subject.doAs(this.sub, () -> {
            try {
                return this.invokeREST(api, params, request);
            }
            catch (RangerServiceException e) {
                LOG.error(e.getMessage());
                return null;
            }
        }) : this.invokeREST(api, params, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("method={}, path={}, contentType={}, accept={}, httpStatus={}", new Object[]{api.getMethod(), api.getNormalizedPath(), api.getConsumes(), api.getProduces(), clientResponse != null ? Integer.valueOf(clientResponse.getStatus()) : "null"});
        }
        if (clientResponse == null) {
            throw new RangerServiceException(api, null);
        }
        if (clientResponse.getStatus() == api.getExpectedStatus().getStatusCode()) {
            return clientResponse;
        }
        if (clientResponse.getStatus() != ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode()) {
            throw new RangerServiceException(api, clientResponse);
        }
        LOG.error("Ranger Admin unavailable. HTTP Status: {}", (Object)clientResponse.getStatus());
        return clientResponse;
    }

    private void callAPI(API api, Map<String, String> params) throws RangerServiceException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> callAPI({},{})", (Object)api, params);
        }
        this.responseHandler(api, params, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== callAPI({},{})", (Object)api, params);
        }
    }

    private <T> T callAPI(API api, Map<String, String> params, Object request, GenericType<T> responseType) throws RangerServiceException {
        Object ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> callAPI({},{},{})", new Object[]{api, params, request});
            LOG.debug("------------------------------------------------------");
        }
        ClientResponse clientResponse = this.responseHandler(api, params, request);
        if (responseType != null) {
            ret = clientResponse.getEntity(responseType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response: {}", (Object)this.restClient.toJson(ret));
                LOG.debug("------------------------------------------------------");
                LOG.debug("<== callAPI({},{},{},{}), result = {}", new Object[]{api, params, request, responseType, ret});
            }
        }
        return (T)ret;
    }

    private <T> T callAPI(API api, Map<String, String> params, Object request, Class<T> responseType) throws RangerServiceException {
        Object ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> callAPI({},{},{})", new Object[]{api, params, request});
            LOG.debug("------------------------------------------------------");
        }
        ClientResponse clientResponse = this.responseHandler(api, params, request);
        if (responseType != null) {
            ret = clientResponse.getEntity(responseType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response: {}", (Object)this.restClient.toJson(ret));
                LOG.debug("------------------------------------------------------");
                LOG.debug("<== callAPI({},{},{},{}), result = {}", new Object[]{api, params, request, responseType, ret});
            }
        }
        return (T)ret;
    }

    public static class API {
        private static final Logger LOG = LoggerFactory.getLogger(API.class);
        private final String path;
        private final String method;
        private final Response.Status expectedStatus;
        private final String consumes;
        private final String produces;

        public API(String path, String method, Response.Status expectedStatus) {
            this(path, method, expectedStatus, "application/json", "application/json");
        }

        public API(String path, String method, Response.Status expectedStatus, String consumes, String produces) {
            this.path = path;
            this.method = method;
            this.expectedStatus = expectedStatus;
            this.consumes = consumes;
            this.produces = produces;
        }

        public String getPath() {
            return this.path;
        }

        public String getMethod() {
            return this.method;
        }

        public Response.Status getExpectedStatus() {
            return this.expectedStatus;
        }

        public String getConsumes() {
            return this.consumes;
        }

        public String getProduces() {
            return this.produces;
        }

        public String getNormalizedPath() {
            String ret = null;
            try {
                URI uri = new URI(this.path);
                URI normalizedUri = uri.normalize();
                ret = normalizedUri.toString();
            }
            catch (Exception e) {
                LOG.error("getNormalizedPath() caught exception for path={}", (Object)this.path, (Object)e);
                ret = null;
            }
            return ret;
        }

        public API applyUrlFormat(Object ... params) throws RangerServiceException {
            try {
                return new API(String.format(this.path, params), this.method, this.expectedStatus, this.consumes, this.produces);
            }
            catch (IllegalFormatException e) {
                LOG.error("Arguments not formatted properly");
                throw new RangerServiceException(e);
            }
        }
    }
}

