/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.authentication.KeyVaultCredentials;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.crypto.key.KeyCert;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class AzureKeyVaultClientAuthenticator
extends KeyVaultCredentials {
    static final Logger logger = Logger.getLogger(AzureKeyVaultClientAuthenticator.class);
    private String authClientID;
    private String authClientSecret;

    public AzureKeyVaultClientAuthenticator(String clientID, String clientSecret) {
        this.authClientID = clientID;
        this.authClientSecret = clientSecret;
    }

    public AzureKeyVaultClientAuthenticator(String clientID) {
        this.authClientID = clientID;
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        AuthenticationResult token = AzureKeyVaultClientAuthenticator.getAccessTokenFromClientCredentials(authorization, resource, this.authClientID, this.authClientSecret);
        return token.getAccessToken();
    }

    private static AuthenticationResult getAccessTokenFromClientCredentials(String authorization, String resource, String clientId, String clientKey) {
        AuthenticationContext context = null;
        AuthenticationResult result = null;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            context = new AuthenticationContext(authorization, false, service);
            ClientCredential credentials = new ClientCredential(clientId, clientKey);
            Future future = context.acquireToken(resource, credentials, null);
            result = (AuthenticationResult)future.get();
        }
        catch (Exception e) {
            throw new RuntimeException(" Error while getting Access token for client id: " + clientId + " and client secret. Error : " + e);
        }
        finally {
            service.shutdown();
        }
        if (result == null) {
            throw new RuntimeException("authentication result was null");
        }
        return result;
    }

    public KeyVaultClient getAuthentication(String path, String certPassword) throws Exception {
        KeyCert keyCert = null;
        if (path.endsWith(".pfx")) {
            try {
                keyCert = this.readPfx(path, certPassword);
            }
            catch (Exception ex) {
                throw new Exception("Error while parsing pfx certificate. Error : " + ex);
            }
        }
        if (path.endsWith(".pem")) {
            try {
                keyCert = this.readPem(path, certPassword);
            }
            catch (Exception ex) {
                throw new Exception("Error while parsing pem certificate. Error : " + ex);
            }
        }
        final KeyCert certificateKey = keyCert;
        if (certificateKey != null) {
            final PrivateKey privateKey = certificateKey.getKey();
            KeyVaultClient keyVaultClient = new KeyVaultClient((ServiceClientCredentials)new KeyVaultCredentials(){

                public String doAuthenticate(String authorization, String resource, String scope) {
                    try {
                        AuthenticationContext context = new AuthenticationContext(authorization, false, Executors.newFixedThreadPool(1));
                        AsymmetricKeyCredential asymmetricKeyCredential = AsymmetricKeyCredential.create((String)AzureKeyVaultClientAuthenticator.this.authClientID, (PrivateKey)privateKey, (X509Certificate)certificateKey.getCertificate());
                        AuthenticationResult result = (AuthenticationResult)context.acquireToken(resource, asymmetricKeyCredential, null).get();
                        return result.getAccessToken();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while getting authenticated access token from azure key vault with certificate : " + e);
                    }
                }
            });
            return keyVaultClient;
        }
        return null;
    }

    private KeyCert readPem(String path, String password) throws IOException, CertificateException, OperatorCreationException, PKCSException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser pemParser = new PEMParser((Reader)new FileReader(new File(path)));
        PrivateKey privateKey = null;
        X509Certificate cert = null;
        Object object = pemParser.readObject();
        while (object != null) {
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof X509CertificateHolder) {
                cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)object);
            }
            if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo pinfo = (PKCS8EncryptedPrivateKeyInfo)object;
                InputDecryptorProvider provider = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(password.toCharArray());
                PrivateKeyInfo info = pinfo.decryptPrivateKeyInfo(provider);
                privateKey = converter.getPrivateKey(info);
            }
            if (object instanceof PrivateKeyInfo) {
                privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
            }
            object = pemParser.readObject();
        }
        KeyCert keycert = new KeyCert();
        keycert.setCertificate(cert);
        keycert.setKey(privateKey);
        pemParser.close();
        return keycert;
    }

    private KeyCert readPfx(String path, String password) throws NoSuchProviderException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        try (FileInputStream stream = new FileInputStream(path);){
            KeyCert keyCert = new KeyCert();
            boolean isAliasWithPrivateKey = false;
            KeyStore store = KeyStore.getInstance("pkcs12", "SunJSSE");
            store.load(stream, password.toCharArray());
            Enumeration<String> aliases = store.aliases();
            String alias = "";
            while (aliases.hasMoreElements() && !(isAliasWithPrivateKey = store.isKeyEntry(alias = aliases.nextElement()))) {
            }
            if (isAliasWithPrivateKey) {
                X509Certificate certificate = (X509Certificate)store.getCertificate(alias);
                PrivateKey key = (PrivateKey)store.getKey(alias, password.toCharArray());
                keyCert.setCertificate(certificate);
                keyCert.setKey(key);
            }
            KeyCert keyCert2 = keyCert;
            return keyCert2;
        }
    }
}

