/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.ConsoleUtil;
import org.apache.hadoop.crypto.key.RangerHSM;
import org.apache.hadoop.crypto.key.RangerKMSDB;
import org.apache.hadoop.crypto.key.RangerKeyStoreProvider;
import org.apache.hadoop.crypto.key.RangerMasterKey;
import org.apache.ranger.kms.dao.DaoManager;

public class HSM2DBMKUtil {
    private static final String ENCRYPTION_KEY = "ranger.db.encrypt.key.password";
    private static final String PARTITION_PASSWORD = "ranger.ks.hsm.partition.password";
    private static final String PARTITION_NAME = "ranger.ks.hsm.partition.name";
    private static final String HSM_TYPE = "ranger.ks.hsm.type";

    public static void showUsage() {
        System.err.println("USAGE: java " + HSM2DBMKUtil.class.getName() + " <HSMType> <partitionName>");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Invalid number of parameters found.");
            HSM2DBMKUtil.showUsage();
            System.exit(1);
        } else {
            String partitionName;
            String hsmType = args[0];
            if (hsmType == null || hsmType.trim().isEmpty()) {
                System.err.println("HSM Type does not exists.");
                HSM2DBMKUtil.showUsage();
                System.exit(1);
            }
            if ((partitionName = args[1]) == null || partitionName.trim().isEmpty()) {
                System.err.println("Partition name does not exists.");
                HSM2DBMKUtil.showUsage();
                System.exit(1);
            }
            new HSM2DBMKUtil().doImportMKFromHSM(hsmType, partitionName);
            System.out.println("Master Key from HSM has been successfully imported into Ranger KMS DB.");
            System.exit(0);
        }
    }

    private void doImportMKFromHSM(String hsmType, String partitionName) {
        char[] partitionPassword = null;
        try {
            partitionPassword = ConsoleUtil.getPasswordFromConsole("Enter Password for the Partition " + partitionName + " : ");
            Configuration conf = RangerKeyStoreProvider.getDBKSConf();
            conf.set(HSM_TYPE, hsmType);
            conf.set(PARTITION_NAME, partitionName);
            conf.set(PARTITION_PASSWORD, String.valueOf(partitionPassword));
            RangerKMSDB rangerkmsDb = new RangerKMSDB(conf);
            DaoManager daoManager = rangerkmsDb.getDaoManager();
            String password = conf.get(ENCRYPTION_KEY);
            RangerHSM rangerHSM = new RangerHSM(conf);
            String mKey = rangerHSM.getMasterKey(password);
            byte[] key = Base64.decode(mKey);
            RangerMasterKey rangerMasterKey = new RangerMasterKey(daoManager);
            rangerMasterKey.generateMKFromHSMMK(password, key);
        }
        catch (Throwable t) {
            try {
                throw new RuntimeException("Unable to import Master key from HSM to Ranger DB", t);
            }
            catch (Throwable throwable) {
                Arrays.fill(partitionPassword, ' ');
                throw throwable;
            }
        }
        Arrays.fill(partitionPassword, ' ');
    }
}

