/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.AzureKeyVaultClientAuthenticator;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.RangerHSM;
import org.apache.hadoop.crypto.key.RangerKMSDB;
import org.apache.hadoop.crypto.key.RangerKMSMKI;
import org.apache.hadoop.crypto.key.RangerKeyStore;
import org.apache.hadoop.crypto.key.RangerKeyVaultKeyGenerator;
import org.apache.hadoop.crypto.key.RangerMasterKey;
import org.apache.hadoop.crypto.key.RangerSafenetKeySecure;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.kms.dao.DaoManager;
import org.apache.ranger.plugin.util.JsonUtilsV2;

@InterfaceAudience.Private
public class RangerKeyStoreProvider
extends KeyProvider {
    static final Logger logger = Logger.getLogger(RangerKeyStoreProvider.class);
    public static final String SCHEME_NAME = "dbks";
    public static final String KMS_CONFIG_DIR = "kms.config.dir";
    public static final String DBKS_SITE_XML = "dbks-site.xml";
    public static final String ENCRYPTION_KEY = "ranger.db.encrypt.key.password";
    private static final String KEY_METADATA = "KeyMetadata";
    private static final String CREDENTIAL_PATH = "ranger.ks.jpa.jdbc.credential.provider.path";
    private static final String MK_CREDENTIAL_ALIAS = "ranger.ks.masterkey.credential.alias";
    private static final String DB_CREDENTIAL_ALIAS = "ranger.ks.jpa.jdbc.credential.alias";
    private static final String DB_PASSWORD = "ranger.ks.jpa.jdbc.password";
    private static final String HSM_ENABLED = "ranger.ks.hsm.enabled";
    private static final String HSM_PARTITION_PASSWORD_ALIAS = "ranger.ks.hsm.partition.password.alias";
    private static final String HSM_PARTITION_PASSWORD = "ranger.ks.hsm.partition.password";
    private static final String KEYSECURE_ENABLED = "ranger.kms.keysecure.enabled";
    private static final String KEYSECURE_USERNAME = "ranger.kms.keysecure.login.username";
    private static final String KEYSECURE_PASSWORD_ALIAS = "ranger.kms.keysecure.login.password.alias";
    private static final String KEYSECURE_PASSWORD = "ranger.kms.keysecure.login.password";
    private static final String KEYSECURE_LOGIN = "ranger.kms.keysecure.login";
    private static final String AZURE_KEYVAULT_ENABLED = "ranger.kms.azurekeyvault.enabled";
    private static final String AZURE_KEYVAULT_SSL_ENABLED = "ranger.kms.azure.keyvault.ssl.enabled";
    private static final String AZURE_CLIENT_ID = "ranger.kms.azure.client.id";
    private static final String AZURE_CLIENT_SECRET_ALIAS = "ranger.kms.azure.client.secret.alias";
    private static final String AZURE_CLIENT_SECRET = "ranger.kms.azure.client.secret";
    private static final String AZURE_KEYVAULT_CERTIFICATE_PATH = "ranger.kms.azure.keyvault.certificate.path";
    private static final String AZURE_KEYVAULT_CERTIFICATE_PASSWORD = "ranger.kms.azure.keyvault.certificate.password";
    private final RangerKeyStore dbStore;
    private char[] masterKey;
    private boolean changed = false;
    private final Map<String, KeyProvider.Metadata> cache = new HashMap<String, KeyProvider.Metadata>();
    private DaoManager daoManager;
    private Lock readLock;
    private boolean azureKeyVaultEnabled = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerKeyStoreProvider(Configuration conf) throws Throwable {
        super(conf);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.Configuration(conf)");
        }
        conf = RangerKeyStoreProvider.getDBKSConf();
        RangerKeyStoreProvider.getFromJceks(conf, CREDENTIAL_PATH, MK_CREDENTIAL_ALIAS, ENCRYPTION_KEY);
        RangerKeyStoreProvider.getFromJceks(conf, CREDENTIAL_PATH, DB_CREDENTIAL_ALIAS, DB_PASSWORD);
        RangerKeyStoreProvider.getFromJceks(conf, CREDENTIAL_PATH, HSM_PARTITION_PASSWORD_ALIAS, HSM_PARTITION_PASSWORD);
        RangerKMSDB rangerKMSDB = new RangerKMSDB(conf);
        this.daoManager = rangerKMSDB.getDaoManager();
        RangerKMSMKI rangerMasterKey = null;
        String password = conf.get(ENCRYPTION_KEY);
        if (password == null || password.trim().equals("") || password.trim().equals("_") || password.trim().equals("crypted")) {
            throw new IOException("The Ranger MasterKey Password is empty or not a valid Password");
        }
        if (StringUtils.isEmpty((String)conf.get(HSM_ENABLED)) || conf.get(HSM_ENABLED).equalsIgnoreCase("false")) {
            logger.info((Object)"Ranger KMS Database is enabled for storing master key.");
            rangerMasterKey = new RangerMasterKey(this.daoManager);
        } else {
            logger.info((Object)"Ranger KMS HSM is enabled for storing master key.");
            rangerMasterKey = new RangerHSM(conf);
            String partitionPasswd = conf.get(HSM_PARTITION_PASSWORD);
            if (partitionPasswd == null || partitionPasswd.trim().equals("") || partitionPasswd.trim().equals("_") || partitionPasswd.trim().equals("crypted")) {
                throw new IOException("Partition Password doesn't exists");
            }
        }
        if (conf != null && StringUtils.isNotEmpty((String)conf.get(KEYSECURE_ENABLED)) && conf.get(KEYSECURE_ENABLED).equalsIgnoreCase("true")) {
            RangerKeyStoreProvider.getFromJceks(conf, CREDENTIAL_PATH, KEYSECURE_PASSWORD_ALIAS, KEYSECURE_PASSWORD);
            String keySecureLoginCred = conf.get(KEYSECURE_USERNAME).trim() + ":" + conf.get(KEYSECURE_PASSWORD);
            conf.set(KEYSECURE_LOGIN, keySecureLoginCred);
            rangerMasterKey = new RangerSafenetKeySecure(conf);
            this.dbStore = new RangerKeyStore(this.daoManager);
            rangerMasterKey.generateMasterKey(password);
            try {
                this.masterKey = rangerMasterKey.getMasterKey(password).toCharArray();
            }
            catch (Exception ex) {
                throw new Exception("Error while getting Safenet KeySecure master key " + ex);
            }
        }
        if (conf != null && StringUtils.isNotEmpty((String)conf.get(AZURE_KEYVAULT_ENABLED)) && conf.get(AZURE_KEYVAULT_ENABLED).equalsIgnoreCase("true")) {
            this.azureKeyVaultEnabled = true;
            RangerKeyStoreProvider.getFromJceks(conf, CREDENTIAL_PATH, AZURE_CLIENT_SECRET_ALIAS, AZURE_CLIENT_SECRET);
            String azureClientId = conf.get(AZURE_CLIENT_ID);
            if (StringUtils.isEmpty((String)azureClientId)) {
                throw new Exception("Azure Key Vault is enabled and client id is not configured");
            }
            String azureClientSecret = conf.get(AZURE_CLIENT_SECRET);
            KeyVaultClient kvClient = null;
            if (conf != null && StringUtils.isNotEmpty((String)conf.get(AZURE_KEYVAULT_SSL_ENABLED)) && conf.get(AZURE_KEYVAULT_SSL_ENABLED).equalsIgnoreCase("false")) {
                try {
                    if (StringUtils.isEmpty((String)azureClientSecret)) {
                        throw new Exception("Azure Key Vault is enabled in non SSL mode and client password/secret is not configured");
                    }
                    AzureKeyVaultClientAuthenticator azureKVClientAuthenticator = new AzureKeyVaultClientAuthenticator(azureClientId, azureClientSecret);
                    kvClient = new KeyVaultClient((ServiceClientCredentials)azureKVClientAuthenticator);
                }
                catch (Exception ex) {
                    throw new Exception("Error while getting key vault client object with client id and client secret : " + ex);
                }
            }
            try {
                AzureKeyVaultClientAuthenticator azureKVClientAuthenticator = new AzureKeyVaultClientAuthenticator(azureClientId);
                String keyVaultCertPath = conf.get(AZURE_KEYVAULT_CERTIFICATE_PATH);
                if (StringUtils.isEmpty((String)keyVaultCertPath)) {
                    throw new Exception("Azure Key Vault is enabled in SSL mode. Please provide certificate path for authentication.");
                }
                String keyVaultCertPassword = conf.get(AZURE_KEYVAULT_CERTIFICATE_PASSWORD);
                kvClient = !StringUtils.isEmpty((String)keyVaultCertPassword) ? azureKVClientAuthenticator.getAuthentication(keyVaultCertPath, keyVaultCertPassword) : azureKVClientAuthenticator.getAuthentication(keyVaultCertPath, "");
            }
            catch (Exception ex) {
                throw new Exception("Error while getting key vault client object with client id and certificate. Error :  : " + ex);
            }
            boolean success = false;
            if (kvClient == null) throw new Exception("Unable to get Key Vault Client. Please check the azure credentials.");
            try {
                this.dbStore = new RangerKeyStore(this.daoManager, conf, kvClient);
                rangerMasterKey = new RangerKeyVaultKeyGenerator(conf, kvClient);
                if (rangerMasterKey != null) {
                    success = rangerMasterKey.generateMasterKey(password);
                }
            }
            catch (Exception ex) {
                throw new Exception("Error while generating master key and master key secret in Azure key vault. Error :  : " + ex);
            }
            if (success) {
                try {
                    this.masterKey = null;
                }
                catch (Exception ex) {
                    throw new Exception("Error while getting Azure Master key Secret. Error : " + ex);
                }
            }
        } else {
            this.dbStore = new RangerKeyStore(this.daoManager);
            rangerMasterKey.generateMasterKey(password);
            try {
                this.masterKey = rangerMasterKey.getMasterKey(password).toCharArray();
            }
            catch (Exception ex) {
                throw new Exception("Error while getting Ranger Master key " + ex);
            }
        }
        this.reloadKeys();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
    }

    public static Configuration getDBKSConf() {
        Configuration newConfig = RangerKeyStoreProvider.getConfiguration(true, DBKS_SITE_XML);
        RangerKeyStoreProvider.getFromJceks(newConfig, CREDENTIAL_PATH, MK_CREDENTIAL_ALIAS, ENCRYPTION_KEY);
        RangerKeyStoreProvider.getFromJceks(newConfig, CREDENTIAL_PATH, DB_CREDENTIAL_ALIAS, DB_PASSWORD);
        return newConfig;
    }

    static Configuration getConfiguration(boolean loadHadoopDefaults, String ... resources) {
        Configuration conf = new Configuration(loadHadoopDefaults);
        String confDir = System.getProperty(KMS_CONFIG_DIR);
        if (confDir != null) {
            try {
                Path confPath = new Path(confDir);
                if (!confPath.isUriPathAbsolute()) {
                    throw new RuntimeException("System property 'kms.config.dir' must be an absolute path: " + confDir);
                }
                for (String resource : resources) {
                    conf.addResource(new URL("file://" + new Path(confDir, resource).toUri()));
                }
            }
            catch (MalformedURLException ex) {
                logger.error((Object)"==> RangerKeyStoreProvider.getConfiguration() error : ", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        } else {
            for (String resource : resources) {
                conf.addResource(resource);
            }
        }
        return conf;
    }

    private void loadKeys(char[] masterKey) throws NoSuchAlgorithmException, CertificateException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.loadKeys()");
        }
        this.dbStore.engineLoad(null, masterKey);
    }

    public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.createKey()");
        }
        this.reloadKeys();
        if (this.dbStore.engineContainsAlias(name) || this.cache.containsKey(name)) {
            throw new IOException("Key " + name + " already exists");
        }
        KeyProvider.Metadata meta = new KeyProvider.Metadata(options.getCipher(), options.getBitLength(), options.getDescription(), options.getAttributes(), new Date(), 1);
        if (options.getBitLength() != 8 * material.length) {
            throw new IOException("Wrong key length. Required " + options.getBitLength() + ", but got " + 8 * material.length);
        }
        this.cache.put(name, meta);
        String versionName = RangerKeyStoreProvider.buildVersionName((String)name, (int)0);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerKeyStoreProvider.createKey()");
        }
        return this.innerSetKeyVersion(name, versionName, material, meta.getCipher(), meta.getBitLength(), meta.getDescription(), meta.getVersions(), meta.getAttributes());
    }

    KeyProvider.KeyVersion innerSetKeyVersion(String name, String versionName, byte[] material, String cipher, int bitLength, String description, int version, Map<String, String> attributes) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.innerSetKeyVersion()");
            logger.debug((Object)("name : " + name + " and versionName : " + versionName));
        }
        try {
            String attribute = JsonUtilsV2.mapToJson(attributes);
            if (this.azureKeyVaultEnabled) {
                this.dbStore.addSecureKeyByteEntry(versionName, new SecretKeySpec(material, cipher), cipher, bitLength, description, version, attribute);
            } else {
                this.dbStore.addKeyEntry(versionName, new SecretKeySpec(material, cipher), this.masterKey, cipher, bitLength, description, version, attribute);
            }
        }
        catch (Exception e) {
            throw new IOException("Can't store key " + versionName, e);
        }
        this.changed = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerKeyStoreProvider.innerSetKeyVersion()");
        }
        return new KeyProvider.KeyVersion(name, versionName, material);
    }

    public void deleteKey(String name) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("==> RangerKeyStoreProvider.deleteKey(" + name + ")"));
        }
        this.reloadKeys();
        KeyProvider.Metadata meta = this.getMetadata(name);
        if (meta == null) {
            throw new IOException("Key " + name + " does not exist");
        }
        for (int v = 0; v < meta.getVersions(); ++v) {
            String versionName = RangerKeyStoreProvider.buildVersionName((String)name, (int)v);
            try {
                if (!this.dbStore.engineContainsAlias(versionName)) continue;
                this.dbStore.engineDeleteEntry(versionName);
                continue;
            }
            catch (KeyStoreException e) {
                throw new IOException("Problem removing " + versionName, e);
            }
        }
        try {
            if (this.dbStore.engineContainsAlias(name)) {
                this.dbStore.engineDeleteEntry(name);
            }
        }
        catch (KeyStoreException e) {
            throw new IOException("Problem removing " + name + " from " + (Object)((Object)this), e);
        }
        this.cache.remove(name);
        this.changed = true;
    }

    public void flush() throws IOException {
        try {
            if (!this.changed) {
                return;
            }
            for (Map.Entry<String, KeyProvider.Metadata> entry : this.cache.entrySet()) {
                try {
                    KeyProvider.Metadata metadata = entry.getValue();
                    String attributes = JsonUtilsV2.mapToJson((Map)metadata.getAttributes());
                    if (this.azureKeyVaultEnabled) {
                        Key ezkey = new KeyMetadata(metadata);
                        if (ezkey.getEncoded().length == 0) {
                            KeyGenerator keyGenerator = KeyGenerator.getInstance(metadata.getAlgorithm());
                            keyGenerator.init(metadata.getBitLength());
                            byte[] key = keyGenerator.generateKey().getEncoded();
                            ezkey = new SecretKeySpec(key, metadata.getCipher());
                        }
                        this.dbStore.addSecureKeyByteEntry(entry.getKey(), ezkey, metadata.getCipher(), metadata.getBitLength(), metadata.getDescription(), metadata.getVersions(), attributes);
                        continue;
                    }
                    this.dbStore.addKeyEntry(entry.getKey(), new KeyMetadata(metadata), this.masterKey, metadata.getAlgorithm(), metadata.getBitLength(), metadata.getDescription(), metadata.getVersions(), attributes);
                }
                catch (Exception e) {
                    throw new IOException("Can't set metadata key " + entry.getKey(), e);
                }
            }
            try {
                this.dbStore.engineStore(null, this.masterKey);
                this.reloadKeys();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("No such algorithm storing key", e);
            }
            catch (CertificateException e) {
                throw new IOException("Certificate exception storing key", e);
            }
            this.changed = false;
        }
        catch (IOException ioe) {
            this.cache.clear();
            this.reloadKeys();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        this.readLock.lock();
        try {
            if (this.azureKeyVaultEnabled) {
                byte[] decryptKeyByte = null;
                try {
                    if (!this.dbStore.engineContainsAlias(versionName)) {
                        this.dbStore.engineLoad(null, this.masterKey);
                        if (!this.dbStore.engineContainsAlias(versionName)) {
                            KeyProvider.KeyVersion keyVersion = null;
                            return keyVersion;
                        }
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException("Can't get algorithm for key " + e.getMessage());
                }
                catch (CertificateException e) {
                    throw new IOException("Certificate exception storing key", e);
                }
                try {
                    decryptKeyByte = this.dbStore.engineGetDecryptedZoneKeyByte(versionName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while getting decrypted key." + e);
                }
                if (decryptKeyByte != null && decryptKeyByte.length != 0) {
                    KeyProvider.KeyVersion e = new KeyProvider.KeyVersion(RangerKeyStoreProvider.getBaseName((String)versionName), versionName, decryptKeyByte);
                    return e;
                }
                KeyProvider.KeyVersion e = null;
                return e;
            }
            SecretKeySpec key = null;
            try {
                if (!this.dbStore.engineContainsAlias(versionName)) {
                    this.dbStore.engineLoad(null, this.masterKey);
                    if (!this.dbStore.engineContainsAlias(versionName)) {
                        KeyProvider.KeyVersion e = null;
                        return e;
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("Can't get algorithm for key " + key, e);
            }
            catch (UnrecoverableKeyException e) {
                throw new IOException("Can't recover key " + key, e);
            }
            catch (CertificateException e) {
                throw new IOException("Certificate exception storing key", e);
            }
            key = (SecretKeySpec)this.dbStore.engineGetKey(versionName, this.masterKey);
            if (key == null) {
                KeyProvider.KeyVersion keyVersion = null;
                return keyVersion;
            }
            KeyProvider.KeyVersion keyVersion = new KeyProvider.KeyVersion(RangerKeyStoreProvider.getBaseName((String)versionName), versionName, key.getEncoded());
            return keyVersion;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        ArrayList<KeyProvider.KeyVersion> list = new ArrayList<KeyProvider.KeyVersion>();
        KeyProvider.Metadata km = this.getMetadata(name);
        if (km != null) {
            int latestVersion = km.getVersions();
            KeyProvider.KeyVersion v = null;
            String versionName = null;
            for (int i = 0; i < latestVersion; ++i) {
                versionName = RangerKeyStoreProvider.buildVersionName((String)name, (int)i);
                v = this.getKeyVersion(versionName);
                if (v == null) continue;
                list.add(v);
            }
        }
        return list;
    }

    public List<String> getKeys() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        String alias = null;
        this.reloadKeys();
        Enumeration<String> e = this.dbStore.engineAliases();
        while (e.hasMoreElements()) {
            alias = e.nextElement();
            if (alias.contains("@")) continue;
            list.add(alias);
        }
        return list;
    }

    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        try {
            this.readLock.lock();
            if (this.cache.containsKey(name)) {
                KeyProvider.Metadata meta;
                KeyProvider.Metadata metadata = meta = this.cache.get(name);
                return metadata;
            }
            if (!this.dbStore.engineContainsAlias(name)) {
                this.dbStore.engineLoad(null, this.masterKey);
                if (!this.dbStore.engineContainsAlias(name)) {
                    KeyProvider.Metadata meta = null;
                    return meta;
                }
            }
            if (this.azureKeyVaultEnabled) {
                KeyProvider.Metadata meta = this.dbStore.engineGetKeyMetadata(name);
                if (meta != null) {
                    this.cache.put(name, meta);
                    KeyProvider.Metadata metadata = meta;
                    return metadata;
                }
            } else {
                Key key = this.dbStore.engineGetKey(name, this.masterKey);
                if (key != null) {
                    KeyProvider.Metadata meta = ((KeyMetadata)key).metadata;
                    this.cache.put(name, meta);
                    KeyProvider.Metadata metadata = meta;
                    return metadata;
                }
            }
            KeyProvider.Metadata e = null;
            return e;
        }
        catch (Exception e) {
            throw new IOException("Please try again ", e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.rollNewVersion()");
        }
        this.reloadKeys();
        KeyProvider.Metadata meta = this.getMetadata(name);
        if (meta == null) {
            throw new IOException("Key " + name + " not found");
        }
        if (meta.getBitLength() != 8 * material.length) {
            throw new IOException("Wrong key length. Required " + meta.getBitLength() + ", but got " + 8 * material.length);
        }
        int nextVersion = meta.addVersion();
        String versionName = RangerKeyStoreProvider.buildVersionName((String)name, (int)nextVersion);
        return this.innerSetKeyVersion(name, versionName, material, meta.getCipher(), meta.getBitLength(), meta.getDescription(), meta.getVersions(), meta.getAttributes());
    }

    private static void getFromJceks(Configuration conf, String path, String alias, String key) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.getFromJceks()");
        }
        if (conf != null) {
            String pathValue = conf.get(path);
            String aliasValue = conf.get(alias);
            if (pathValue != null && aliasValue != null) {
                String storeType = conf.get("ranger.keystore.file.type", KeyStore.getDefaultType());
                String xaDBPassword = CredentialReader.getDecryptedString((String)pathValue.trim(), (String)aliasValue.trim(), (String)storeType);
                if (xaDBPassword != null && !xaDBPassword.trim().isEmpty() && !xaDBPassword.trim().equalsIgnoreCase("none")) {
                    conf.set(key, xaDBPassword);
                } else {
                    logger.info((Object)"Credential keystore password not applied for KMS; clear text password shall be applicable");
                }
            }
        }
    }

    private void reloadKeys() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerKeyStoreProvider.reloadKeys()");
        }
        try {
            this.cache.clear();
            this.loadKeys(this.masterKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Can't load Keys");
        }
        catch (CertificateException e) {
            throw new IOException("Can't load Keys");
        }
    }

    public static class KeyMetadata
    implements Key,
    Serializable {
        KeyProvider.Metadata metadata;
        private static final long serialVersionUID = 8405872419967874451L;

        protected KeyMetadata(KeyProvider.Metadata meta) {
            this.metadata = meta;
        }

        @Override
        public String getAlgorithm() {
            return this.metadata.getCipher();
        }

        @Override
        public String getFormat() {
            return RangerKeyStoreProvider.KEY_METADATA;
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            byte[] serialized = this.metadata.serialize();
            out.writeInt(serialized.length);
            out.write(serialized);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            this.metadata = new KeyProvider.Metadata(buf);
        }
    }

    public static class Factory
    extends KeyProviderFactory {
        public KeyProvider createProvider(URI providerName, Configuration conf) throws IOException {
            try {
                if (RangerKeyStoreProvider.SCHEME_NAME.equals(providerName.getScheme())) {
                    return new RangerKeyStoreProvider(conf);
                }
            }
            catch (Throwable e) {
                logger.error((Object)"==> RangerKeyStoreProvider.reloadKeys() error : ", e);
            }
            return null;
        }
    }
}

