/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.BaseAuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.queue.AuditFileSpool;

public abstract class AuditQueue
extends BaseAuditHandler {
    private static final Log LOG = LogFactory.getLog(AuditQueue.class);
    public static final int AUDIT_MAX_QUEUE_SIZE_DEFAULT = 0x100000;
    public static final int AUDIT_BATCH_INTERVAL_DEFAULT_MS = 3000;
    public static final int AUDIT_BATCH_SIZE_DEFAULT = 1000;
    public static final int AUDIT_CONSUMER_THREAD_WAIT_MS = 5000;
    private int maxQueueSize = 0x100000;
    private int maxBatchInterval = 3000;
    private int maxBatchSize = 1000;
    public static final String PROP_QUEUE = "queue";
    public static final String PROP_BATCH_SIZE = "batch.size";
    public static final String PROP_QUEUE_SIZE = "queue.size";
    public static final String PROP_BATCH_INTERVAL = "batch.interval.ms";
    public static final String PROP_FILE_SPOOL_ENABLE = "filespool.enable";
    public static final String PROP_FILE_SPOOL_WAIT_FOR_FULL_DRAIN = "filespool.drain.full.wait.ms";
    public static final String PROP_FILE_SPOOL_QUEUE_THRESHOLD = "filespool.drain.threshold.percent";
    protected final AuditHandler consumer;
    protected AuditFileSpool fileSpooler = null;
    private boolean isDrain = false;
    protected boolean fileSpoolerEnabled = false;
    protected int fileSpoolMaxWaitTime = 300000;
    protected int fileSpoolDrainThresholdPercent = 80;
    boolean isConsumerDestination = false;
    protected long stopTime = 0L;

    public AuditQueue(AuditHandler consumer) {
        this.consumer = consumer;
        if (consumer instanceof BaseAuditHandler) {
            BaseAuditHandler baseAuditHander = (BaseAuditHandler)consumer;
            baseAuditHander.setParentPath(this.getName());
        }
        if (consumer != null && consumer instanceof AuditDestination) {
            this.isConsumerDestination = true;
        }
    }

    @Override
    public void init(Properties props, String basePropertyName) {
        LOG.info((Object)"BaseAuditProvider.init()");
        super.init(props, basePropertyName);
        this.setMaxBatchSize(MiscUtil.getIntProperty(props, this.propPrefix + "." + PROP_BATCH_SIZE, this.getMaxBatchSize()));
        this.setMaxQueueSize(MiscUtil.getIntProperty(props, this.propPrefix + "." + PROP_QUEUE_SIZE, this.getMaxQueueSize()));
        this.setMaxBatchInterval(MiscUtil.getIntProperty(props, this.propPrefix + "." + PROP_BATCH_INTERVAL, this.getMaxBatchInterval()));
        this.fileSpoolerEnabled = MiscUtil.getBooleanProperty(props, this.propPrefix + "." + PROP_FILE_SPOOL_ENABLE, false);
        String logFolderProp = MiscUtil.getStringProperty(props, this.propPrefix + "." + "filespool.dir");
        if (this.fileSpoolerEnabled || logFolderProp != null) {
            LOG.info((Object)("File spool is enabled for " + this.getName() + ", logFolderProp=" + logFolderProp + ", " + this.propPrefix + "." + "filespool.dir" + "=" + this.fileSpoolerEnabled));
            this.fileSpoolerEnabled = true;
            this.fileSpoolMaxWaitTime = MiscUtil.getIntProperty(props, this.propPrefix + "." + PROP_FILE_SPOOL_WAIT_FOR_FULL_DRAIN, this.fileSpoolMaxWaitTime);
            this.fileSpoolDrainThresholdPercent = MiscUtil.getIntProperty(props, this.propPrefix + "." + PROP_FILE_SPOOL_QUEUE_THRESHOLD, this.fileSpoolDrainThresholdPercent);
            this.fileSpooler = new AuditFileSpool(this, this.consumer);
            if (!this.fileSpooler.init(props, basePropertyName)) {
                this.fileSpoolerEnabled = false;
                LOG.fatal((Object)("Couldn't initialize file spooler. Disabling it. queue=" + this.getName() + ", consumer=" + this.consumer.getName()));
            }
        } else {
            LOG.info((Object)("File spool is disabled for " + this.getName()));
        }
    }

    @Override
    public void setParentPath(String parentPath) {
        super.setParentPath(parentPath);
        if (this.consumer != null && this.consumer instanceof BaseAuditHandler) {
            BaseAuditHandler base = (BaseAuditHandler)this.consumer;
            base.setParentPath(this.getName());
        }
    }

    @Override
    public String getFinalPath() {
        if (this.consumer != null) {
            if (this.consumer instanceof BaseAuditHandler) {
                return ((BaseAuditHandler)this.consumer).getFinalPath();
            }
            return this.consumer.getName();
        }
        return this.getName();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.consumer != null && this.consumer instanceof BaseAuditHandler) {
            BaseAuditHandler base = (BaseAuditHandler)this.consumer;
            base.setParentPath(this.getName());
        }
    }

    public AuditHandler getConsumer() {
        return this.consumer;
    }

    public boolean isDrainMaxTimeElapsed() {
        return this.stopTime - System.currentTimeMillis() > 5000L;
    }

    public boolean isDrain() {
        return this.isDrain;
    }

    public void setDrain(boolean isDrain) {
        if (isDrain && this.stopTime != 0L) {
            this.stopTime = System.currentTimeMillis();
        }
        this.isDrain = isDrain;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxBatchInterval() {
        return this.maxBatchInterval;
    }

    public void setMaxBatchInterval(int maxBatchInterval) {
        this.maxBatchInterval = maxBatchInterval;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    public void waitToComplete() {
        if (this.consumer != null) {
            this.consumer.waitToComplete(-1L);
        }
    }

    @Override
    public void waitToComplete(long timeout) {
        if (this.consumer != null) {
            this.consumer.waitToComplete(timeout);
        }
    }

    @Override
    public void flush() {
        if (this.consumer != null) {
            this.consumer.flush();
        }
    }
}

