/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.destination;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.audit.destination.AuditDestination;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.RollingTimeUtil;

public class HDFSAuditDestination
extends AuditDestination {
    private static final Log logger = LogFactory.getLog(HDFSAuditDestination.class);
    public static final String PROP_HDFS_DIR = "dir";
    public static final String PROP_HDFS_SUBDIR = "subdir";
    public static final String PROP_HDFS_FILE_NAME_FORMAT = "filename.format";
    public static final String PROP_HDFS_ROLLOVER = "file.rollover.sec";
    public static final String PROP_HDFS_ROLLOVER_PERIOD = "file.rollover.period";
    int fileRolloverSec = 86400;
    private String logFileNameFormat;
    private String rolloverPeriod;
    boolean initDone = false;
    private String logFolder;
    private PrintWriter logWriter = null;
    volatile FSDataOutputStream ostream = null;
    private String currentFileName;
    private boolean isStopped = false;
    private RollingTimeUtil rollingTimeUtil = null;
    private Date nextRollOverTime = null;
    private boolean rollOverByDuration = false;

    @Override
    public void init(Properties prop, String propPrefix) {
        super.init(prop, propPrefix);
        String logFolderProp = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_HDFS_DIR);
        if (logFolderProp == null || logFolderProp.isEmpty()) {
            logger.fatal((Object)("File destination folder is not configured. Please set " + propPrefix + "." + PROP_HDFS_DIR + ". name=" + this.getName()));
            return;
        }
        String logSubFolder = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_HDFS_SUBDIR);
        if (logSubFolder == null || logSubFolder.isEmpty()) {
            logSubFolder = "%app-type%/%time:yyyyMMdd%";
        }
        this.logFileNameFormat = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_HDFS_FILE_NAME_FORMAT);
        this.fileRolloverSec = MiscUtil.getIntProperty(this.props, propPrefix + "." + PROP_HDFS_ROLLOVER, this.fileRolloverSec);
        if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
            this.logFileNameFormat = "%app-type%_ranger_audit_%hostname%.log";
        }
        this.logFolder = logFolderProp + "/" + logSubFolder;
        logger.info((Object)("logFolder=" + this.logFolder + ", destName=" + this.getName()));
        logger.info((Object)("logFileNameFormat=" + this.logFileNameFormat + ", destName=" + this.getName()));
        logger.info((Object)("config=" + this.configProps.toString()));
        this.rolloverPeriod = MiscUtil.getStringProperty(this.props, propPrefix + "." + PROP_HDFS_ROLLOVER_PERIOD);
        this.rollingTimeUtil = RollingTimeUtil.getInstance();
        if (StringUtils.isEmpty((String)this.rolloverPeriod)) {
            this.rolloverPeriod = this.rollingTimeUtil.convertRolloverSecondsToRolloverPeriod(this.fileRolloverSec);
        }
        try {
            this.nextRollOverTime = this.rollingTimeUtil.computeNextRollingTime(this.rolloverPeriod);
        }
        catch (Exception e) {
            logger.warn((Object)"Rollover by file.rollover.period failed...will be using the file.rollover.sec for hdfs audit file rollover...", (Throwable)e);
            this.rollOverByDuration = true;
            this.nextRollOverTime = this.rollOverByDuration();
        }
        this.initDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean logJSON(final Collection<String> events) {
        this.logStatusIfRequired();
        this.addTotalCount(events.size());
        if (!this.initDone) {
            this.addDeferredCount(events.size());
            return false;
        }
        if (this.isStopped) {
            this.addDeferredCount(events.size());
            this.logError("log() called after stop was requested. name=" + this.getName());
            return false;
        }
        PrintWriter out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UGI=" + MiscUtil.getUGILoginUser() + ". Will write to HDFS file=" + this.currentFileName));
            }
            if ((out = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<PrintWriter>(){

                @Override
                public PrintWriter run() throws Exception {
                    PrintWriter out = HDFSAuditDestination.this.getLogFileStream();
                    for (String event : events) {
                        out.println(event);
                    }
                    return out;
                }
            })).checkError()) {
                this.addDeferredCount(events.size());
                out.close();
                this.logWriter = null;
                this.ostream = null;
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable t) {
            this.addDeferredCount(events.size());
            this.logError("Error writing to log file.", t);
            boolean bl = false;
            return bl;
        }
        finally {
            logger.info((Object)("Flushing HDFS audit. Event Size:" + events.size()));
            if (out != null) {
                out.flush();
            }
        }
        this.addSuccessCount(events.size());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        logger.info((Object)("Flush called. name=" + this.getName()));
        if (this.ostream != null) {
            try {
                HDFSAuditDestination hDFSAuditDestination = this;
                synchronized (hDFSAuditDestination) {
                    if (this.ostream != null) {
                        this.ostream.hflush();
                    }
                    logger.info((Object)"Flush HDFS audit logs completed.....");
                }
            }
            catch (IOException e) {
                logger.error((Object)("Error on flushing log writer: " + e.getMessage() + "\nException will be ignored. name=" + this.getName() + ", fileName=" + this.currentFileName));
            }
        }
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        if (this.isStopped) {
            this.logStatusIfRequired();
            this.addTotalCount(events.size());
            this.addDeferredCount(events.size());
            this.logError("log() called after stop was requested. name=" + this.getName());
            return false;
        }
        ArrayList<String> jsonList = new ArrayList<String>();
        for (AuditEventBase event : events) {
            try {
                jsonList.add(MiscUtil.stringify(event));
            }
            catch (Throwable t) {
                logger.error((Object)("Error converting to JSON. event=" + event));
                this.addTotalCount(1);
                this.addFailedCount(1);
                this.logFailedEvent(event);
            }
        }
        return this.logJSON(jsonList);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        this.isStopped = true;
        if (this.logWriter != null) {
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error((Object)("Error on closing log writter. Exception will be ignored. name=" + this.getName() + ", fileName=" + this.currentFileName));
            }
            this.logWriter = null;
            this.ostream = null;
        }
        this.logStatus();
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.logWriter == null) {
            String fullPath;
            Date currentTime = new Date();
            String fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            String parentFolder = MiscUtil.replaceTokens(this.logFolder, currentTime.getTime());
            Configuration conf = this.createConfiguration();
            String defaultPath = fullPath = parentFolder + "/" + fileName;
            URI uri = URI.create(fullPath);
            FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)conf);
            Path hdfPath = new Path(fullPath);
            logger.info((Object)("Checking whether log file exists. hdfPath=" + fullPath + ", UGI=" + MiscUtil.getUGILoginUser()));
            int i = 0;
            while (fileSystem.exists(hdfPath)) {
                int lastDot = defaultPath.lastIndexOf(46);
                String baseName = defaultPath.substring(0, lastDot);
                String extension = defaultPath.substring(lastDot);
                fullPath = baseName + "." + ++i + extension;
                hdfPath = new Path(fullPath);
                logger.info((Object)("Checking whether log file exists. hdfPath=" + fullPath));
            }
            logger.info((Object)("Log file doesn't exists. Will create and use it. hdfPath=" + fullPath));
            this.createParents(hdfPath, fileSystem);
            logger.info((Object)("Creating new log file. hdfPath=" + fullPath));
            this.ostream = fileSystem.create(hdfPath);
            this.logWriter = new PrintWriter((OutputStream)this.ostream);
            this.currentFileName = fullPath;
        }
        return this.logWriter;
    }

    Configuration createConfiguration() {
        Configuration conf = new Configuration();
        for (Map.Entry entry : this.configProps.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtils.isNotEmpty((String)value)) {
                conf.set(key, value);
            }
            logger.info((Object)("Adding property to HDFS config: " + key + " => " + value));
        }
        logger.info((Object)("Returning HDFS Filesystem Config: " + conf.toString()));
        return conf;
    }

    private void createParents(Path pathLogfile, FileSystem fileSystem) throws Exception {
        Path parentPath;
        logger.info((Object)("Creating parent folder for " + pathLogfile));
        Path path = parentPath = pathLogfile != null ? pathLogfile.getParent() : null;
        if (parentPath != null && fileSystem != null && !fileSystem.exists(parentPath)) {
            fileSystem.mkdirs(parentPath);
        }
    }

    private void closeFileIfNeeded() throws FileNotFoundException, IOException {
        if (this.logWriter == null) {
            return;
        }
        if (System.currentTimeMillis() > this.nextRollOverTime.getTime()) {
            logger.info((Object)("Closing file. Rolling over. name=" + this.getName() + ", fileName=" + this.currentFileName));
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error((Object)("Error on closing log writter. Exception will be ignored. name=" + this.getName() + ", fileName=" + this.currentFileName));
            }
            this.logWriter = null;
            this.ostream = null;
            this.currentFileName = null;
            if (!this.rollOverByDuration) {
                try {
                    if (StringUtils.isEmpty((String)this.rolloverPeriod)) {
                        this.rolloverPeriod = this.rollingTimeUtil.convertRolloverSecondsToRolloverPeriod(this.fileRolloverSec);
                    }
                    this.nextRollOverTime = this.rollingTimeUtil.computeNextRollingTime(this.rolloverPeriod);
                }
                catch (Exception e) {
                    logger.warn((Object)"Rollover by file.rollover.period failed...will be using the file.rollover.sec for hdfs audit file rollover...", (Throwable)e);
                    this.nextRollOverTime = this.rollOverByDuration();
                }
            } else {
                this.nextRollOverTime = this.rollOverByDuration();
            }
        }
    }

    private Date rollOverByDuration() {
        long rollOverTime = this.rollingTimeUtil.computeNextRollingTime(this.fileRolloverSec, this.nextRollOverTime);
        return new Date(rollOverTime);
    }
}

