/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.BaseAuditHandler;

public class MultiDestAuditProvider
extends BaseAuditHandler {
    private static final Log LOG = LogFactory.getLog(MultiDestAuditProvider.class);
    protected List<AuditHandler> mProviders = new ArrayList<AuditHandler>();
    static final String DEFAULT_NAME = "multi_dest";

    public MultiDestAuditProvider() {
        LOG.info((Object)"MultiDestAuditProvider: creating..");
        this.setName(DEFAULT_NAME);
    }

    public MultiDestAuditProvider(AuditHandler provider) {
        LOG.info((Object)("MultiDestAuditProvider(): provider=" + (provider == null ? null : provider.getName())));
        this.setName(DEFAULT_NAME);
        this.addAuditProvider(provider);
    }

    @Override
    public void init(Properties props) {
        LOG.info((Object)"MultiDestAuditProvider.init()");
        super.init(props);
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.init(props);
            }
            catch (Throwable excp) {
                LOG.info((Object)("MultiDestAuditProvider.init(): failed " + provider.getClass().getCanonicalName() + ")"), excp);
            }
        }
    }

    @Override
    public void setParentPath(String parentPath) {
        super.setParentPath(parentPath);
        for (AuditHandler provider : this.mProviders) {
            if (!(provider instanceof BaseAuditHandler)) continue;
            BaseAuditHandler baseAuditHander = (BaseAuditHandler)provider;
            baseAuditHander.setParentPath(this.getName());
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        for (AuditHandler provider : this.mProviders) {
            if (!(provider instanceof BaseAuditHandler)) continue;
            BaseAuditHandler baseAuditHander = (BaseAuditHandler)provider;
            baseAuditHander.setParentPath(this.getName());
        }
    }

    public void addAuditProvider(AuditHandler provider) {
        if (provider != null) {
            LOG.info((Object)("MultiDestAuditProvider.addAuditProvider(providerType=" + provider.getClass().getCanonicalName() + ")"));
            this.mProviders.add(provider);
            if (provider instanceof BaseAuditHandler) {
                BaseAuditHandler baseAuditHander = (BaseAuditHandler)provider;
                baseAuditHander.setParentPath(this.getName());
            }
        }
    }

    public void addAuditProviders(List<AuditHandler> providers) {
        if (providers != null) {
            for (AuditHandler provider : providers) {
                LOG.info((Object)("Adding " + provider.getName() + " as consumer to MultiDestination " + this.getName()));
                this.addAuditProvider(provider);
            }
        }
    }

    @Override
    public boolean log(AuditEventBase event) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.log(event);
            }
            catch (Throwable excp) {
                this.logFailedEvent(event, excp);
            }
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.log(events);
            }
            catch (Throwable excp) {
                this.logFailedEvent(events, excp);
            }
        }
        return true;
    }

    @Override
    public boolean logJSON(String event) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.logJSON(event);
            }
            catch (Throwable excp) {
                this.logFailedEventJSON(event, excp);
            }
        }
        return true;
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.logJSON(events);
            }
            catch (Throwable excp) {
                this.logFailedEventJSON(events, excp);
            }
        }
        return true;
    }

    @Override
    public void start() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.start();
            }
            catch (Throwable excp) {
                LOG.error((Object)("MultiDestAuditProvider.start(): failed for provider { " + provider.getClass().getName() + " }"), excp);
            }
        }
    }

    @Override
    public void stop() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.stop();
            }
            catch (Throwable excp) {
                LOG.error((Object)("MultiDestAuditProvider.stop(): failed for provider { " + provider.getClass().getName() + " }"), excp);
            }
        }
    }

    @Override
    public void waitToComplete() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.waitToComplete();
            }
            catch (Throwable excp) {
                LOG.error((Object)("MultiDestAuditProvider.waitToComplete(): failed for provider { " + provider.getClass().getName() + " }"), excp);
            }
        }
    }

    @Override
    public void waitToComplete(long timeout) {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.waitToComplete(timeout);
            }
            catch (Throwable excp) {
                LOG.error((Object)("MultiDestAuditProvider.waitToComplete(): failed for provider { " + provider.getClass().getName() + " }"), excp);
            }
        }
    }

    @Override
    public void flush() {
        for (AuditHandler provider : this.mProviders) {
            try {
                provider.flush();
            }
            catch (Throwable excp) {
                LOG.error((Object)("MultiDestAuditProvider.flush(): failed for provider { " + provider.getClass().getName() + " }"), excp);
            }
        }
    }
}

