/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.ranger.audit.utils.KerberosUser;

public class KerberosAction<T> {
    private final KerberosUser kerberosUser;
    private final PrivilegedExceptionAction<T> action;
    private final Log logger;

    public KerberosAction(KerberosUser kerberosUser, PrivilegedExceptionAction<T> action, Log logger) {
        this.kerberosUser = kerberosUser;
        this.action = action;
        this.logger = logger;
        Validate.notNull((Object)this.kerberosUser);
        Validate.notNull(this.action);
        Validate.notNull((Object)this.logger);
    }

    public T execute() throws Exception {
        T result;
        if (!this.kerberosUser.isLoggedIn()) {
            try {
                this.kerberosUser.login();
                this.logger.info((Object)("Successful login for " + this.kerberosUser.getPrincipal()));
            }
            catch (LoginException e) {
                throw new Exception("Login failed due to: " + e.getMessage(), e);
            }
        }
        try {
            this.kerberosUser.checkTGTAndRelogin();
        }
        catch (LoginException e) {
            throw new Exception("Relogin check failed due to: " + e.getMessage(), e);
        }
        try {
            result = this.kerberosUser.doAs(this.action);
        }
        catch (SecurityException se) {
            this.logger.info((Object)"Privileged action failed, attempting relogin and retrying...");
            this.logger.debug((Object)"", (Throwable)se);
            try {
                this.kerberosUser.logout();
                this.kerberosUser.login();
                result = this.kerberosUser.doAs(this.action);
            }
            catch (Exception e) {
                throw new Exception("Retrying privileged action failed due to: " + e.getMessage(), e);
            }
        }
        catch (PrivilegedActionException pae) {
            Exception cause = pae.getException();
            throw new Exception("Privileged action failed due to: " + cause.getMessage(), cause);
        }
        return result;
    }
}

