/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.AbstractRangerAuditWriter;

public class RangerJSONAuditWriter
extends AbstractRangerAuditWriter {
    private static final Log logger = LogFactory.getLog(RangerJSONAuditWriter.class);
    protected String JSON_FILE_EXTENSION = ".log";

    @Override
    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> RangerJSONAuditWriter.init()");
        }
        this.init();
        super.init(props, propPrefix, auditProviderName, auditConfigs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== RangerJSONAuditWriter.init()");
        }
    }

    public void init() {
        this.setFileExtension(this.JSON_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean logJSON(final Collection<String> events) throws Exception {
        boolean ret = false;
        PrintWriter out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UGI=" + MiscUtil.getUGILoginUser() + ". Will write to HDFS file=" + this.currentFileName));
            }
            if ((out = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<PrintWriter>(){

                @Override
                public PrintWriter run() throws Exception {
                    PrintWriter out = RangerJSONAuditWriter.this.getLogFileStream();
                    for (String event : events) {
                        out.println(event);
                    }
                    return out;
                }
            })).checkError()) {
                out.close();
                this.closeWriter();
                boolean bl = ret;
                return bl;
            }
        }
        catch (Exception e) {
            if (out != null) {
                out.close();
            }
            this.closeWriter();
            boolean bl = ret;
            return bl;
        }
        finally {
            ret = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Flushing HDFS audit. Event Size:" + events.size()));
            }
            if (out != null) {
                out.flush();
            }
        }
        return ret;
    }

    @Override
    public boolean log(Collection<String> events) throws Exception {
        return this.logJSON(events);
    }

    public synchronized boolean logAsFile(final File file) throws Exception {
        boolean ret = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("UGI=" + MiscUtil.getUGILoginUser() + ". Will write to HDFS file=" + this.currentFileName));
        }
        Boolean retVal = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws Exception {
                boolean ret = RangerJSONAuditWriter.this.logFileToHDFS(file);
                return ret;
            }
        });
        ret = retVal;
        logger.info((Object)("Flushing HDFS audit File :" + file.getAbsolutePath() + file.getName()));
        return ret;
    }

    @Override
    public boolean logFile(File file) throws Exception {
        return this.logAsFile(file);
    }

    public synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        PrintWriter logWriter = this.createWriter();
        return logWriter;
    }

    @Override
    public void flush() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> JSONWriter.flush()");
        }
        logger.info((Object)("Flush called. name=" + this.auditProviderName));
        super.flush();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== JSONWriter.flush()");
        }
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"==> JSONWriter.stop()");
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.flush();
                this.logWriter.close();
            }
            catch (Throwable t) {
                logger.error((Object)("Error on closing log writter. Exception will be ignored. name=" + this.auditProviderName + ", fileName=" + this.currentFileName));
            }
            this.logWriter = null;
            this.ostream = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<== JSONWriter.stop()");
        }
    }
}

