/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagEnricher;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.CacheMap;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerTagResource;
import org.apache.ranger.plugin.policyevaluator.RangerCachedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerOptimizedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerResourceTrie;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.ServicePolicies;

class RangerPolicyRepository {
    private static final Log LOG = LogFactory.getLog(RangerPolicyRepository.class);
    private static final Log PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    private static final Log PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.retrieval");
    private final String serviceName;
    private final String appId;
    private final RangerServiceDef serviceDef;
    private final List<RangerPolicy> policies;
    private final long policyVersion;
    private List<RangerContextEnricher> contextEnrichers;
    private List<RangerPolicyEvaluator> policyEvaluators;
    private List<RangerPolicyEvaluator> dataMaskPolicyEvaluators;
    private List<RangerPolicyEvaluator> rowFilterPolicyEvaluators;
    private final AuditModeEnum auditModeEnum;
    private final Map<String, AuditInfo> accessAuditCache;
    private final String componentServiceName;
    private final RangerServiceDef componentServiceDef;
    private final Map<String, RangerResourceTrie> policyResourceTrie;
    private final Map<String, RangerResourceTrie> dataMaskResourceTrie;
    private final Map<String, RangerResourceTrie> rowFilterResourceTrie;

    RangerPolicyRepository(String appId, ServicePolicies servicePolicies, RangerPolicyEngineOptions options) {
        String auditMode;
        this.componentServiceName = this.serviceName = servicePolicies.getServiceName();
        this.componentServiceDef = this.serviceDef = ServiceDefUtil.normalize(servicePolicies.getServiceDef());
        this.appId = appId;
        this.policies = Collections.unmodifiableList(servicePolicies.getPolicies());
        long l = this.policyVersion = servicePolicies.getPolicyVersion() != null ? servicePolicies.getPolicyVersion() : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerPolicyRepository : building resource-policy-repository for service " + this.serviceName));
        }
        this.auditModeEnum = StringUtils.equals((String)(auditMode = servicePolicies.getAuditMode()), (String)"audit-all") ? AuditModeEnum.AUDIT_ALL : (StringUtils.equals((String)auditMode, (String)"audit-none") ? AuditModeEnum.AUDIT_NONE : AuditModeEnum.AUDIT_DEFAULT);
        if (this.auditModeEnum == AuditModeEnum.AUDIT_DEFAULT) {
            String propertyName = "ranger.plugin." + this.serviceName + ".policyengine.auditcachesize";
            if (options.cacheAuditResults) {
                int RANGER_POLICYENGINE_AUDITRESULT_CACHE_SIZE = 65536;
                int auditResultCacheSize = RangerConfiguration.getInstance().getInt(propertyName, 65536);
                this.accessAuditCache = Collections.synchronizedMap(new CacheMap(auditResultCacheSize));
            } else {
                this.accessAuditCache = null;
            }
        } else {
            this.accessAuditCache = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerPolicyRepository : building policy-repository for service[" + this.serviceName + "] with auditMode[" + (Object)((Object)this.auditModeEnum) + "]"));
        }
        this.init(options);
        if (options.disableTrieLookupPrefilter) {
            this.policyResourceTrie = null;
            this.dataMaskResourceTrie = null;
            this.rowFilterResourceTrie = null;
        } else {
            this.policyResourceTrie = this.createResourceTrieMap(this.policyEvaluators, options.optimizeTrieForRetrieval);
            this.dataMaskResourceTrie = this.createResourceTrieMap(this.dataMaskPolicyEvaluators, options.optimizeTrieForRetrieval);
            this.rowFilterResourceTrie = this.createResourceTrieMap(this.rowFilterPolicyEvaluators, options.optimizeTrieForRetrieval);
        }
    }

    RangerPolicyRepository(String appId, ServicePolicies.TagPolicies tagPolicies, RangerPolicyEngineOptions options, RangerServiceDef componentServiceDef, String componentServiceName) {
        this.serviceName = tagPolicies.getServiceName();
        this.componentServiceName = componentServiceName;
        this.serviceDef = this.normalizeAccessTypeDefs(ServiceDefUtil.normalize(tagPolicies.getServiceDef()), componentServiceDef.getName());
        this.componentServiceDef = componentServiceDef;
        this.appId = appId;
        this.policies = Collections.unmodifiableList(this.normalizeAndPrunePolicies(tagPolicies.getPolicies(), componentServiceDef.getName()));
        this.policyVersion = tagPolicies.getPolicyVersion() != null ? tagPolicies.getPolicyVersion() : -1L;
        String auditMode = tagPolicies.getAuditMode();
        this.auditModeEnum = StringUtils.equals((String)auditMode, (String)"audit-all") ? AuditModeEnum.AUDIT_ALL : (StringUtils.equals((String)auditMode, (String)"audit-none") ? AuditModeEnum.AUDIT_NONE : AuditModeEnum.AUDIT_DEFAULT);
        this.accessAuditCache = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerPolicyRepository : building tag-policy-repository for tag service[" + this.serviceName + "] with auditMode[" + (Object)((Object)this.auditModeEnum) + "]"));
        }
        this.init(options);
        if (options.disableTrieLookupPrefilter) {
            this.policyResourceTrie = null;
            this.dataMaskResourceTrie = null;
            this.rowFilterResourceTrie = null;
        } else {
            this.policyResourceTrie = this.createResourceTrieMap(this.policyEvaluators, options.optimizeTrieForRetrieval);
            this.dataMaskResourceTrie = this.createResourceTrieMap(this.dataMaskPolicyEvaluators, options.optimizeTrieForRetrieval);
            this.rowFilterResourceTrie = this.createResourceTrieMap(this.rowFilterPolicyEvaluators, options.optimizeTrieForRetrieval);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> reorderEvaluators()");
        }
        if (this.policyResourceTrie == null) {
            this.policyEvaluators = this.getReorderedPolicyEvaluators(this.policyEvaluators);
        }
        if (this.dataMaskResourceTrie == null) {
            this.dataMaskPolicyEvaluators = this.getReorderedPolicyEvaluators(this.dataMaskPolicyEvaluators);
        }
        if (this.rowFilterResourceTrie == null) {
            this.rowFilterPolicyEvaluators = this.getReorderedPolicyEvaluators(this.rowFilterPolicyEvaluators);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== reorderEvaluators()");
        }
    }

    String getServiceName() {
        return this.serviceName;
    }

    RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    List<RangerPolicy> getPolicies() {
        return this.policies;
    }

    long getPolicyVersion() {
        return this.policyVersion;
    }

    AuditModeEnum getAuditModeEnum() {
        return this.auditModeEnum;
    }

    boolean setAuditEnabledFromCache(RangerAccessRequest request, RangerAccessResult result) {
        AuditInfo auditInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyRepository.setAuditEnabledFromCache()");
        }
        AuditInfo auditInfo2 = auditInfo = this.accessAuditCache != null ? this.accessAuditCache.get(request.getResource().getAsString()) : null;
        if (auditInfo != null) {
            result.setIsAudited(auditInfo.getIsAudited());
            result.setAuditPolicyId(auditInfo.getAuditPolicyId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.setAuditEnabledFromCache():" + (auditInfo != null)));
        }
        return auditInfo != null;
    }

    void storeAuditEnabledInCache(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyRepository.storeAuditEnabledInCache()");
        }
        if (this.accessAuditCache != null && result.getIsAuditedDetermined()) {
            this.accessAuditCache.put(request.getResource().getAsString(), new AuditInfo(result.getIsAudited(), result.getAuditPolicyId()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyRepository.storeAuditEnabledInCache()");
        }
    }

    List<RangerContextEnricher> getContextEnrichers() {
        return this.contextEnrichers;
    }

    List<RangerPolicyEvaluator> getPolicyEvaluators() {
        return this.policyEvaluators;
    }

    List<RangerPolicyEvaluator> getDataMaskPolicyEvaluators() {
        return this.dataMaskPolicyEvaluators;
    }

    List<RangerPolicyEvaluator> getRowFilterPolicyEvaluators() {
        return this.rowFilterPolicyEvaluators;
    }

    List<PolicyEvaluatorForTag> getLikelyMatchPolicyEvaluators(Set<RangerTagForEval> tags, int policyType, Date accessTime) {
        ArrayList<PolicyEvaluatorForTag> ret = Collections.EMPTY_LIST;
        if (CollectionUtils.isNotEmpty(tags) && this.getServiceDef() != null) {
            ret = new ArrayList<PolicyEvaluatorForTag>();
            for (RangerTagForEval tag : tags) {
                if (tag.isApplicable(accessTime)) {
                    RangerTagResource resource = new RangerTagResource(tag.getType(), this.getServiceDef());
                    List<RangerPolicyEvaluator> evaluators = this.getLikelyMatchPolicyEvaluators(resource, policyType);
                    if (!CollectionUtils.isNotEmpty(evaluators)) continue;
                    for (RangerPolicyEvaluator evaluator : evaluators) {
                        if (!evaluator.isApplicable(accessTime)) continue;
                        ret.add(new PolicyEvaluatorForTag(evaluator, tag));
                    }
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Tag:[" + tag.getType() + "] is not applicable at accessTime:[" + accessTime + "]"));
            }
            if (CollectionUtils.isNotEmpty(ret)) {
                switch (policyType) {
                    case 0: {
                        Collections.sort(ret, PolicyEvaluatorForTag.EVAL_ORDER_COMPARATOR);
                        break;
                    }
                    case 1: {
                        Collections.sort(ret, PolicyEvaluatorForTag.NAME_COMPARATOR);
                        break;
                    }
                    case 2: {
                        Collections.sort(ret, PolicyEvaluatorForTag.NAME_COMPARATOR);
                        break;
                    }
                    default: {
                        LOG.warn((Object)("Unknown policy-type:[" + policyType + "]. Ignoring.."));
                    }
                }
            }
        }
        return ret;
    }

    List<RangerPolicyEvaluator> getLikelyMatchPolicyEvaluators(RangerAccessResource resource) {
        ArrayList<RangerPolicyEvaluator> ret = new ArrayList<RangerPolicyEvaluator>();
        for (int policyType : RangerPolicy.POLICY_TYPES) {
            List<RangerPolicyEvaluator> evaluators = this.getLikelyMatchPolicyEvaluators(resource, policyType);
            if (!CollectionUtils.isNotEmpty(evaluators)) continue;
            ret.addAll(evaluators);
        }
        return ret;
    }

    List<RangerPolicyEvaluator> getLikelyMatchPolicyEvaluators(RangerAccessResource resource, int policyType) {
        switch (policyType) {
            case 0: {
                return this.getLikelyMatchAccessPolicyEvaluators(resource);
            }
            case 1: {
                return this.getLikelyMatchDataMaskPolicyEvaluators(resource);
            }
            case 2: {
                return this.getLikelyMatchRowFilterPolicyEvaluators(resource);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List<RangerPolicyEvaluator> getLikelyMatchAccessPolicyEvaluators(RangerAccessResource resource) {
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.policyResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.policyResourceTrie, resource);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchDataMaskPolicyEvaluators(RangerAccessResource resource) {
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.dataMaskResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getDataMaskPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.dataMaskResourceTrie, resource);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchRowFilterPolicyEvaluators(RangerAccessResource resource) {
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.rowFilterResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getRowFilterPolicyEvaluators() : this.getLikelyMatchPolicyEvaluators(this.rowFilterResourceTrie, resource);
    }

    private List<RangerPolicyEvaluator> getLikelyMatchPolicyEvaluators(Map<String, RangerResourceTrie> resourceTrie, RangerAccessResource resource) {
        List<RangerPolicyEvaluator> ret = null;
        Set<String> resourceKeys = resource == null ? null : resource.getKeys();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerPolicyRepository.getLikelyMatchEvaluators(resource=" + resource.getAsString() + ")");
        }
        if (CollectionUtils.isNotEmpty(resourceKeys)) {
            ArrayList resourceEvaluatorsList = null;
            List smallestList = null;
            for (String string : resourceKeys) {
                RangerResourceTrie trie = resourceTrie.get(string);
                if (trie == null) continue;
                List resourceEvaluators = trie.getEvaluatorsForResource(resource.getValue(string));
                if (CollectionUtils.isEmpty(resourceEvaluators)) {
                    resourceEvaluatorsList = null;
                    smallestList = null;
                    break;
                }
                if (smallestList == null) {
                    smallestList = resourceEvaluators;
                    continue;
                }
                if (resourceEvaluatorsList == null) {
                    resourceEvaluatorsList = new ArrayList();
                    resourceEvaluatorsList.add(smallestList);
                }
                resourceEvaluatorsList.add(resourceEvaluators);
                if (smallestList.size() <= resourceEvaluators.size()) continue;
                smallestList = resourceEvaluators;
            }
            if (resourceEvaluatorsList != null) {
                ret = new ArrayList<RangerPolicyEvaluator>(smallestList);
                for (List list : resourceEvaluatorsList) {
                    if (list == smallestList) continue;
                    ret.retainAll(list);
                    if (!CollectionUtils.isEmpty(ret)) continue;
                    ret = null;
                    break;
                }
            } else {
                ret = smallestList;
            }
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.getLikelyMatchPolicyEvaluators(" + resource.getAsString() + "): evaluatorCount=" + ret.size()));
        }
        return ret;
    }

    private RangerServiceDef normalizeAccessTypeDefs(RangerServiceDef serviceDef, String componentType) {
        List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs;
        if (serviceDef != null && StringUtils.isNotBlank((String)componentType) && CollectionUtils.isNotEmpty(accessTypeDefs = serviceDef.getAccessTypes())) {
            String prefix = componentType + ":";
            ArrayList<RangerServiceDef.RangerAccessTypeDef> unneededAccessTypeDefs = null;
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
                String accessType = accessTypeDef.getName();
                if (StringUtils.startsWith((String)accessType, (String)prefix)) {
                    String newAccessType = StringUtils.removeStart((String)accessType, (String)prefix);
                    accessTypeDef.setName(newAccessType);
                    Collection<String> impliedGrants = accessTypeDef.getImpliedGrants();
                    if (!CollectionUtils.isNotEmpty(impliedGrants)) continue;
                    ArrayList<String> newImpliedGrants = null;
                    for (String impliedGrant : impliedGrants) {
                        if (!StringUtils.startsWith((String)impliedGrant, (String)prefix)) continue;
                        String newImpliedGrant = StringUtils.removeStart((String)impliedGrant, (String)prefix);
                        if (newImpliedGrants == null) {
                            newImpliedGrants = new ArrayList<String>();
                        }
                        newImpliedGrants.add(newImpliedGrant);
                    }
                    accessTypeDef.setImpliedGrants(newImpliedGrants);
                    continue;
                }
                if (!StringUtils.contains((String)accessType, (String)":")) continue;
                if (unneededAccessTypeDefs == null) {
                    unneededAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
                }
                unneededAccessTypeDefs.add(accessTypeDef);
            }
            if (unneededAccessTypeDefs != null) {
                accessTypeDefs.removeAll(unneededAccessTypeDefs);
            }
        }
        return serviceDef;
    }

    private List<RangerPolicy> normalizeAndPrunePolicies(List<RangerPolicy> rangerPolicies, String componentType) {
        if (CollectionUtils.isNotEmpty(rangerPolicies) && StringUtils.isNotBlank((String)componentType)) {
            ArrayList<RangerPolicy> policiesToPrune = null;
            for (RangerPolicy policy : rangerPolicies) {
                this.normalizeAndPrunePolicyItems(policy.getPolicyItems(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getDenyPolicyItems(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getAllowExceptions(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getDenyExceptions(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getDataMaskPolicyItems(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getRowFilterPolicyItems(), componentType);
                if (policy.getIsAuditEnabled().booleanValue() || !CollectionUtils.isEmpty(policy.getPolicyItems()) || !CollectionUtils.isEmpty(policy.getDenyPolicyItems()) || !CollectionUtils.isEmpty(policy.getAllowExceptions()) || !CollectionUtils.isEmpty(policy.getDenyExceptions()) || !CollectionUtils.isEmpty(policy.getDataMaskPolicyItems()) || !CollectionUtils.isEmpty(policy.getRowFilterPolicyItems())) continue;
                if (policiesToPrune == null) {
                    policiesToPrune = new ArrayList<RangerPolicy>();
                }
                policiesToPrune.add(policy);
            }
            if (policiesToPrune != null) {
                rangerPolicies.removeAll(policiesToPrune);
            }
        }
        return rangerPolicies;
    }

    private List<? extends RangerPolicy.RangerPolicyItem> normalizeAndPrunePolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems, String componentType) {
        if (CollectionUtils.isNotEmpty(policyItems)) {
            String prefix = componentType + ":";
            ArrayList<RangerPolicy.RangerPolicyItem> itemsToPrune = null;
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
                List<RangerPolicy.RangerPolicyItemAccess> policyItemAccesses = rangerPolicyItem.getAccesses();
                if (CollectionUtils.isNotEmpty(policyItemAccesses)) {
                    ArrayList<RangerPolicy.RangerPolicyItemAccess> accessesToPrune = null;
                    for (RangerPolicy.RangerPolicyItemAccess access : policyItemAccesses) {
                        String accessType = access.getType();
                        if (StringUtils.startsWith((String)accessType, (String)prefix)) {
                            String newAccessType = StringUtils.removeStart((String)accessType, (String)prefix);
                            access.setType(newAccessType);
                            continue;
                        }
                        if (!accessType.contains(":")) continue;
                        if (accessesToPrune == null) {
                            accessesToPrune = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
                        }
                        accessesToPrune.add(access);
                    }
                    if (accessesToPrune != null) {
                        policyItemAccesses.removeAll(accessesToPrune);
                    }
                    if (policyItemAccesses.isEmpty() && !rangerPolicyItem.getDelegateAdmin().booleanValue()) {
                        if (itemsToPrune == null) {
                            itemsToPrune = new ArrayList<RangerPolicy.RangerPolicyItem>();
                        }
                        itemsToPrune.add(rangerPolicyItem);
                        continue;
                    }
                }
                if (!(rangerPolicyItem instanceof RangerPolicy.RangerDataMaskPolicyItem)) continue;
                RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo = ((RangerPolicy.RangerDataMaskPolicyItem)rangerPolicyItem).getDataMaskInfo();
                String maskType = dataMaskInfo.getDataMaskType();
                if (StringUtils.startsWith((String)maskType, (String)prefix)) {
                    dataMaskInfo.setDataMaskType(StringUtils.removeStart((String)maskType, (String)prefix));
                    continue;
                }
                if (!maskType.contains(":")) continue;
                if (itemsToPrune == null) {
                    itemsToPrune = new ArrayList();
                }
                itemsToPrune.add(rangerPolicyItem);
            }
            if (itemsToPrune != null) {
                policyItems.removeAll(itemsToPrune);
            }
        }
        return policyItems;
    }

    private static boolean isDelegateAdminPolicy(RangerPolicy policy) {
        boolean ret = RangerPolicyRepository.hasDelegateAdminItems(policy.getPolicyItems()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getDenyPolicyItems()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getAllowExceptions()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getDenyExceptions());
        return ret;
    }

    private static boolean hasDelegateAdminItems(List<RangerPolicy.RangerPolicyItem> items) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(items)) {
            for (RangerPolicy.RangerPolicyItem item : items) {
                if (!item.getDelegateAdmin().booleanValue()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static boolean skipBuildingPolicyEvaluator(RangerPolicy policy, RangerPolicyEngineOptions options) {
        boolean ret = false;
        if (!policy.getIsEnabled().booleanValue()) {
            ret = true;
        } else if (options.evaluateDelegateAdminOnly && !RangerPolicyRepository.isDelegateAdminPolicy(policy)) {
            ret = true;
        }
        return ret;
    }

    private void init(RangerPolicyEngineOptions options) {
        RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(this.serviceDef, false);
        options.setServiceDefHelper(serviceDefHelper);
        ArrayList<RangerPolicyEvaluator> policyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        ArrayList<RangerPolicyEvaluator> dataMaskPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        ArrayList<RangerPolicyEvaluator> rowFilterPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        for (RangerPolicy policy : this.policies) {
            Object evaluator;
            if (RangerPolicyRepository.skipBuildingPolicyEvaluator(policy, options) || (evaluator = this.buildPolicyEvaluator(policy, this.serviceDef, options)) == null) continue;
            if (policy.getPolicyType() == null || policy.getPolicyType() == 0) {
                policyEvaluators.add((RangerPolicyEvaluator)evaluator);
                continue;
            }
            if (policy.getPolicyType() == 1) {
                dataMaskPolicyEvaluators.add((RangerPolicyEvaluator)evaluator);
                continue;
            }
            if (policy.getPolicyType() == 2) {
                rowFilterPolicyEvaluators.add((RangerPolicyEvaluator)evaluator);
                continue;
            }
            LOG.warn((Object)("RangerPolicyEngine: ignoring policy id=" + policy.getId() + " - invalid policyType '" + policy.getPolicyType() + "'"));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("This policy engine contains " + (policyEvaluators.size() + dataMaskPolicyEvaluators.size() + rowFilterPolicyEvaluators.size()) + " policy evaluators"));
        }
        RangerPolicyEvaluator.PolicyEvalOrderComparator comparator = new RangerPolicyEvaluator.PolicyEvalOrderComparator();
        Collections.sort(policyEvaluators, comparator);
        this.policyEvaluators = Collections.unmodifiableList(policyEvaluators);
        Collections.sort(dataMaskPolicyEvaluators, comparator);
        this.dataMaskPolicyEvaluators = Collections.unmodifiableList(dataMaskPolicyEvaluators);
        Collections.sort(rowFilterPolicyEvaluators, comparator);
        this.rowFilterPolicyEvaluators = Collections.unmodifiableList(rowFilterPolicyEvaluators);
        ArrayList<RangerContextEnricher> contextEnrichers = new ArrayList<RangerContextEnricher>();
        if ((CollectionUtils.isNotEmpty(this.policyEvaluators) || CollectionUtils.isNotEmpty(this.dataMaskPolicyEvaluators) || CollectionUtils.isNotEmpty(this.rowFilterPolicyEvaluators)) && CollectionUtils.isNotEmpty(this.serviceDef.getContextEnrichers())) {
            for (RangerServiceDef.RangerContextEnricherDef enricherDef : this.serviceDef.getContextEnrichers()) {
                RangerContextEnricher contextEnricher;
                if (enricherDef == null || options.disableContextEnrichers && (!options.enableTagEnricherWithLocalRefresher || !StringUtils.equals((String)enricherDef.getEnricher(), (String)RangerTagEnricher.class.getName()))) continue;
                RangerServiceDef.RangerContextEnricherDef contextEnricherDef = enricherDef;
                if (options.enableTagEnricherWithLocalRefresher && StringUtils.equals((String)enricherDef.getEnricher(), (String)RangerTagEnricher.class.getName())) {
                    contextEnricherDef = new RangerServiceDef.RangerContextEnricherDef(enricherDef.getItemId(), enricherDef.getName(), "org.apache.ranger.common.RangerAdminTagEnricher", null);
                }
                if ((contextEnricher = this.buildContextEnricher(contextEnricherDef)) == null) continue;
                contextEnrichers.add(contextEnricher);
            }
        }
        this.contextEnrichers = Collections.unmodifiableList(contextEnrichers);
        if (LOG.isDebugEnabled()) {
            RangerPolicy policy;
            LOG.debug((Object)("policy evaluation order: " + this.policyEvaluators.size() + " policies"));
            int order = 0;
            for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                policy = policyEvaluator.getPolicy();
                LOG.debug((Object)("policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder()));
            }
            LOG.debug((Object)("dataMask policy evaluation order: " + this.dataMaskPolicyEvaluators.size() + " policies"));
            order = 0;
            for (RangerPolicyEvaluator policyEvaluator : this.dataMaskPolicyEvaluators) {
                policy = policyEvaluator.getPolicy();
                LOG.debug((Object)("dataMask policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder()));
            }
            LOG.debug((Object)("rowFilter policy evaluation order: " + this.rowFilterPolicyEvaluators.size() + " policies"));
            order = 0;
            for (RangerPolicyEvaluator policyEvaluator : this.rowFilterPolicyEvaluators) {
                policy = policyEvaluator.getPolicy();
                LOG.debug((Object)("rowFilter policy evaluation order: #" + ++order + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder()));
            }
        }
    }

    private RangerContextEnricher buildContextEnricher(RangerServiceDef.RangerContextEnricherDef enricherDef) {
        String clsName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.buildContextEnricher(" + enricherDef + ")"));
        }
        RangerContextEnricher ret = null;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerContextEnricher.init(appId=" + this.appId + ",name=" + enricherDef.getName() + ")");
        }
        String name = enricherDef != null ? enricherDef.getName() : null;
        String string = clsName = enricherDef != null ? enricherDef.getEnricher() : null;
        if (!StringUtils.isEmpty((String)clsName)) {
            try {
                Class<?> enricherClass = Class.forName(clsName);
                ret = (RangerContextEnricher)enricherClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to instantiate context enricher '" + clsName + "' for '" + name + "'"), (Throwable)excp);
            }
        }
        if (ret != null) {
            ret.setEnricherDef(enricherDef);
            ret.setServiceName(this.componentServiceName);
            ret.setServiceDef(this.componentServiceDef);
            ret.setAppId(this.appId);
            ret.init();
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.buildContextEnricher(" + enricherDef + "): " + ret));
        }
        return ret;
    }

    private RangerPolicyEvaluator buildPolicyEvaluator(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.buildPolicyEvaluator(" + policy + "," + serviceDef + ", " + options + ")"));
        }
        this.scrubPolicy(policy);
        RangerOptimizedPolicyEvaluator ret = StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"cached") ? new RangerCachedPolicyEvaluator() : new RangerOptimizedPolicyEvaluator();
        ret.init(policy, serviceDef, options);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.buildPolicyEvaluator(" + policy + "," + serviceDef + "): " + ret));
        }
        return ret;
    }

    private boolean scrubPolicy(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.scrubPolicy(" + policy + ")"));
        }
        boolean altered = false;
        Long policyId = policy.getId();
        Map<String, RangerPolicy.RangerPolicyResource> resourceMap = policy.getResources();
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resourceMap.entrySet()) {
            String resourceName = entry.getKey();
            RangerPolicy.RangerPolicyResource resource = entry.getValue();
            Iterator<String> iterator = resource.getValues().iterator();
            while (iterator.hasNext()) {
                String value = iterator.next();
                if (value != null) continue;
                LOG.warn((Object)("RangerPolicyRepository.scrubPolicyResource: found null resource value for " + resourceName + " in policy " + policyId + "!  Removing..."));
                iterator.remove();
                altered = true;
            }
        }
        this.scrubPolicyItems(policyId, policy.getPolicyItems());
        this.scrubPolicyItems(policyId, policy.getAllowExceptions());
        this.scrubPolicyItems(policyId, policy.getDenyPolicyItems());
        this.scrubPolicyItems(policyId, policy.getDenyExceptions());
        this.scrubPolicyItems(policyId, policy.getRowFilterPolicyItems());
        this.scrubPolicyItems(policyId, policy.getDataMaskPolicyItems());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.scrubPolicy(" + policy + "): " + altered));
        }
        return altered;
    }

    private void scrubPolicyItems(Long policyId, List<? extends RangerPolicy.RangerPolicyItem> policyItems) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.scrubPolicyItems(" + policyId + "): "));
        }
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
            this.removeNulls(rangerPolicyItem.getUsers(), policyId, rangerPolicyItem);
            this.removeNulls(rangerPolicyItem.getGroups(), policyId, rangerPolicyItem);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.scrubPolicyItems(" + policyId + "): "));
        }
    }

    private void removeNulls(Collection<String> strings, Long policyId, RangerPolicy.RangerPolicyItem policyItem) {
        Iterator<String> iterator = strings.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (value != null) continue;
            LOG.warn((Object)("RangerPolicyRepository.removeNulls: found null user/group in policyItem '" + policyItem + "' in policy " + policyId + "!  Removing..."));
            iterator.remove();
        }
    }

    private List<RangerPolicyEvaluator> getReorderedPolicyEvaluators(List<RangerPolicyEvaluator> evaluators) {
        List<RangerPolicyEvaluator> ret = evaluators;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            ret = new ArrayList<RangerPolicyEvaluator>(evaluators);
            Collections.sort(ret, new RangerPolicyEvaluator.PolicyEvalOrderComparator());
            ret = Collections.unmodifiableList(ret);
        }
        return ret;
    }

    private Map<String, RangerResourceTrie> createResourceTrieMap(List<RangerPolicyEvaluator> evaluators, boolean optimizeTrieForRetrieval) {
        HashMap<String, RangerResourceTrie<RangerPolicyEvaluator>> ret;
        if (CollectionUtils.isNotEmpty(evaluators) && this.serviceDef != null && CollectionUtils.isNotEmpty(this.serviceDef.getResources())) {
            ret = new HashMap<String, RangerResourceTrie<RangerPolicyEvaluator>>();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                ret.put(resourceDef.getName(), new RangerResourceTrie<RangerPolicyEvaluator>(resourceDef, evaluators, RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR, optimizeTrieForRetrieval));
            }
        } else {
            ret = null;
        }
        return ret;
    }

    private StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPolicyRepository={");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("serviceDef={").append(this.serviceDef).append("} ");
        sb.append("appId={").append(this.appId).append("} ");
        sb.append("policyEvaluators={");
        if (this.policyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("dataMaskPolicyEvaluators={");
        if (this.dataMaskPolicyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.dataMaskPolicyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("rowFilterPolicyEvaluators={");
        if (this.rowFilterPolicyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.rowFilterPolicyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        sb.append("} ");
        sb.append("contextEnrichers={");
        if (this.contextEnrichers != null) {
            for (RangerContextEnricher contextEnricher : this.contextEnrichers) {
                if (contextEnricher == null) continue;
                sb.append(contextEnricher).append(" ");
            }
        }
        sb.append("} ");
        sb.append("} ");
        return sb;
    }

    private static final class AuditInfo {
        final boolean isAudited;
        final long auditPolicyId;

        AuditInfo(boolean isAudited, long auditPolicyId) {
            this.isAudited = isAudited;
            this.auditPolicyId = auditPolicyId;
        }

        long getAuditPolicyId() {
            return this.auditPolicyId;
        }

        boolean getIsAudited() {
            return this.isAudited;
        }
    }

    static enum AuditModeEnum {
        AUDIT_ALL,
        AUDIT_NONE,
        AUDIT_DEFAULT;

    }
}

