/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerMutableResource;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;

public class RangerAuthContext
implements RangerPolicyEngine {
    private RangerPolicyEngine policyEngine;
    private Map<RangerContextEnricher, Object> requestContextEnrichers;

    protected RangerAuthContext() {
        this(null, null);
    }

    RangerAuthContext(RangerPolicyEngine policyEngine, Map<RangerContextEnricher, Object> requestContextEnrichers) {
        this.policyEngine = policyEngine;
        this.requestContextEnrichers = requestContextEnrichers;
    }

    RangerAuthContext(RangerAuthContext other) {
        if (other != null) {
            this.policyEngine = other.getPolicyEngine();
            Map<RangerContextEnricher, Object> localReference = other.requestContextEnrichers;
            if (MapUtils.isNotEmpty(localReference)) {
                this.requestContextEnrichers = new HashMap<RangerContextEnricher, Object>(localReference);
            }
        }
    }

    public RangerPolicyEngine getPolicyEngine() {
        return this.policyEngine;
    }

    void setPolicyEngine(RangerPolicyEngine policyEngine) {
        this.policyEngine = policyEngine;
    }

    public Map<RangerContextEnricher, Object> getRequestContextEnrichers() {
        return this.requestContextEnrichers;
    }

    public void addOrReplaceRequestContextEnricher(RangerContextEnricher enricher, Object database) {
        if (this.requestContextEnrichers == null) {
            this.requestContextEnrichers = new HashMap<RangerContextEnricher, Object>();
        }
        this.requestContextEnrichers.put(enricher, database);
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.policyEngine.setUseForwardedIPAddress(useForwardedIPAddress);
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.policyEngine.setTrustedProxyAddresses(trustedProxyAddresses);
    }

    @Override
    public boolean getUseForwardedIPAddress() {
        return this.policyEngine.getUseForwardedIPAddress();
    }

    @Override
    public String[] getTrustedProxyAddresses() {
        return this.policyEngine.getTrustedProxyAddresses();
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.policyEngine.getServiceDef();
    }

    @Override
    public long getPolicyVersion() {
        return this.policyEngine.getPolicyVersion();
    }

    public Collection<RangerAccessResult> isAccessAllowed(Collection<RangerAccessRequest> requests, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(requests);
        return this.policyEngine.evaluatePolicies(requests, 0, resultProcessor);
    }

    public RangerAccessResult isAccessAllowed(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(request);
        return this.policyEngine.evaluatePolicies(request, 0, resultProcessor);
    }

    public RangerAccessResult evalDataMaskPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(request);
        return this.policyEngine.evaluatePolicies(request, 1, resultProcessor);
    }

    public RangerAccessResult evalRowFilterPolicies(RangerAccessRequest request, RangerAccessResultProcessor resultProcessor) {
        this.preProcess(request);
        return this.policyEngine.evaluatePolicies(request, 2, resultProcessor);
    }

    @Override
    public void preProcess(RangerAccessRequest request) {
        RangerAccessResource resource = request.getResource();
        if (resource.getServiceDef() == null && resource instanceof RangerMutableResource) {
            RangerMutableResource mutable = (RangerMutableResource)resource;
            mutable.setServiceDef(this.getServiceDef());
        }
        if (request instanceof RangerAccessRequestImpl) {
            ((RangerAccessRequestImpl)request).extractAndSetClientIPAddress(this.getUseForwardedIPAddress(), this.getTrustedProxyAddresses());
        }
        RangerAccessRequestUtil.setCurrentUserInContext(request.getContext(), request.getUser());
        if (MapUtils.isNotEmpty(this.requestContextEnrichers)) {
            for (Map.Entry<RangerContextEnricher, Object> entry : this.requestContextEnrichers.entrySet()) {
                entry.getKey().enrich(request);
            }
        }
    }

    @Override
    public void preProcess(Collection<RangerAccessRequest> requests) {
        if (CollectionUtils.isNotEmpty(requests)) {
            for (RangerAccessRequest request : requests) {
                this.preProcess(request);
            }
        }
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        return this.policyEngine.evaluatePolicies(request, policyType, resultProcessor);
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        return this.policyEngine.evaluatePolicies(requests, policyType, resultProcessor);
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        this.preProcess(request);
        return this.policyEngine.getResourceACLs(request);
    }

    @Override
    public boolean preCleanup() {
        return this.policyEngine.preCleanup();
    }

    @Override
    public void cleanup() {
        this.policyEngine.cleanup();
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        this.preProcess(request);
        return this.policyEngine.getResourceAccessInfo(request);
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessResource resource) {
        RangerAccessRequestImpl request = new RangerAccessRequestImpl(resource, "_any", null, null);
        this.preProcess(request);
        return this.getMatchingPolicies(request);
    }

    @Override
    public List<RangerPolicy> getMatchingPolicies(RangerAccessRequest request) {
        return this.policyEngine.getMatchingPolicies(request);
    }

    @Override
    public void reorderPolicyEvaluators() {
    }

    @Override
    public boolean isAccessAllowed(RangerAccessResource resource, String user, Set<String> userGroups, String accessType) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(RangerPolicy policy, String user, Set<String> userGroups, String accessType) {
        return false;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        return false;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(Map<String, RangerPolicy.RangerPolicyResource> resources, Map<String, Object> evalContext) {
        return null;
    }

    @Override
    public List<RangerPolicy> getExactMatchPolicies(RangerAccessResource resource, Map<String, Object> evalContext) {
        return null;
    }

    @Override
    public List<RangerPolicy> getAllowedPolicies(String user, Set<String> userGroups, String accessType) {
        return null;
    }
}

