/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;

public class ServiceDefUtil {
    public static boolean getOption_enableDenyAndExceptionsInPolicies(RangerServiceDef serviceDef) {
        boolean ret = false;
        if (serviceDef != null) {
            boolean enableDenyAndExceptionsInPoliciesHiddenOption = RangerConfiguration.getInstance().getBoolean("ranger.servicedef.enableDenyAndExceptionsInPolicies", true);
            boolean defaultValue = enableDenyAndExceptionsInPoliciesHiddenOption || StringUtils.equalsIgnoreCase((String)serviceDef.getName(), (String)"tag");
            ret = ServiceDefUtil.getBooleanValue(serviceDef.getOptions(), "enableDenyAndExceptionsInPolicies", defaultValue);
        }
        return ret;
    }

    public static RangerServiceDef.RangerDataMaskTypeDef getDataMaskType(RangerServiceDef serviceDef, String typeName) {
        List<RangerServiceDef.RangerDataMaskTypeDef> maskTypes;
        RangerServiceDef.RangerDataMaskTypeDef ret = null;
        if (serviceDef != null && serviceDef.getDataMaskDef() != null && CollectionUtils.isNotEmpty(maskTypes = serviceDef.getDataMaskDef().getMaskTypes())) {
            for (RangerServiceDef.RangerDataMaskTypeDef maskType : maskTypes) {
                if (!StringUtils.equals((String)maskType.getName(), (String)typeName)) continue;
                ret = maskType;
                break;
            }
        }
        return ret;
    }

    public static RangerServiceDef normalize(RangerServiceDef serviceDef) {
        ServiceDefUtil.normalizeDataMaskDef(serviceDef);
        ServiceDefUtil.normalizeRowFilterDef(serviceDef);
        return serviceDef;
    }

    public static RangerServiceDef.RangerResourceDef getResourceDef(RangerServiceDef serviceDef, String resource) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (serviceDef != null && resource != null && CollectionUtils.isNotEmpty(serviceDef.getResources())) {
            for (RangerServiceDef.RangerResourceDef resourceDef : serviceDef.getResources()) {
                if (!StringUtils.equalsIgnoreCase((String)resourceDef.getName(), (String)resource)) continue;
                ret = resourceDef;
                break;
            }
        }
        return ret;
    }

    public static Integer getLeafResourceLevel(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource) {
        Integer ret = null;
        RangerServiceDef.RangerResourceDef resourceDef = ServiceDefUtil.getLeafResourceDef(serviceDef, policyResource);
        if (resourceDef != null) {
            ret = resourceDef.getLevel();
        }
        return ret;
    }

    public static RangerServiceDef.RangerResourceDef getLeafResourceDef(RangerServiceDef serviceDef, Map<String, RangerPolicy.RangerPolicyResource> policyResource) {
        RangerServiceDef.RangerResourceDef ret = null;
        if (serviceDef != null && policyResource != null) {
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policyResource.entrySet()) {
                String resource;
                RangerServiceDef.RangerResourceDef resourceDef;
                if (ServiceDefUtil.isEmpty(entry.getValue()) || (resourceDef = ServiceDefUtil.getResourceDef(serviceDef, resource = entry.getKey())) == null || resourceDef.getLevel() == null) continue;
                if (ret == null) {
                    ret = resourceDef;
                    continue;
                }
                if (ret.getLevel() >= resourceDef.getLevel()) continue;
                ret = resourceDef;
            }
        }
        return ret;
    }

    public static boolean isEmpty(RangerPolicy.RangerPolicyResource policyResource) {
        List<String> resourceValues;
        boolean ret = true;
        if (policyResource != null && CollectionUtils.isNotEmpty(resourceValues = policyResource.getValues())) {
            for (String resourceValue : resourceValues) {
                if (!StringUtils.isNotBlank((String)resourceValue)) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static String getOption(Map<String, String> options, String name, String defaultValue) {
        String ret;
        String string = ret = options != null && name != null ? options.get(name) : null;
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static boolean getBooleanOption(Map<String, String> options, String name, boolean defaultValue) {
        String val = ServiceDefUtil.getOption(options, name, null);
        return val == null ? defaultValue : Boolean.parseBoolean(val);
    }

    public static char getCharOption(Map<String, String> options, String name, char defaultValue) {
        String val = ServiceDefUtil.getOption(options, name, null);
        return StringUtils.isEmpty((String)val) ? defaultValue : val.charAt(0);
    }

    private static void normalizeDataMaskDef(RangerServiceDef serviceDef) {
        if (serviceDef != null && serviceDef.getDataMaskDef() != null) {
            Serializable processedDef;
            ArrayList<RangerServiceDef.RangerResourceDef> processedDefs;
            List<RangerServiceDef.RangerResourceDef> dataMaskResources = serviceDef.getDataMaskDef().getResources();
            List<RangerServiceDef.RangerAccessTypeDef> dataMaskAccessTypes = serviceDef.getDataMaskDef().getAccessTypes();
            if (CollectionUtils.isNotEmpty(dataMaskResources)) {
                List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
                processedDefs = new ArrayList<RangerServiceDef.RangerResourceDef>(dataMaskResources.size());
                Iterator<Serializable> iterator = dataMaskResources.iterator();
                while (iterator.hasNext()) {
                    RangerServiceDef.RangerResourceDef dataMaskResource;
                    processedDef = dataMaskResource = (RangerServiceDef.RangerResourceDef)iterator.next();
                    for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
                        if (!StringUtils.equals((String)resourceDef.getName(), (String)dataMaskResource.getName())) continue;
                        processedDef = ServiceDefUtil.mergeResourceDef(resourceDef, dataMaskResource);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getDataMaskDef().setResources(processedDefs);
            }
            if (CollectionUtils.isNotEmpty(dataMaskAccessTypes)) {
                List<RangerServiceDef.RangerAccessTypeDef> accessTypes = serviceDef.getAccessTypes();
                processedDefs = new ArrayList(accessTypes.size());
                for (RangerServiceDef.RangerAccessTypeDef dataMaskAccessType : dataMaskAccessTypes) {
                    processedDef = dataMaskAccessType;
                    for (RangerServiceDef.RangerAccessTypeDef accessType : accessTypes) {
                        if (!StringUtils.equals((String)accessType.getName(), (String)dataMaskAccessType.getName())) continue;
                        processedDef = ServiceDefUtil.mergeAccessTypeDef(accessType, dataMaskAccessType);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getDataMaskDef().setAccessTypes(processedDefs);
            }
        }
    }

    private static void normalizeRowFilterDef(RangerServiceDef serviceDef) {
        if (serviceDef != null && serviceDef.getRowFilterDef() != null) {
            Serializable processedDef;
            ArrayList<RangerServiceDef.RangerResourceDef> processedDefs;
            List<RangerServiceDef.RangerResourceDef> rowFilterResources = serviceDef.getRowFilterDef().getResources();
            List<RangerServiceDef.RangerAccessTypeDef> rowFilterAccessTypes = serviceDef.getRowFilterDef().getAccessTypes();
            if (CollectionUtils.isNotEmpty(rowFilterResources)) {
                List<RangerServiceDef.RangerResourceDef> resources = serviceDef.getResources();
                processedDefs = new ArrayList<RangerServiceDef.RangerResourceDef>(rowFilterResources.size());
                Iterator<Serializable> iterator = rowFilterResources.iterator();
                while (iterator.hasNext()) {
                    RangerServiceDef.RangerResourceDef rowFilterResource;
                    processedDef = rowFilterResource = (RangerServiceDef.RangerResourceDef)iterator.next();
                    for (RangerServiceDef.RangerResourceDef resourceDef : resources) {
                        if (!StringUtils.equals((String)resourceDef.getName(), (String)rowFilterResource.getName())) continue;
                        processedDef = ServiceDefUtil.mergeResourceDef(resourceDef, rowFilterResource);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getRowFilterDef().setResources(processedDefs);
            }
            if (CollectionUtils.isNotEmpty(rowFilterAccessTypes)) {
                List<RangerServiceDef.RangerAccessTypeDef> accessTypes = serviceDef.getAccessTypes();
                processedDefs = new ArrayList(accessTypes.size());
                for (RangerServiceDef.RangerAccessTypeDef rowFilterAccessType : rowFilterAccessTypes) {
                    processedDef = rowFilterAccessType;
                    for (RangerServiceDef.RangerAccessTypeDef accessType : accessTypes) {
                        if (!StringUtils.equals((String)accessType.getName(), (String)rowFilterAccessType.getName())) continue;
                        processedDef = ServiceDefUtil.mergeAccessTypeDef(accessType, rowFilterAccessType);
                        break;
                    }
                    processedDefs.add((RangerServiceDef.RangerResourceDef)processedDef);
                }
                serviceDef.getRowFilterDef().setAccessTypes(processedDefs);
            }
        }
    }

    private static RangerServiceDef.RangerResourceDef mergeResourceDef(RangerServiceDef.RangerResourceDef base, RangerServiceDef.RangerResourceDef delta) {
        RangerServiceDef.RangerResourceDef ret = new RangerServiceDef.RangerResourceDef(base);
        if (delta.getRecursiveSupported() != null) {
            ret.setRecursiveSupported(delta.getRecursiveSupported());
        }
        if (delta.getExcludesSupported() != null) {
            ret.setExcludesSupported(delta.getExcludesSupported());
        }
        if (StringUtils.isNotEmpty((String)delta.getMatcher())) {
            ret.setMatcher(delta.getMatcher());
        }
        if (MapUtils.isNotEmpty(delta.getMatcherOptions())) {
            if (ret.getMatcherOptions() == null) {
                ret.setMatcherOptions(new HashMap<String, String>());
            }
            for (Map.Entry<String, String> e : delta.getMatcherOptions().entrySet()) {
                ret.getMatcherOptions().put(e.getKey(), e.getValue());
            }
        }
        if (StringUtils.isNotEmpty((String)delta.getValidationRegEx())) {
            ret.setValidationRegEx(delta.getValidationRegEx());
        }
        if (StringUtils.isNotEmpty((String)delta.getValidationMessage())) {
            ret.setValidationMessage(delta.getValidationMessage());
        }
        if (StringUtils.isNotEmpty((String)delta.getUiHint())) {
            ret.setUiHint(delta.getUiHint());
        }
        if (StringUtils.isNotEmpty((String)delta.getLabel())) {
            ret.setLabel(delta.getLabel());
        }
        if (StringUtils.isNotEmpty((String)delta.getDescription())) {
            ret.setDescription(delta.getDescription());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyLabel())) {
            ret.setRbKeyLabel(delta.getRbKeyLabel());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyDescription())) {
            ret.setRbKeyDescription(delta.getRbKeyDescription());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyValidationMessage())) {
            ret.setRbKeyValidationMessage(delta.getRbKeyValidationMessage());
        }
        if (CollectionUtils.isNotEmpty(delta.getAccessTypeRestrictions())) {
            ret.setAccessTypeRestrictions(delta.getAccessTypeRestrictions());
        }
        if (delta.getIsValidLeaf() != null) {
            ret.setIsValidLeaf(delta.getIsValidLeaf());
        }
        return ret;
    }

    private static RangerServiceDef.RangerAccessTypeDef mergeAccessTypeDef(RangerServiceDef.RangerAccessTypeDef base, RangerServiceDef.RangerAccessTypeDef delta) {
        RangerServiceDef.RangerAccessTypeDef ret = new RangerServiceDef.RangerAccessTypeDef(base);
        if (StringUtils.isNotEmpty((String)delta.getLabel())) {
            ret.setLabel(delta.getLabel());
        }
        if (StringUtils.isNotEmpty((String)delta.getRbKeyLabel())) {
            ret.setRbKeyLabel(delta.getRbKeyLabel());
        }
        return ret;
    }

    private static boolean getBooleanValue(Map<String, String> map, String elementName, boolean defaultValue) {
        String elementValue;
        boolean ret = defaultValue;
        if (MapUtils.isNotEmpty(map) && map.containsKey(elementName) && StringUtils.isNotEmpty((String)(elementValue = map.get(elementName)))) {
            ret = Boolean.valueOf(elementValue.toString());
        }
        return ret;
    }
}

