/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.geo.GeolocationMetadata;
import org.apache.ranger.plugin.geo.RangerGeolocationData;
import org.apache.ranger.plugin.geo.RangerGeolocationDatabase;
import org.apache.ranger.plugin.store.GeolocationStore;

public class GeolocationFileStore
implements GeolocationStore {
    private static final Log LOG = LogFactory.getLog(GeolocationFileStore.class);
    public static final String GeoLineCommentIdentifier = "#";
    public static final Character GeoFieldsSeparator = Character.valueOf(',');
    public static final String PROP_GEOLOCATION_FILE_LOCATION = "FilePath";
    public static final String PROP_GEOLOCATION_FILE_REINIT = "ForceRead";
    public static final String PROP_GEOLOCATION_IP_IN_DOT_FORMAT = "IPInDotFormat";
    private static Map<String, RangerGeolocationDatabase> geolocationDBMap = new HashMap<String, RangerGeolocationDatabase>();
    private RangerGeolocationDatabase geolocationDatabase;
    private boolean isMetalineProcessed;
    private boolean useDotFormat;

    @Override
    public void init(Map<String, String> context) {
        RangerGeolocationDatabase database;
        String reinit;
        String filePathToGeolocationFile = context.get(PROP_GEOLOCATION_FILE_LOCATION);
        if (StringUtils.isBlank((String)filePathToGeolocationFile)) {
            filePathToGeolocationFile = "/etc/ranger/data/geo.txt";
        }
        boolean reinitialize = (reinit = context.get(PROP_GEOLOCATION_FILE_REINIT)) == null || Boolean.parseBoolean(reinit);
        String ipInDotFormat = context.get(PROP_GEOLOCATION_IP_IN_DOT_FORMAT);
        boolean bl = this.useDotFormat = ipInDotFormat == null || Boolean.parseBoolean(ipInDotFormat);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GeolocationFileStore.init() - Geolocation file location=" + filePathToGeolocationFile));
            LOG.debug((Object)("GeolocationFileStore.init() - Reinitialize flag =" + reinitialize));
            LOG.debug((Object)("GeolocationFileStore.init() - UseDotFormat flag =" + this.useDotFormat));
        }
        if ((database = geolocationDBMap.get(filePathToGeolocationFile)) == null || reinitialize) {
            RangerGeolocationDatabase newDatabase = this.build(filePathToGeolocationFile);
            if (newDatabase != null) {
                geolocationDBMap.put(filePathToGeolocationFile, newDatabase);
                database = newDatabase;
            } else {
                LOG.error((Object)"GeolocationFileStore.init() - Could not build database. Using old database if present.");
            }
        }
        this.geolocationDatabase = database;
        if (this.geolocationDatabase == null) {
            LOG.error((Object)("GeolocationFileStore.init() - Cannot build Geolocation database from file " + filePathToGeolocationFile));
        }
    }

    @Override
    public RangerGeolocationDatabase getGeoDatabase() {
        return this.geolocationDatabase;
    }

    @Override
    public final RangerGeolocationData getGeoLocation(String ipAddress) {
        RangerGeolocationData ret = null;
        RangerGeolocationDatabase database = this.geolocationDatabase;
        if (database != null) {
            long start = 0L;
            long end = 0L;
            start = System.currentTimeMillis();
            ret = database.find(ipAddress);
            end = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                if (ret == null) {
                    LOG.debug((Object)("GeolocationFileStore.getGeolocation() - " + ipAddress + " not found. Search time = " + (end - start) + " milliseconds"));
                } else {
                    LOG.debug((Object)("GeolocationFileStore.getGeolocation() - " + ipAddress + " found. Search time = " + (end - start) + " milliseconds"));
                    for (String attrName : database.getMetadata().getLocationDataItemNames()) {
                        LOG.debug((Object)("GeolocationFileStore.getGeolocation() - IPAddress[" + attrName + "]=" + database.getValue(ret, attrName) + ", "));
                    }
                }
            }
        } else {
            LOG.error((Object)"GeolocationFileStore.getGeolocation() - GeoLocationDatabase is not initialized correctly.");
        }
        return ret;
    }

    private Reader getReader(String dataFileName) throws IOException {
        InputStreamReader ret = null;
        File f = new File(dataFileName);
        if (f.exists() && f.canRead()) {
            LOG.info((Object)("GeolocationFileStore: reading location data from file '" + dataFileName + "'"));
            ret = new FileReader(dataFileName);
        } else {
            InputStream inStr = this.getClass().getResourceAsStream(dataFileName);
            if (inStr != null) {
                LOG.info((Object)("GeolocationFileStore: reading location data from resource '" + dataFileName + "'"));
                ret = new InputStreamReader(inStr);
            }
        }
        if (ret == null) {
            throw new FileNotFoundException(dataFileName);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RangerGeolocationDatabase build(String dataFileName) {
        RangerGeolocationDatabase database = null;
        BufferedReader bufferedReader = null;
        long start = 0L;
        long end = 0L;
        start = System.currentTimeMillis();
        try {
            String line;
            bufferedReader = new BufferedReader(this.getReader(dataFileName));
            database = new RangerGeolocationDatabase();
            int lineNumber = 0;
            this.isMetalineProcessed = false;
            while ((line = bufferedReader.readLine()) != null) {
                if (this.processLine(++lineNumber, line, database)) continue;
                LOG.error((Object)("RangerGeolocationDatabaseBuilder.build() - Invalid geo-specification - " + lineNumber + ":" + line));
                database = null;
                break;
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)("RangerGeolocationDatabaseBuilder.build() - Unable to open file '" + dataFileName + "'"));
        }
        catch (IOException ex) {
            LOG.error((Object)("RangerGeolocationDatabaseBuilder.build() - Error reading file '" + dataFileName + "', " + ex));
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception ex) {}
            }
        }
        end = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerGeolocationDatabaseBuilder.build() - Time taken for reading file = " + (end - start) + " milliseconds"));
        }
        if (database != null) {
            database.optimize();
        }
        return database;
    }

    private boolean processLine(int lineNumber, String line, RangerGeolocationDatabase database) {
        boolean ret = true;
        if (!(line = line.trim()).startsWith(GeoLineCommentIdentifier)) {
            String[] fields = StringUtils.split((String)line, (char)GeoFieldsSeparator.charValue());
            if (fields != null) {
                if (!this.isMetalineProcessed) {
                    GeolocationMetadata metadata = GeolocationMetadata.create(fields, lineNumber);
                    if (metadata != null) {
                        database.setMetadata(metadata);
                        this.isMetalineProcessed = true;
                    } else {
                        LOG.error((Object)("GeolocationFileStore.processLine() - Invalid metadata specification " + lineNumber + ":" + line));
                        ret = false;
                    }
                } else {
                    RangerGeolocationData data = RangerGeolocationData.create(fields, lineNumber, this.useDotFormat);
                    if (data != null) {
                        database.getData().insert(data);
                    } else {
                        LOG.error((Object)("GeolocationFileStore.processLine() - Invalid data specification " + lineNumber + ":" + line));
                    }
                }
            } else {
                LOG.error((Object)("GeolocationFileStore.processLine() - Invalid line, skipping.." + lineNumber + ":" + line));
            }
        }
        return ret;
    }
}

