/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;

public class PolicyEvaluatorForTag {
    public static final Comparator<PolicyEvaluatorForTag> EVAL_ORDER_COMPARATOR = new PolicyEvalOrderComparator();
    public static final Comparator<PolicyEvaluatorForTag> NAME_COMPARATOR = new PolicyNameComparator();
    private final RangerPolicyEvaluator evaluator;
    private final RangerTagForEval tag;

    PolicyEvaluatorForTag(RangerPolicyEvaluator evaluator, RangerTagForEval tag) {
        this.evaluator = evaluator;
        this.tag = tag;
    }

    RangerPolicyEvaluator getEvaluator() {
        return this.evaluator;
    }

    RangerTagForEval getTag() {
        return this.tag;
    }

    static class PolicyEvalOrderComparator
    implements Comparator<PolicyEvaluatorForTag>,
    Serializable {
        PolicyEvalOrderComparator() {
        }

        @Override
        public int compare(PolicyEvaluatorForTag me, PolicyEvaluatorForTag other) {
            return RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR.compare(me.getEvaluator(), other.getEvaluator());
        }
    }

    static class PolicyNameComparator
    implements Comparator<PolicyEvaluatorForTag>,
    Serializable {
        PolicyNameComparator() {
        }

        @Override
        public int compare(PolicyEvaluatorForTag me, PolicyEvaluatorForTag other) {
            return RangerPolicyEvaluator.NAME_COMPARATOR.compare(me.getEvaluator(), other.getEvaluator());
        }
    }
}

