/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.unixusersync.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.credentialapi.CredentialReader;
import org.apache.ranger.plugin.util.XMLUtils;
import org.apache.ranger.unixusersync.ha.UserSyncHAInitializerImpl;
import org.apache.ranger.usergroupsync.UserGroupSink;
import org.apache.ranger.usergroupsync.UserGroupSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserGroupSyncConfig {
    public static final String CONFIG_FILE = "ranger-ugsync-site.xml";
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupSyncConfig.class);
    public static final String DEFAULT_CONFIG_FILE = "ranger-ugsync-default.xml";
    private static final String CORE_SITE_CONFIG_FILE = "core-site.xml";
    public static final String UGSYNC_ENABLED_PROP = "ranger.usersync.enabled";
    public static final String UGSYNC_PM_URL_PROP = "ranger.usersync.policymanager.baseURL";
    public static final String UGSYNC_UNIX_PASSWORD_FILE = "ranger.usersync.unix.password.file";
    public static final String DEFAULT_UGSYNC_UNIX_PASSWORD_FILE = "/etc/passwd";
    public static final String UGSYNC_UNIX_GROUP_FILE = "ranger.usersync.unix.group.file";
    public static final String DEFAULT_UGSYNC_UNIX_GROUP_FILE = "/etc/group";
    public static final String UGSYNC_MIN_USERID_PROP = "ranger.usersync.unix.minUserId";
    public static final String UGSYNC_MIN_GROUPID_PROP = "ranger.usersync.unix.minGroupId";
    public static final String DEFAULT_UGSYNC_MIN_GROUPID = "0";
    public static final String UGSYNC_MAX_RECORDS_PER_API_CALL_PROP = "ranger.usersync.policymanager.maxrecordsperapicall";
    public static final String UGSYNC_MOCK_RUN_PROP = "ranger.usersync.policymanager.mockrun";
    public static final String UGSYNC_TEST_RUN_PROP = "ranger.usersync.policymanager.testrun";
    public static final String UGSYNC_SOURCE_FILE_PROC = "ranger.usersync.filesource.file";
    public static final String UGSYNC_SOURCE_FILE_DELIMITER = "ranger.usersync.filesource.text.delimiter";
    public static final String UGSYNC_SOURCE_FILE_DELIMITERER = "ranger.usersync.filesource.text.delimiterer";
    private static final String SSL_KEYSTORE_FILE_TYPE_PARAM = "ranger.keystore.file.type";
    private static final String SSL_TRUSTSTORE_FILE_TYPE_PARAM = "ranger.truststore.file.type";
    private static final String SSL_KEYSTORE_PATH_PARAM = "ranger.usersync.keystore.file";
    private static final String SSL_KEYSTORE_PATH_PASSWORD_PARAM = "ranger.usersync.keystore.password";
    private static final String SSL_KEYSTORE_PATH_PASSWORD_ALIAS = "usersync.ssl.key.password";
    private static final String SSL_TRUSTSTORE_PATH_PARAM = "ranger.usersync.truststore.file";
    private static final String SSL_TRUSTSTORE_PATH_PASSWORD_PARAM = "ranger.usersync.truststore.password";
    private static final String SSL_TRUSTSTORE_PATH_PASSWORD_ALIAS = "usersync.ssl.truststore.password";
    private static final String UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_PARAM = "ranger.usersync.sleeptimeinmillisbetweensynccycle";
    private static final long UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_MIN_VALUE = 60000L;
    private static final long UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_UNIX_DEFAULT_VALUE = 60000L;
    private static final long UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_LDAP_DEFAULT_VALUE = 3600000L;
    private static final String UGSYNC_SOURCE_CLASS_PARAM = "ranger.usersync.source.impl.class";
    private static final String UGSYNC_SINK_CLASS_PARAM = "ranger.usersync.sink.impl.class";
    private static final String UGSYNC_SOURCE_CLASS = "org.apache.ranger.unixusersync.process.UnixUserGroupBuilder";
    private static final String UGSYNC_SINK_CLASS = "org.apache.ranger.unixusersync.process.PolicyMgrUserGroupBuilder";
    private static final String LGSYNC_SOURCE_CLASS = "org.apache.ranger.ldapusersync.process.LdapUserGroupBuilder";
    private static final String LGSYNC_LDAP_URL = "ranger.usersync.ldap.url";
    private static final String LGSYNC_LDAP_DELTASYNC_ENABLED = "ranger.usersync.ldap.deltasync";
    private static final boolean DEFAULT_LGSYNC_LDAP_DELTASYNC_ENABLED = false;
    private static final String LGSYNC_LDAP_STARTTLS_ENABLED = "ranger.usersync.ldap.starttls";
    private static final boolean DEFAULT_LGSYNC_LDAP_STARTTLS_ENABLED = false;
    private static final String LGSYNC_LDAP_BIND_DN = "ranger.usersync.ldap.binddn";
    private static final String LGSYNC_LDAP_BIND_KEYSTORE = "ranger.usersync.credstore.filename";
    private static final String LGSYNC_LDAP_BIND_ALIAS = "ranger.usersync.ldap.bindalias";
    private static final String LGSYNC_LDAP_BIND_PASSWORD = "ranger.usersync.ldap.ldapbindpassword";
    private static final String LGSYNC_LDAP_AUTHENTICATION_MECHANISM = "ranger.usersync.ldap.authentication.mechanism";
    private static final String DEFAULT_AUTHENTICATION_MECHANISM = "simple";
    private static final String LGSYNC_SEARCH_BASE = "ranger.usersync.ldap.searchBase";
    private static final String LGSYNC_USER_SEARCH_BASE = "ranger.usersync.ldap.user.searchbase";
    private static final String LGSYNC_USER_SEARCH_SCOPE = "ranger.usersync.ldap.user.searchscope";
    private static final String LGSYNC_USER_OBJECT_CLASS = "ranger.usersync.ldap.user.objectclass";
    private static final String DEFAULT_USER_OBJECT_CLASS = "person";
    private static final String LGSYNC_GROUPNAMES = "ranger.usersync.ldap.groupnames";
    private static final String LGSYNC_USER_SEARCH_FILTER = "ranger.usersync.ldap.user.searchfilter";
    private static final String LGSYNC_USER_NAME_ATTRIBUTE = "ranger.usersync.ldap.user.nameattribute";
    private static final String DEFAULT_USER_NAME_ATTRIBUTE = "cn";
    private static final String LGSYNC_USER_GROUP_NAME_ATTRIBUTE = "ranger.usersync.ldap.user.groupnameattribute";
    private static final String DEFAULT_USER_GROUP_NAME_ATTRIBUTE = "memberof,ismemberof";
    private static final String LGSYNC_USER_CLOUDID_ATTRIBUTE = "ranger.usersync.ldap.user.cloudid.attribute";
    private static final String DEFAULT_USER_CLOUDID_ATTRIBUTE = "objectid";
    private static final String LGSYNC_USER_CLOUDID_ATTRIBUTE_DATATYPE = "ranger.usersync.ldap.user.cloudid.attribute.datatype";
    private static final String DEFAULT_USER_CLOUDID_ATTRIBUTE_DATATYPE = "byte[]";
    private static final String LGSYNC_OTHER_USER_ATTRIBUTES = "ranger.usersync.ldap.user.otherattributes";
    private static final String DEFAULT_OTHER_USER_ATTRIBUTES = "userurincipaluame,";
    public static final String UGSYNC_NONE_CASE_CONVERSION_VALUE = "none";
    public static final String UGSYNC_LOWER_CASE_CONVERSION_VALUE = "lower";
    public static final String UGSYNC_UPPER_CASE_CONVERSION_VALUE = "upper";
    private static final String UGSYNC_USERNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.username.caseconversion";
    private static final String DEFAULT_UGSYNC_USERNAME_CASE_CONVERSION_VALUE = "none";
    private static final String UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM = "ranger.usersync.ldap.groupname.caseconversion";
    private static final String DEFAULT_UGSYNC_GROUPNAME_CASE_CONVERSION_VALUE = "none";
    private static final String DEFAULT_USER_GROUP_TEXTFILE_DELIMITER = ",";
    private static final String LGSYNC_PAGED_RESULTS_ENABLED = "ranger.usersync.pagedresultsenabled";
    private static final boolean DEFAULT_LGSYNC_PAGED_RESULTS_ENABLED = true;
    private static final String LGSYNC_PAGED_RESULTS_SIZE = "ranger.usersync.pagedresultssize";
    private static final int DEFAULT_LGSYNC_PAGED_RESULTS_SIZE = 500;
    private static final String LGSYNC_GROUP_SEARCH_ENABLED = "ranger.usersync.group.searchenabled";
    private static final boolean DEFAULT_LGSYNC_GROUP_SEARCH_ENABLED = true;
    private static final String LGSYNC_GROUP_SEARCH_FIRST_ENABLED = "ranger.usersync.group.search.first.enabled";
    private static final boolean DEFAULT_LGSYNC_GROUP_SEARCH_FIRST_ENABLED = true;
    private static final String LGSYNC_USER_SEARCH_ENABLED = "ranger.usersync.user.searchenabled";
    private static final boolean DEFAULT_LGSYNC_USER_SEARCH_ENABLED = true;
    private static final String LGSYNC_GROUP_SEARCH_BASE = "ranger.usersync.group.searchbase";
    private static final String LGSYNC_GROUP_SEARCH_SCOPE = "ranger.usersync.group.searchscope";
    private static final String LGSYNC_GROUP_OBJECT_CLASS = "ranger.usersync.group.objectclass";
    private static final String DEFAULT_LGSYNC_GROUP_OBJECT_CLASS = "groupofnames";
    private static final String LGSYNC_GROUP_SEARCH_FILTER = "ranger.usersync.group.searchfilter";
    private static final String LGSYNC_GROUP_NAME_ATTRIBUTE = "ranger.usersync.group.nameattribute";
    private static final String DEFAULT_LGSYNC_GROUP_NAME_ATTRIBUTE = "cn";
    private static final String LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME = "ranger.usersync.group.memberattributename";
    private static final String DEFAULT_LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME = "member";
    private static final String LGSYNC_GROUP_CLOUDID_ATTRIBUTE = "ranger.usersync.ldap.group.cloudid.attribute";
    private static final String DEFAULT_GROUP_CLOUDID_ATTRIBUTE = "objectid";
    private static final String LGSYNC_GROUP_CLOUDID_ATTRIBUTE_DATATYPE = "ranger.usersync.ldap.group.cloudid.attribute.datatype";
    private static final String DEFAULT_GROUP_CLOUDID_ATTRIBUTE_DATATYPE = "byte[]";
    private static final String LGSYNC_OTHER_GROUP_ATTRIBUTES = "ranger.usersync.ldap.group.otherattributes";
    private static final String DEFAULT_OTHER_GROUP_ATTRIBUTES = "displayname,";
    private static final String LGSYNC_GROUP_HIERARCHY_LEVELS = "ranger.usersync.ldap.grouphierarchylevels";
    private static final int DEFAULT_LGSYNC_GROUP_HIERARCHY_LEVELS = 0;
    private static final String UGSYNC_UPDATE_MILLIS_MIN = "ranger.usersync.unix.updatemillismin";
    private static final long DEFAULT_UGSYNC_UPDATE_MILLIS_MIN = 60000L;
    private static final String UGSYNC_UNIX_BACKEND = "ranger.usersync.unix.backend";
    private static final String DEFAULT_UGSYNC_UNIX_BACKEND = "passwd";
    private static final String UGSYNC_GROUP_ENUMERATE_ENABLED = "ranger.usersync.group.enumerate";
    private static final String UGSYNC_GROUP_ENUMERATE_GROUPS = "ranger.usersync.group.enumerategroup";
    private static final String SYNC_POLICY_MGR_KEYSTORE = "ranger.usersync.policymgr.keystore";
    private static final String SYNC_POLICY_MGR_ALIAS = "ranger.usersync.policymgr.alias";
    private static final String SYNC_POLICY_MGR_PASSWORD = "ranger.usersync.policymgr.password";
    private static final String SYNC_POLICY_MGR_USERNAME = "ranger.usersync.policymgr.username";
    private static final String SYNC_POLICY_MGR_MAX_RETRY_ATTEMPTS = "ranger.usersync.policymgr.max.retry.attempts";
    private static final String SYNC_POLICY_MGR_RETRY_INTERVAL_MS = "ranger.usersync.policymgr.retry.interval.ms";
    private static final String DEFAULT_POLICYMGR_USERNAME = "rangerusersync";
    private static final String SYNC_SOURCE = "ranger.usersync.sync.source";
    private static final String LGSYNC_REFERRAL = "ranger.usersync.ldap.referral";
    private static final String DEFAULT_LGSYNC_REFERRAL = "ignore";
    public static final String SYNC_MAPPING_USERNAME = "ranger.usersync.mapping.username.regex";
    public static final String SYNC_MAPPING_GROUPNAME = "ranger.usersync.mapping.groupname.regex";
    private static final String SYNC_MAPPING_USERNAME_HANDLER = "ranger.usersync.mapping.username.handler";
    private static final String DEFAULT_SYNC_MAPPING_USERNAME_HANDLER = "org.apache.ranger.usergroupsync.RegEx";
    private static final String SYNC_MAPPING_GROUPNAME_HANDLER = "ranger.usersync.mapping.groupname.handler";
    private static final String DEFAULT_SYNC_MAPPING_GROUPNAME_HANDLER = "org.apache.ranger.usergroupsync.RegEx";
    private static final String SYNC_MAPPING_SEPARATOR = "ranger.usersync.mapping.regex.separator";
    private static final String DEFAULT_MAPPING_SEPARATOR = "/";
    private static final String ROLE_ASSIGNMENT_LIST_DELIMITER = "ranger.usersync.role.assignment.list.delimiter";
    private static final String USERS_GROUPS_ASSIGNMENT_LIST_DELIMITER = "ranger.usersync.users.groups.assignment.list.delimiter";
    private static final String USERNAME_GROUPNAME_ASSIGNMENT_LIST_DELIMITER = "ranger.usersync.username.groupname.assignment.list.delimiter";
    private static final String GROUP_BASED_ROLE_ASSIGNMENT_RULES = "ranger.usersync.group.based.role.assignment.rules";
    private static final String WHITELIST_USER_ROLE_ASSIGNMENT_RULES = "ranger.usersync.whitelist.users.role.assignment.rules";
    private static final String DEFAULT_WHITELIST_USER_ROLE_ASSIGNMENT_RULES = "&ROLE_SYS_ADMIN:u:admin,rangerusersync,rangertagsync&ROLE_KEY_ADMIN:u:keyadmin";
    private static final String USERSYNC_RANGER_COOKIE_ENABLED_PROP = "ranger.usersync.cookie.enabled";
    private static final String RANGER_ADMIN_COOKIE_NAME_PROPS = "ranger.usersync.dest.ranger.session.cookie.name";
    private static final String UGSYNC_METRICS_FILEPATH = "ranger.usersync.metrics.filepath";
    private static final String DEFAULT_UGSYNC_METRICS_FILEPATH = "/tmp/";
    private static final String UGSYNC_METRICS_FILENAME = "ranger.usersync.metrics.filename";
    private static final String DEFAULT_UGSYNC_METRICS_FILENAME = "ranger_usersync_metric.json";
    private static final String UGSYNC_METRICS_FREQUENCY_TIME_IN_MILLIS_PARAM = "ranger.usersync.metrics.frequencytimeinmillis";
    private static final long DEFAULT_UGSYNC_METRICS_FREQUENCY_TIME_IN_MILLIS = 10000L;
    public static final String UGSYNC_METRICS_ENABLED_PROP = "ranger.usersync.metrics.enabled";
    private static final String UGSYNC_DELETES_ENABLED = "ranger.usersync.deletes.enabled";
    private static final boolean DEFAULT_UGSYNC_DELETES_ENABLED = false;
    private static final String UGSYNC_DELETES_FREQUENCY = "ranger.usersync.deletes.frequency";
    private static final long DEFAULT_UGSYNC_DELETES_FREQUENCY = 10L;
    public static final String UGSYNC_NAME_VALIDATION_ENABLED = "ranger.usersync.name.validation.enabled";
    private static final boolean DEFAULT_UGSYNC_NAME_VALIDATION_ENABLED = false;
    private static final long UGSYNC_INIT_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_MIN_VALUE_FOR_HA = 5000L;
    public static final String UGSYNC_SERVER_HA_ENABLED_PARAM = "ranger-ugsync.server.ha.enabled";
    public static final String UGSYNC_SYNC_SOURCE_VALIDATION_ENABLED = "ranger.usersync.syncsource.validation.enabled";
    private static final boolean DEFAULT_UGSYNC_SYNC_SOURCE_VALIDATION_ENABLED = true;
    private Properties prop = new Properties();
    private Configuration userGroupConfig = null;
    private static volatile UserGroupSyncConfig me = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserGroupSyncConfig getInstance() {
        UserGroupSyncConfig result = me;
        if (result != null) return result;
        Class<UserGroupSyncConfig> clazz = UserGroupSyncConfig.class;
        synchronized (UserGroupSyncConfig.class) {
            result = me;
            if (result != null) return result;
            me = result = new UserGroupSyncConfig();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private UserGroupSyncConfig() {
        this.init();
    }

    private void init() {
        XMLUtils.loadConfig((String)DEFAULT_CONFIG_FILE, (Map)this.prop);
        XMLUtils.loadConfig((String)CORE_SITE_CONFIG_FILE, (Map)this.prop);
        XMLUtils.loadConfig((String)CONFIG_FILE, (Map)this.prop);
        this.userGroupConfig = this.getConfig();
    }

    public Configuration getConfig() {
        Configuration ret = new Configuration();
        for (String propName : this.prop.stringPropertyNames()) {
            ret.set(propName, this.prop.getProperty(propName));
        }
        return ret;
    }

    public Configuration getUserGroupConfig() {
        return this.userGroupConfig;
    }

    public static synchronized boolean isUgsyncServiceActive() {
        return UserSyncHAInitializerImpl.getInstance(UserGroupSyncConfig.getInstance().getUserGroupConfig()).isActive();
    }

    public String getUserSyncFileSource() {
        String val = this.prop.getProperty(UGSYNC_SOURCE_FILE_PROC);
        return val;
    }

    public String getUserSyncFileSourceDelimiter() {
        String val = this.prop.getProperty(UGSYNC_SOURCE_FILE_DELIMITER);
        if (val == null) {
            val = this.prop.getProperty(UGSYNC_SOURCE_FILE_DELIMITERER);
        }
        if (val == null) {
            val = DEFAULT_USER_GROUP_TEXTFILE_DELIMITER;
        }
        return val;
    }

    public String getUnixPasswordFile() {
        String val = this.prop.getProperty(UGSYNC_UNIX_PASSWORD_FILE);
        if (val == null) {
            val = DEFAULT_UGSYNC_UNIX_PASSWORD_FILE;
        }
        return val;
    }

    public String getUnixGroupFile() {
        String val = this.prop.getProperty(UGSYNC_UNIX_GROUP_FILE);
        if (val == null) {
            val = DEFAULT_UGSYNC_UNIX_GROUP_FILE;
        }
        return val;
    }

    public String getUnixBackend() {
        String val = this.prop.getProperty(UGSYNC_UNIX_BACKEND);
        if (val == null) {
            val = DEFAULT_UGSYNC_UNIX_BACKEND;
        }
        return val;
    }

    public boolean isUserSyncEnabled() {
        String val = this.prop.getProperty(UGSYNC_ENABLED_PROP);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public String getEnumerateGroups() {
        return this.prop.getProperty(UGSYNC_GROUP_ENUMERATE_GROUPS);
    }

    public boolean isGroupEnumerateEnabled() {
        String val = this.prop.getProperty(UGSYNC_GROUP_ENUMERATE_ENABLED);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public boolean isMockRunEnabled() {
        String val = this.prop.getProperty(UGSYNC_MOCK_RUN_PROP);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public boolean isTestRunEnabled() {
        String val = this.prop.getProperty(UGSYNC_TEST_RUN_PROP);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public String getPolicyManagerBaseURL() {
        return this.prop.getProperty(UGSYNC_PM_URL_PROP);
    }

    public String getMinUserId() {
        return this.prop.getProperty(UGSYNC_MIN_USERID_PROP);
    }

    public String getMinGroupId() {
        String mgid = this.prop.getProperty(UGSYNC_MIN_GROUPID_PROP);
        if (mgid == null) {
            mgid = DEFAULT_UGSYNC_MIN_GROUPID;
        }
        return mgid;
    }

    public String getMaxRecordsPerAPICall() {
        return this.prop.getProperty(UGSYNC_MAX_RECORDS_PER_API_CALL_PROP);
    }

    public String getSSLKeyStoreType() {
        return this.prop.getProperty(SSL_KEYSTORE_FILE_TYPE_PARAM, KeyStore.getDefaultType());
    }

    public String getSSLTrustStoreType() {
        return this.prop.getProperty(SSL_TRUSTSTORE_FILE_TYPE_PARAM, KeyStore.getDefaultType());
    }

    public String getSSLKeyStorePath() {
        return this.prop.getProperty(SSL_KEYSTORE_PATH_PARAM);
    }

    public String getSSLKeyStorePathPassword() {
        if (this.prop == null) {
            return null;
        }
        if (this.prop.containsKey(LGSYNC_LDAP_BIND_KEYSTORE)) {
            String path = this.prop.getProperty(LGSYNC_LDAP_BIND_KEYSTORE);
            String alias = SSL_KEYSTORE_PATH_PASSWORD_ALIAS;
            if (path != null && alias != null && !path.trim().isEmpty() && !alias.trim().isEmpty()) {
                String password;
                if ("bcfks".equalsIgnoreCase(this.getSSLKeyStoreType())) {
                    String crendentialProviderPrefixBcfks = "bcfks://file";
                    path = crendentialProviderPrefixBcfks + path;
                }
                if (!((password = CredentialReader.getDecryptedString((String)path.trim(), (String)alias.trim(), (String)this.getSSLKeyStoreType())) == null || password.trim().isEmpty() || "none".equalsIgnoreCase(password.trim()) || "_".equalsIgnoreCase(password.trim()))) {
                    this.prop.setProperty(SSL_KEYSTORE_PATH_PASSWORD_PARAM, password);
                }
            }
        }
        return this.prop.getProperty(SSL_KEYSTORE_PATH_PASSWORD_PARAM);
    }

    public String getSSLTrustStorePath() {
        return this.prop.getProperty(SSL_TRUSTSTORE_PATH_PARAM);
    }

    public String getSSLTrustStorePathPassword() {
        if (this.prop == null) {
            return null;
        }
        if (this.prop.containsKey(LGSYNC_LDAP_BIND_KEYSTORE)) {
            String path = this.prop.getProperty(LGSYNC_LDAP_BIND_KEYSTORE);
            String alias = SSL_TRUSTSTORE_PATH_PASSWORD_ALIAS;
            if (path != null && alias != null && !path.trim().isEmpty() && !alias.trim().isEmpty()) {
                String password;
                if ("bcfks".equalsIgnoreCase(this.getSSLKeyStoreType())) {
                    String crendentialProviderPrefixBcfks = "bcfks://file";
                    path = crendentialProviderPrefixBcfks + path;
                }
                if (!((password = CredentialReader.getDecryptedString((String)path.trim(), (String)alias.trim(), (String)this.getSSLKeyStoreType())) == null || password.trim().isEmpty() || "none".equalsIgnoreCase(password.trim()) || "_".equalsIgnoreCase(password.trim()))) {
                    this.prop.setProperty(SSL_TRUSTSTORE_PATH_PASSWORD_PARAM, password);
                }
            }
        }
        return this.prop.getProperty(SSL_TRUSTSTORE_PATH_PASSWORD_PARAM);
    }

    public long getUpdateMillisMin() {
        String val = this.prop.getProperty(UGSYNC_UPDATE_MILLIS_MIN);
        if (val == null) {
            return 60000L;
        }
        long ret = Long.parseLong(val);
        if (ret < 60000L) {
            return 60000L;
        }
        return ret;
    }

    public long getInitSleepTimeInMillisBetweenCycle() throws Throwable {
        long initSleepValue = 0L;
        Configuration config = this.getUserGroupConfig();
        initSleepValue = config.getBoolean(UGSYNC_SERVER_HA_ENABLED_PARAM, false) ? 5000L : this.getSleepTimeInMillisBetweenCycle();
        return initSleepValue;
    }

    public long getSleepTimeInMillisBetweenCycle() throws Throwable {
        String val = this.prop.getProperty(UGSYNC_SLEEP_TIME_IN_MILLIS_BETWEEN_CYCLE_PARAM);
        String className = this.getUserGroupSource().getClass().getName();
        if (val == null) {
            if (LGSYNC_SOURCE_CLASS.equals(className)) {
                return 3600000L;
            }
            return 60000L;
        }
        long ret = Long.parseLong(val);
        long min_interval = LGSYNC_SOURCE_CLASS.equals(className) ? 3600000L : (UGSYNC_SOURCE_CLASS.equals(className) ? 60000L : 60000L);
        if (!this.isTestRunEnabled() && ret < min_interval) {
            LOG.info("Sleep Time Between Cycle can not be lower than [" + min_interval + "] millisec. resetting to min value.");
            ret = min_interval;
        }
        return ret;
    }

    private String getUserGroupSourceClassName() {
        String val = this.prop.getProperty(UGSYNC_SOURCE_CLASS_PARAM);
        String className = UGSYNC_SOURCE_CLASS;
        String syncSource = null;
        if (val == null || val.trim().isEmpty()) {
            syncSource = this.getSyncSource();
        } else {
            if (val.equalsIgnoreCase(LGSYNC_SOURCE_CLASS)) {
                val = LGSYNC_SOURCE_CLASS;
            }
            syncSource = val;
        }
        className = val;
        if (syncSource != null && syncSource.equalsIgnoreCase("UNIX")) {
            className = UGSYNC_SOURCE_CLASS;
        } else if (syncSource != null && syncSource.equalsIgnoreCase("LDAP")) {
            className = LGSYNC_SOURCE_CLASS;
        }
        return className;
    }

    public UserGroupSource getUserGroupSource() throws Throwable {
        String className = this.getUserGroupSourceClassName();
        Class<?> ugSourceClass = Class.forName(className);
        UserGroupSource ret = (UserGroupSource)ugSourceClass.newInstance();
        return ret;
    }

    public UserGroupSink getUserGroupSink() throws Throwable {
        String val = this.prop.getProperty(UGSYNC_SINK_CLASS_PARAM);
        if (val == null || val.trim().isEmpty()) {
            val = UGSYNC_SINK_CLASS;
        }
        Class<?> ugSinkClass = Class.forName(val);
        UserGroupSink ret = (UserGroupSink)ugSinkClass.newInstance();
        return ret;
    }

    public String getLdapUrl() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_LDAP_URL);
        if (val == null || val.trim().isEmpty()) {
            throw new Exception("ranger.usersync.ldap.url for LdapGroupSync is not specified");
        }
        return val;
    }

    public String getLdapBindDn() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_LDAP_BIND_DN);
        if (val == null || val.trim().isEmpty()) {
            throw new Exception("ranger.usersync.ldap.binddn for LdapGroupSync is not specified");
        }
        return val;
    }

    public String getLdapBindPassword() {
        if (this.prop == null) {
            return null;
        }
        if (this.prop.containsKey(LGSYNC_LDAP_BIND_KEYSTORE)) {
            String path = this.prop.getProperty(LGSYNC_LDAP_BIND_KEYSTORE);
            String alias = LGSYNC_LDAP_BIND_ALIAS;
            if (path != null && alias != null && !path.trim().isEmpty() && !alias.trim().isEmpty()) {
                String password;
                if ("bcfks".equalsIgnoreCase(this.getSSLKeyStoreType())) {
                    String crendentialProviderPrefixBcfks = "bcfks://file";
                    path = crendentialProviderPrefixBcfks + path;
                }
                if ((password = CredentialReader.getDecryptedString((String)path.trim(), (String)alias.trim(), (String)this.getSSLKeyStoreType())) != null && !password.trim().isEmpty() && !password.trim().equalsIgnoreCase("none")) {
                    this.prop.setProperty(LGSYNC_LDAP_BIND_PASSWORD, password);
                }
            }
        }
        return this.prop.getProperty(LGSYNC_LDAP_BIND_PASSWORD);
    }

    public String getLdapAuthenticationMechanism() {
        String val = this.prop.getProperty(LGSYNC_LDAP_AUTHENTICATION_MECHANISM);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_AUTHENTICATION_MECHANISM;
        }
        return val;
    }

    public String getUserSearchBase() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_BASE);
        if (val == null || val.trim().isEmpty()) {
            val = this.getSearchBase();
        }
        if (val == null || val.trim().isEmpty()) {
            throw new Exception("ranger.usersync.ldap.user.searchbase for LdapGroupSync is not specified");
        }
        return val;
    }

    public int getUserSearchScope() {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_SCOPE);
        if (val == null || val.trim().isEmpty()) {
            return 2;
        }
        if ((val = val.trim().toLowerCase()).equals(DEFAULT_UGSYNC_MIN_GROUPID) || val.startsWith("base")) {
            return 0;
        }
        if (val.equals("1") || val.startsWith("one")) {
            return 1;
        }
        return 2;
    }

    public String getUserObjectClass() {
        String val = this.prop.getProperty(LGSYNC_USER_OBJECT_CLASS);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_USER_OBJECT_CLASS;
        }
        return val;
    }

    public String getUserSearchFilter() {
        return this.prop.getProperty(LGSYNC_USER_SEARCH_FILTER);
    }

    public String getUserNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_NAME_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return "cn";
        }
        return val;
    }

    public String getUserGroupNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_GROUP_NAME_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_USER_GROUP_NAME_ATTRIBUTE;
        }
        return val;
    }

    public String getGroupNames() {
        return this.prop.getProperty(LGSYNC_GROUPNAMES);
    }

    public Set<String> getGroupNameSet() {
        String groupNames = this.getGroupNames();
        HashSet<String> groupNamegSet = new HashSet<String>();
        if (StringUtils.isNotEmpty((String)groupNames)) {
            StringTokenizer st = new StringTokenizer(groupNames, ";");
            while (st.hasMoreTokens()) {
                groupNamegSet.add(st.nextToken().trim().toLowerCase());
            }
        }
        return groupNamegSet;
    }

    public Set<String> getUserGroupNameAttributeSet() {
        String uga = this.getUserGroupNameAttribute();
        StringTokenizer st = new StringTokenizer(uga, DEFAULT_USER_GROUP_TEXTFILE_DELIMITER);
        HashSet<String> userGroupNameAttributeSet = new HashSet<String>();
        while (st.hasMoreTokens()) {
            userGroupNameAttributeSet.add(st.nextToken().trim());
        }
        return userGroupNameAttributeSet;
    }

    public Set<String> getOtherUserAttributes() {
        String otherAttributes = this.prop.getProperty(LGSYNC_OTHER_USER_ATTRIBUTES);
        if (otherAttributes == null || otherAttributes.trim().isEmpty()) {
            otherAttributes = DEFAULT_OTHER_USER_ATTRIBUTES;
        }
        StringTokenizer st = new StringTokenizer(otherAttributes, DEFAULT_USER_GROUP_TEXTFILE_DELIMITER);
        HashSet<String> otherUserAttributes = new HashSet<String>();
        while (st.hasMoreTokens()) {
            otherUserAttributes.add(st.nextToken().trim());
        }
        return otherUserAttributes;
    }

    public String getUserCloudIdAttribute() {
        String val = this.prop.getProperty(LGSYNC_USER_CLOUDID_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return "objectid";
        }
        return val;
    }

    public String getUserCloudIdAttributeDataType() {
        String val = this.prop.getProperty(LGSYNC_USER_CLOUDID_ATTRIBUTE_DATATYPE);
        if (val == null || val.trim().isEmpty()) {
            return "byte[]";
        }
        return val;
    }

    public String getOtherUserAttributeDataType(String attrName) {
        String attrType = this.prop.getProperty("ranger.usersync.ldap.user.otherattributes." + attrName + "datatype");
        if (attrType == null || attrType.isEmpty()) {
            attrType = "String";
        }
        return attrType.trim();
    }

    public String getUserNameCaseConversion() {
        String ret = this.prop.getProperty(UGSYNC_USERNAME_CASE_CONVERSION_PARAM, "none");
        return ret.trim().toLowerCase();
    }

    public String getGroupNameCaseConversion() {
        String ret = this.prop.getProperty(UGSYNC_GROUPNAME_CASE_CONVERSION_PARAM, "none");
        return ret.trim().toLowerCase();
    }

    public String getSearchBase() {
        return this.prop.getProperty(LGSYNC_SEARCH_BASE);
    }

    public boolean isPagedResultsEnabled() {
        String val = this.prop.getProperty(LGSYNC_PAGED_RESULTS_ENABLED);
        boolean pagedResultsEnabled = val == null || val.trim().isEmpty() ? true : Boolean.valueOf(val);
        return pagedResultsEnabled;
    }

    public int getPagedResultsSize() {
        int pagedResultsSize = 500;
        String val = this.prop.getProperty(LGSYNC_PAGED_RESULTS_SIZE);
        pagedResultsSize = val == null || val.trim().isEmpty() ? 500 : Integer.parseInt(val);
        if (pagedResultsSize < 1) {
            pagedResultsSize = 500;
        }
        return pagedResultsSize;
    }

    public boolean isGroupSearchEnabled() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_ENABLED);
        boolean groupSearchEnabled = val == null || val.trim().isEmpty() ? true : Boolean.valueOf(val);
        return groupSearchEnabled;
    }

    public boolean isGroupSearchFirstEnabled() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_FIRST_ENABLED);
        boolean groupSearchFirstEnabled = val == null || val.trim().isEmpty() ? true : Boolean.valueOf(val);
        if (!this.isGroupSearchEnabled()) {
            groupSearchFirstEnabled = false;
        }
        return groupSearchFirstEnabled;
    }

    public boolean isUserSearchEnabled() {
        String val = this.prop.getProperty(LGSYNC_USER_SEARCH_ENABLED);
        boolean userSearchEnabled = val == null || val.trim().isEmpty() ? true : Boolean.valueOf(val);
        if (!this.isGroupSearchFirstEnabled()) {
            userSearchEnabled = true;
        }
        return userSearchEnabled;
    }

    public String getGroupSearchBase() throws Throwable {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_BASE);
        if (val == null || val.trim().isEmpty()) {
            val = this.getSearchBase();
        }
        if (val == null || val.trim().isEmpty()) {
            val = this.getUserSearchBase();
        }
        return val;
    }

    public int getGroupSearchScope() {
        String val = this.prop.getProperty(LGSYNC_GROUP_SEARCH_SCOPE);
        if (val == null || val.trim().isEmpty()) {
            return 2;
        }
        if ((val = val.trim().toLowerCase()).equals(DEFAULT_UGSYNC_MIN_GROUPID) || val.startsWith("base")) {
            return 0;
        }
        if (val.equals("1") || val.startsWith("one")) {
            return 1;
        }
        return 2;
    }

    public String getGroupObjectClass() {
        String val = this.prop.getProperty(LGSYNC_GROUP_OBJECT_CLASS);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_LGSYNC_GROUP_OBJECT_CLASS;
        }
        return val;
    }

    public String getGroupSearchFilter() {
        return this.prop.getProperty(LGSYNC_GROUP_SEARCH_FILTER);
    }

    public String getUserGroupMemberAttributeName() {
        String val = this.prop.getProperty(LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME);
        if (val == null || val.trim().isEmpty()) {
            return DEFAULT_LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME;
        }
        return val;
    }

    public String getGroupNameAttribute() {
        String val = this.prop.getProperty(LGSYNC_GROUP_NAME_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return "cn";
        }
        return val;
    }

    public String getGroupCloudIdAttribute() {
        String val = this.prop.getProperty(LGSYNC_GROUP_CLOUDID_ATTRIBUTE);
        if (val == null || val.trim().isEmpty()) {
            return "objectid";
        }
        return val;
    }

    public String getGroupCloudIdAttributeDataType() {
        String val = this.prop.getProperty(LGSYNC_GROUP_CLOUDID_ATTRIBUTE_DATATYPE);
        if (val == null || val.trim().isEmpty()) {
            return "byte[]";
        }
        return val;
    }

    public Set<String> getOtherGroupAttributes() {
        String otherAttributes = this.prop.getProperty(LGSYNC_OTHER_GROUP_ATTRIBUTES);
        if (otherAttributes == null || otherAttributes.trim().isEmpty()) {
            otherAttributes = DEFAULT_OTHER_GROUP_ATTRIBUTES;
        }
        StringTokenizer st = new StringTokenizer(otherAttributes, DEFAULT_USER_GROUP_TEXTFILE_DELIMITER);
        HashSet<String> otherGroupAttributes = new HashSet<String>();
        while (st.hasMoreTokens()) {
            otherGroupAttributes.add(st.nextToken().trim());
        }
        return otherGroupAttributes;
    }

    public String getOtherGroupAttributeDataType(String attrName) {
        String attrType = this.prop.getProperty("ranger.usersync.ldap.group.otherattributes." + attrName + "datatype");
        if (attrType == null || attrType.isEmpty()) {
            attrType = "String";
        }
        return attrType.trim();
    }

    public int getGroupHierarchyLevels() {
        String val = this.prop.getProperty(LGSYNC_GROUP_HIERARCHY_LEVELS);
        int groupHierarchyLevels = val == null || val.trim().isEmpty() ? 0 : Integer.parseInt(val);
        if (groupHierarchyLevels < 0) {
            groupHierarchyLevels = 0;
        }
        return groupHierarchyLevels;
    }

    public String getProperty(String aPropertyName) {
        return this.prop.getProperty(aPropertyName);
    }

    public String getProperty(String aPropertyName, String aDefaultValue) {
        return this.prop.getProperty(aPropertyName, aDefaultValue);
    }

    public String getPolicyMgrPassword() {
        String password = null;
        if (this.prop != null && this.prop.containsKey(SYNC_POLICY_MGR_KEYSTORE) && (password = this.prop.getProperty(SYNC_POLICY_MGR_PASSWORD)) != null && !password.isEmpty()) {
            return password;
        }
        if (this.prop != null && this.prop.containsKey(SYNC_POLICY_MGR_KEYSTORE) && this.prop.containsKey(SYNC_POLICY_MGR_ALIAS)) {
            String path = this.prop.getProperty(SYNC_POLICY_MGR_KEYSTORE);
            String alias = this.prop.getProperty(SYNC_POLICY_MGR_ALIAS, "policymgr.user.password");
            if (path != null && alias != null && !path.trim().isEmpty() && !alias.trim().isEmpty()) {
                if ("bcfks".equalsIgnoreCase(this.getSSLKeyStoreType())) {
                    String crendentialProviderPrefixBcfks = "bcfks://file";
                    path = crendentialProviderPrefixBcfks + path;
                }
                try {
                    password = CredentialReader.getDecryptedString((String)path.trim(), (String)alias.trim(), (String)this.getSSLKeyStoreType());
                }
                catch (Exception ex) {
                    password = null;
                }
                if (password != null && !password.trim().isEmpty() && !password.trim().equalsIgnoreCase("none")) {
                    this.prop.setProperty(SYNC_POLICY_MGR_PASSWORD, password);
                    return password;
                }
            }
        }
        return null;
    }

    public String getPolicyMgrUserName() {
        String userName = null;
        if (this.prop != null && this.prop.containsKey(SYNC_POLICY_MGR_USERNAME)) {
            userName = this.prop.getProperty(SYNC_POLICY_MGR_USERNAME);
        }
        if (userName == null || userName.isEmpty()) {
            userName = DEFAULT_POLICYMGR_USERNAME;
        }
        return userName;
    }

    public int getPolicyMgrMaxRetryAttempts() {
        return this.getIntProperty(this.prop, SYNC_POLICY_MGR_MAX_RETRY_ATTEMPTS, 0);
    }

    public int getPolicyMgrRetryIntervalMs() {
        return this.getIntProperty(this.prop, SYNC_POLICY_MGR_RETRY_INTERVAL_MS, 1000);
    }

    public String getSyncSource() {
        String syncSource = null;
        if (this.prop != null && this.prop.containsKey(SYNC_SOURCE)) {
            syncSource = this.prop.getProperty(SYNC_SOURCE);
            syncSource = syncSource == null || syncSource.trim().isEmpty() ? null : syncSource.trim();
        }
        return syncSource;
    }

    public String getContextReferral() {
        String referral = DEFAULT_LGSYNC_REFERRAL;
        if (this.prop != null && this.prop.containsKey(LGSYNC_REFERRAL)) {
            referral = this.prop.getProperty(LGSYNC_REFERRAL);
            referral = referral == null || referral.trim().isEmpty() ? DEFAULT_LGSYNC_REFERRAL : referral.trim().toLowerCase();
        }
        return referral;
    }

    public List<String> getAllRegexPatterns(String baseProperty) throws Throwable {
        ArrayList<String> regexPatterns = new ArrayList<String>();
        if (this.prop != null) {
            String baseRegex = this.prop.getProperty(baseProperty);
            if (baseRegex == null) {
                return regexPatterns;
            }
            regexPatterns.add(baseRegex);
            int i = 1;
            String nextRegex = this.prop.getProperty(baseProperty + "." + i);
            while (nextRegex != null) {
                regexPatterns.add(nextRegex);
                nextRegex = this.prop.getProperty(baseProperty + "." + ++i);
            }
        }
        return regexPatterns;
    }

    public String getUserSyncMappingUserNameHandler() {
        String val = this.prop.getProperty(SYNC_MAPPING_USERNAME_HANDLER);
        if (val == null) {
            val = "org.apache.ranger.usergroupsync.RegEx";
        }
        return val;
    }

    public String getUserSyncMappingGroupNameHandler() {
        String val = this.prop.getProperty(SYNC_MAPPING_GROUPNAME_HANDLER);
        if (val == null) {
            val = "org.apache.ranger.usergroupsync.RegEx";
        }
        return val;
    }

    public String getGroupRoleRules() {
        String GroupRoleRules;
        if (this.prop != null && this.prop.containsKey(GROUP_BASED_ROLE_ASSIGNMENT_RULES) && StringUtils.isNotBlank((String)(GroupRoleRules = this.prop.getProperty(GROUP_BASED_ROLE_ASSIGNMENT_RULES)))) {
            return GroupRoleRules.trim();
        }
        return null;
    }

    public String getWhileListUserRoleRules() {
        String whiteListUserRoleRules;
        if (this.prop != null && this.prop.containsKey(WHITELIST_USER_ROLE_ASSIGNMENT_RULES) && StringUtils.isNotBlank((String)(whiteListUserRoleRules = this.prop.getProperty(WHITELIST_USER_ROLE_ASSIGNMENT_RULES)))) {
            return whiteListUserRoleRules.trim();
        }
        return DEFAULT_WHITELIST_USER_ROLE_ASSIGNMENT_RULES;
    }

    public String getUserGroupDelimiter() {
        String UserGroupDelimiter;
        if (this.prop != null && this.prop.containsKey(USERS_GROUPS_ASSIGNMENT_LIST_DELIMITER) && (UserGroupDelimiter = this.prop.getProperty(USERS_GROUPS_ASSIGNMENT_LIST_DELIMITER)) != null && !UserGroupDelimiter.isEmpty()) {
            return UserGroupDelimiter;
        }
        return null;
    }

    public String getUserGroupNameDelimiter() {
        String UserGroupNameDelimiter;
        if (this.prop != null && this.prop.containsKey(USERNAME_GROUPNAME_ASSIGNMENT_LIST_DELIMITER) && (UserGroupNameDelimiter = this.prop.getProperty(USERNAME_GROUPNAME_ASSIGNMENT_LIST_DELIMITER)) != null && !UserGroupNameDelimiter.isEmpty()) {
            return UserGroupNameDelimiter;
        }
        return null;
    }

    public boolean isUserSyncRangerCookieEnabled() {
        String val = this.prop.getProperty(USERSYNC_RANGER_COOKIE_ENABLED_PROP);
        return val == null || Boolean.valueOf(val.trim()) != false;
    }

    public String getRangerAdminCookieName() {
        String ret = "RANGERADMINSESSIONID";
        String val = this.prop.getProperty(RANGER_ADMIN_COOKIE_NAME_PROPS);
        if (StringUtils.isNotBlank((String)val)) {
            ret = val;
        }
        return ret;
    }

    public String getRoleDelimiter() {
        String roleDelimiter;
        if (this.prop != null && this.prop.containsKey(ROLE_ASSIGNMENT_LIST_DELIMITER) && (roleDelimiter = this.prop.getProperty(ROLE_ASSIGNMENT_LIST_DELIMITER)) != null && !roleDelimiter.isEmpty()) {
            return roleDelimiter;
        }
        return null;
    }

    public boolean isStartTlsEnabled() {
        String val = this.prop.getProperty(LGSYNC_LDAP_STARTTLS_ENABLED);
        boolean starttlsEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return starttlsEnabled;
    }

    public boolean isDeltaSyncEnabled() {
        String val = this.prop.getProperty(LGSYNC_LDAP_DELTASYNC_ENABLED);
        boolean deltaSyncEnabled = val == null || val.trim().isEmpty() ? false : Boolean.valueOf(val);
        return deltaSyncEnabled;
    }

    public void setUserSearchFilter(String filter) {
        this.prop.setProperty(LGSYNC_USER_SEARCH_FILTER, filter);
    }

    public void setGroupSearchFilter(String filter) {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_FILTER, filter);
    }

    public void setGroupSearchEnabled(boolean groupSearchEnabled) {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_ENABLED, String.valueOf(groupSearchEnabled));
    }

    public void setPagedResultsEnabled(boolean pagedResultsEnabled) {
        this.prop.setProperty(LGSYNC_PAGED_RESULTS_ENABLED, String.valueOf(pagedResultsEnabled));
    }

    public void setProperty(String name, String value) {
        this.prop.setProperty(name, value);
    }

    public void setUserSearchBase(String userSearchBase) throws Throwable {
        this.prop.setProperty(LGSYNC_USER_SEARCH_BASE, userSearchBase);
    }

    public void setGroupSearchBase(String groupSearchBase) throws Throwable {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_BASE, groupSearchBase);
    }

    public void setGroupSearchFirstEnabled(boolean groupSearchFirstEnabled) {
        this.prop.setProperty(LGSYNC_GROUP_SEARCH_FIRST_ENABLED, String.valueOf(groupSearchFirstEnabled));
    }

    public void setUserSearchEnabled(boolean userSearchEnabled) {
        this.prop.setProperty(LGSYNC_USER_SEARCH_ENABLED, String.valueOf(userSearchEnabled));
    }

    public void setUserGroupMemberAttributeName(String groupMemberAttrName) {
        this.prop.setProperty(LGSYNC_GROUP_MEMBER_ATTRIBUTE_NAME, groupMemberAttrName);
    }

    public void setUserObjectClass(String userObjectClass) {
        this.prop.setProperty(LGSYNC_USER_OBJECT_CLASS, userObjectClass);
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.prop.setProperty(LGSYNC_GROUP_OBJECT_CLASS, groupObjectClass);
    }

    public void setDeltaSync(boolean deltaSyncEnabled) {
        this.prop.setProperty(LGSYNC_LDAP_DELTASYNC_ENABLED, String.valueOf(deltaSyncEnabled));
    }

    public void setUserNameAttribute(String userNameAttr) {
        this.prop.setProperty(LGSYNC_USER_NAME_ATTRIBUTE, userNameAttr);
    }

    public void setGroupHierarchyLevel(int groupHierarchyLevel) {
        this.prop.setProperty(LGSYNC_GROUP_HIERARCHY_LEVELS, String.valueOf(groupHierarchyLevel));
    }

    public void setGroupnames(String groupnames) {
        this.prop.setProperty(LGSYNC_GROUPNAMES, groupnames);
    }

    public String getUserSyncMetricsFileName() throws IOException {
        String fileName;
        String current;
        String val = this.prop.getProperty(UGSYNC_METRICS_FILEPATH);
        if (StringUtils.isBlank((String)val)) {
            val = StringUtils.isBlank((String)this.prop.getProperty("ranger.usersync.logdir")) ? (StringUtils.isBlank((String)System.getProperty("logdir")) ? DEFAULT_UGSYNC_METRICS_FILEPATH : System.getProperty("logdir")) : this.prop.getProperty("ranger.usersync.logdir");
        }
        if (Files.notExists(Paths.get(val, new String[0]), new LinkOption[0]) && Files.notExists(Paths.get(val = (current = new File(".").getCanonicalPath()) + DEFAULT_MAPPING_SEPARATOR + val, new String[0]), new LinkOption[0])) {
            return null;
        }
        StringBuilder pathAndFileName = new StringBuilder(val);
        if (!val.endsWith(DEFAULT_MAPPING_SEPARATOR)) {
            pathAndFileName.append(DEFAULT_MAPPING_SEPARATOR);
        }
        if (StringUtils.isBlank((String)(fileName = this.prop.getProperty(UGSYNC_METRICS_FILENAME)))) {
            fileName = DEFAULT_UGSYNC_METRICS_FILENAME;
        }
        pathAndFileName.append(fileName);
        return pathAndFileName.toString();
    }

    public long getUserSyncMetricsFrequency() {
        long ret = 10000L;
        String val = this.prop.getProperty(UGSYNC_METRICS_FREQUENCY_TIME_IN_MILLIS_PARAM);
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Long.valueOf(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isUserSyncMetricsEnabled() {
        String val = this.prop.getProperty(UGSYNC_METRICS_ENABLED_PROP);
        return "true".equalsIgnoreCase(StringUtils.trimToEmpty((String)val));
    }

    public boolean isUserSyncDeletesEnabled() {
        String val = this.prop.getProperty(UGSYNC_DELETES_ENABLED);
        boolean isUserSyncDeletesEnabled = StringUtils.isEmpty((String)val) ? false : Boolean.valueOf(val);
        return isUserSyncDeletesEnabled;
    }

    public long getUserSyncDeletesFrequency() throws Throwable {
        long ret = 1L;
        String val = this.prop.getProperty(UGSYNC_DELETES_FREQUENCY);
        if (StringUtils.isNotBlank((String)val)) {
            ret = Long.valueOf(val);
            if (!this.isTestRunEnabled() && ret < 10L) {
                LOG.info("Frequency of computing deletes cannot be set below 10");
                ret = 10L;
            }
        }
        return ret;
    }

    public String getCurrentSyncSource() throws Throwable {
        String className = this.getUserGroupSource().getClass().getName();
        String currentSyncSource = LGSYNC_SOURCE_CLASS.equals(className) ? "LDAP/AD" : (UGSYNC_SOURCE_CLASS.equalsIgnoreCase(className) ? "Unix" : "File");
        return currentSyncSource;
    }

    public boolean isUserSyncNameValidationEnabled() {
        String val = this.prop.getProperty(UGSYNC_NAME_VALIDATION_ENABLED);
        boolean isUserSyncNameValidationEnabled = StringUtils.isEmpty((String)val) ? false : Boolean.valueOf(val);
        return isUserSyncNameValidationEnabled;
    }

    public String getRegexSeparator() {
        String ret = DEFAULT_MAPPING_SEPARATOR;
        String val = this.prop.getProperty(SYNC_MAPPING_SEPARATOR);
        if (StringUtils.isNotEmpty((String)val)) {
            if (val.length() == 1) {
                ret = val;
            } else {
                LOG.warn("More than one character found in RegEx Separator, using default RegEx Separator /");
            }
        }
        LOG.info(String.format("Using %s as the RegEx Separator", ret));
        return ret;
    }

    private int getIntProperty(Properties prop, String key, int defaultValue) {
        int ret = defaultValue;
        String val = prop.getProperty(key);
        if (StringUtils.isNotBlank((String)val)) {
            try {
                ret = Integer.parseInt(val);
            }
            catch (NumberFormatException excp) {
                LOG.warn("Invalid value for property: " + key + "=" + val + ". Will use default value: " + defaultValue, (Throwable)excp);
            }
        }
        return ret;
    }

    public boolean isSyncSourceValidationEnabled() {
        boolean isSyncSourceValidationEnabled = true;
        String val = this.prop.getProperty(UGSYNC_SYNC_SOURCE_VALIDATION_ENABLED);
        if (StringUtils.isNotEmpty((String)val)) {
            isSyncSourceValidationEnabled = Boolean.parseBoolean(val);
        }
        return isSyncSourceValidationEnabled;
    }
}

