/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.rat.analysis.HeaderCheckWorker;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;

public class DocumentHeaderAnalyser
implements IDocumentAnalyser {
    private final IHeaderMatcher matcher;

    public DocumentHeaderAnalyser(IHeaderMatcher matcher) {
        this.matcher = matcher;
    }

    public void analyse(Document document) throws RatDocumentAnalysisException {
        Reader reader = null;
        try {
            reader = document.reader();
            HeaderCheckWorker worker = new HeaderCheckWorker(reader, this.matcher, document);
            worker.read();
        }
        catch (IOException e) {
            throw new RatDocumentAnalysisException("Cannot read header", e);
        }
        catch (RatHeaderAnalysisException e) {
            throw new RatDocumentAnalysisException("Cannot analyse header", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

