/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.ReportTransformer;
import org.apache.rat.api.RatException;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.xml.XmlReportFactory;
import org.apache.rat.report.xml.writer.impl.base.XmlWriter;
import org.apache.rat.walker.ArchiveWalker;
import org.apache.rat.walker.DirectoryWalker;

public class Report {
    private static final String EXCLUDE_CLI = "e";
    private static final String EXCLUDE_FILE_CLI = "E";
    private static final String STYLESHEET_CLI = "s";
    private static final String HELP = "h";
    private final String baseDirectory;
    private FilenameFilter inputFileFilter = null;

    public static final void main(String[] args) throws Exception {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher(Defaults.createDefaultMatcher());
        configuration.setApproveDefaultLicenses(true);
        Options opts = Report.buildOptions();
        CommandLine cl = null;
        try {
            cl = new DefaultParser().parse(opts, args);
        }
        catch (ParseException e) {
            System.err.println("Please use the \"--help\" option to see a list of valid commands and options");
            System.exit(1);
            return;
        }
        if (cl.hasOption(HELP)) {
            Report.printUsage(opts);
        }
        if ((args = cl.getArgs()) == null || args.length != 1) {
            Report.printUsage(opts);
        } else {
            String excludeFileName;
            Report report = new Report(args[0]);
            if (cl.hasOption('a') || cl.hasOption('A')) {
                configuration.setAddingLicenses(true);
                configuration.setAddingLicensesForced(cl.hasOption('f'));
                configuration.setCopyrightMessage(cl.getOptionValue("c"));
            }
            if (cl.hasOption(EXCLUDE_CLI)) {
                String[] excludes = cl.getOptionValues(EXCLUDE_CLI);
                if (excludes != null) {
                    FilenameFilter filter = Report.parseExclusions(Arrays.asList(excludes));
                    report.setInputFileFilter(filter);
                }
            } else if (cl.hasOption(EXCLUDE_FILE_CLI) && (excludeFileName = cl.getOptionValue(EXCLUDE_FILE_CLI)) != null) {
                FilenameFilter filter = Report.parseExclusions(FileUtils.readLines(new File(excludeFileName), Charset.forName("UTF-8")));
                report.setInputFileFilter(filter);
            }
            if (cl.hasOption('x')) {
                report.report(System.out, configuration);
            } else if (!cl.hasOption(STYLESHEET_CLI)) {
                report.styleReport(System.out, configuration);
            } else {
                String[] style = cl.getOptionValues(STYLESHEET_CLI);
                if (style.length != 1) {
                    System.err.println("please specify a single stylesheet");
                    System.exit(1);
                }
                try {
                    Report.report(System.out, report.getDirectory(System.out), (InputStream)new FileInputStream(style[0]), configuration);
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("stylesheet " + style[0] + " doesn't exist");
                    System.exit(1);
                }
            }
        }
    }

    static FilenameFilter parseExclusions(List<String> excludes) throws IOException {
        OrFileFilter orFilter = new OrFileFilter();
        int ignoredLines = 0;
        for (String exclude : excludes) {
            try {
                if (exclude.startsWith("#") || StringUtils.isEmpty(exclude)) {
                    ++ignoredLines;
                    continue;
                }
                String exclusion = exclude.trim();
                orFilter.addFileFilter((IOFileFilter)new RegexFileFilter(exclusion));
                orFilter.addFileFilter((IOFileFilter)new NameFileFilter(exclusion));
                orFilter.addFileFilter((IOFileFilter)new WildcardFileFilter(exclusion));
            }
            catch (PatternSyntaxException e) {
                System.err.println("Will skip given exclusion '" + exclude + "' due to " + e);
            }
        }
        System.err.println("Ignored " + ignoredLines + " lines in your exclusion files as comments or empty lines.");
        return new NotFileFilter(orFilter);
    }

    private static Options buildOptions() {
        Options opts = new Options();
        Option help = new Option(HELP, "help", false, "Print help for the RAT command line interface and exit");
        opts.addOption(help);
        OptionGroup addLicenseGroup = new OptionGroup();
        String addLicenseDesc = "Add the default license header to any file with an unknown license that is not in the exclusion list. By default new files will be created with the license header, to force the modification of existing files use the --force option.";
        Option addLicence = new Option("a", "addLicence", false, addLicenseDesc);
        addLicenseGroup.addOption(addLicence);
        Option addLicense = new Option("A", "addLicense", false, addLicenseDesc);
        addLicenseGroup.addOption(addLicense);
        opts.addOptionGroup(addLicenseGroup);
        Option write = new Option("f", "force", false, "Forces any changes in files to be written directly to the source files (i.e. new files are not created)");
        opts.addOption(write);
        Option copyright = new Option("c", "copyright", true, "The copyright message to use in the license headers, usually in the form of \"Copyright 2008 Foo\"");
        opts.addOption(copyright);
        Option exclude = Option.builder(EXCLUDE_CLI).argName("expression").longOpt("exclude").hasArgs().desc("Excludes files matching wildcard <expression>. Note that --dir is required when using this parameter. Allows multiple arguments.").build();
        opts.addOption(exclude);
        Option excludeFile = Option.builder(EXCLUDE_FILE_CLI).argName("fileName").longOpt("exclude-file").hasArgs().desc("Excludes files matching regular expression in <file> Note that --dir is required when using this parameter. ").build();
        opts.addOption(excludeFile);
        Option dir = new Option("d", "dir", false, "Used to indicate source when using --exclude");
        opts.addOption(dir);
        OptionGroup outputType = new OptionGroup();
        Option xml = new Option("x", "xml", false, "Output the report in raw XML format.  Not compatible with -s");
        outputType.addOption(xml);
        Option xslt = new Option(STYLESHEET_CLI, "stylesheet", true, "XSLT stylesheet to use when creating the report.  Not compatible with -x");
        outputType.addOption(xslt);
        opts.addOptionGroup(outputType);
        return opts;
    }

    private static void printUsage(Options opts) {
        HelpFormatter f = new HelpFormatter();
        String header = "\nAvailable options";
        String footer = "\nNOTE:\nRat is really little more than a grep ATM\nRat is also rather memory hungry ATM\nRat is very basic ATM\nRat highlights possible issues\nRat reports require interpretation\nRat often requires some tuning before it runs well against a project\nRat relies on heuristics: it may miss issues\n";
        f.printHelp("java -jar apache-rat/target/apache-rat-CURRENT-VERSION.jar [options] [DIR|TARBALL]", header, opts, footer, false);
        System.exit(0);
    }

    private Report(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public void setInputFileFilter(FilenameFilter inputFileFilter) {
        this.inputFileFilter = inputFileFilter;
    }

    @Deprecated
    public ClaimStatistic report(PrintStream out) throws Exception {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher(Defaults.createDefaultMatcher());
        configuration.setApproveDefaultLicenses(true);
        return this.report(out, configuration);
    }

    public ClaimStatistic report(PrintStream out, ReportConfiguration configuration) throws Exception {
        IReportable base = this.getDirectory(out);
        if (base != null) {
            return Report.report(base, new OutputStreamWriter(out), configuration);
        }
        return null;
    }

    private IReportable getDirectory(PrintStream out) {
        File base = new File(this.baseDirectory);
        if (!base.exists()) {
            out.print("ERROR: ");
            out.print(this.baseDirectory);
            out.print(" does not exist.\n");
            return null;
        }
        if (base.isDirectory()) {
            return new DirectoryWalker(base, this.inputFileFilter);
        }
        try {
            return new ArchiveWalker(base, this.inputFileFilter);
        }
        catch (IOException ex) {
            out.print("ERROR: ");
            out.print(this.baseDirectory);
            out.print(" is not valid gzip data.\n");
            return null;
        }
    }

    @Deprecated
    public void styleReport(PrintStream out) throws Exception {
        ReportConfiguration configuration = new ReportConfiguration();
        configuration.setHeaderMatcher(Defaults.createDefaultMatcher());
        configuration.setApproveDefaultLicenses(true);
        this.styleReport(out, configuration);
    }

    public void styleReport(PrintStream out, ReportConfiguration configuration) throws Exception {
        IReportable base = this.getDirectory(out);
        if (base != null) {
            InputStream style = Defaults.getDefaultStyleSheet();
            Report.report(out, base, style, configuration);
        }
    }

    public static void report(PrintStream out, IReportable base, InputStream style, ReportConfiguration pConfiguration) throws IOException, TransformerConfigurationException, InterruptedException, RatException {
        Report.report(new OutputStreamWriter(out), base, style, pConfiguration);
    }

    public static ClaimStatistic report(Writer out, IReportable base, InputStream style, ReportConfiguration pConfiguration) throws IOException, TransformerConfigurationException, InterruptedException, RatException {
        PipedReader reader = new PipedReader();
        PipedWriter writer = new PipedWriter(reader);
        ReportTransformer transformer = new ReportTransformer(out, style, (Reader)reader);
        Thread transformerThread = new Thread(transformer);
        transformerThread.start();
        ClaimStatistic statistic = Report.report(base, writer, pConfiguration);
        writer.flush();
        writer.close();
        transformerThread.join();
        return statistic;
    }

    public static ClaimStatistic report(IReportable container, Writer out, ReportConfiguration pConfiguration) throws IOException, RatException {
        XmlWriter writer = new XmlWriter(out);
        ClaimStatistic statistic = new ClaimStatistic();
        RatReport report = XmlReportFactory.createStandardReport(writer, statistic, pConfiguration);
        report.startReport();
        container.run(report);
        report.endReport();
        writer.closeDocument();
        return statistic;
    }
}

