/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import java.util.regex.Pattern;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.FullTextMatchingLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class OASISLicense
extends FullTextMatchingLicense {
    private static final String COPYRIGHT_PATTERN_DEFN = ".*Copyright\\s.*OASIS Open.*";
    private static final String CLAUSE_DEFN = "This document and translations of it may be copied and furnished to others and derivative worksthat comment on or otherwise explain it or assist in its implementation may be preparedcopied published and distributed";
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile(".*Copyright\\s.*OASIS Open.*");
    boolean copyrightMatch = false;

    public OASISLicense() {
        super(MetaData.RAT_LICENSE_FAMILY_CATEGORY_DATUM_OASIS, MetaData.RAT_LICENSE_FAMILY_NAME_DATUM_OASIS_OPEN_LICENSE, "No modifications allowed", CLAUSE_DEFN);
    }

    @Override
    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        boolean result = false;
        if (this.copyrightMatch) {
            result = super.match(subject, line);
        } else {
            this.copyrightMatch = COPYRIGHT_PATTERN.matcher(line).matches();
        }
        return result;
    }

    @Override
    public void reset() {
        this.copyrightMatch = false;
        super.reset();
    }
}

