/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.util;

import java.util.Iterator;
import java.util.List;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;

public final class HeaderMatcherMultiplexer
implements IHeaderMatcher {
    private final List<IHeaderMatcher> matchers;

    public HeaderMatcherMultiplexer(List<IHeaderMatcher> matchers) {
        this.matchers = matchers;
    }

    @Override
    public boolean match(Document subject, String line) throws RatHeaderAnalysisException {
        IHeaderMatcher matcher;
        boolean result = false;
        Iterator<IHeaderMatcher> iterator = this.matchers.iterator();
        while (iterator.hasNext() && !(result = (matcher = iterator.next()).match(subject, line))) {
        }
        return result;
    }

    @Override
    public void reset() {
        for (IHeaderMatcher matcher : this.matchers) {
            matcher.reset();
        }
    }
}

