/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import org.apache.rat.analysis.DocumentHeaderAnalyser;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.document.impl.guesser.ArchiveGuesser;
import org.apache.rat.document.impl.guesser.BinaryGuesser;
import org.apache.rat.document.impl.guesser.NoteGuesser;

public class DefaultAnalyserFactory {
    public static final IDocumentAnalyser createDefaultAnalyser(IHeaderMatcher matcher) {
        return new DefaultAnalyser(matcher);
    }

    private static final class DefaultAnalyser
    implements IDocumentAnalyser {
        private final IHeaderMatcher matcher;

        public DefaultAnalyser(IHeaderMatcher matcher) {
            this.matcher = matcher;
        }

        @Override
        public void analyse(Document subject) throws RatDocumentAnalysisException {
            MetaData.Datum documentCategory;
            if (NoteGuesser.isNote(subject)) {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_NOTICE;
            } else if (ArchiveGuesser.isArchive(subject)) {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_ARCHIVE;
            } else if (BinaryGuesser.isBinary(subject)) {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_BINARY;
            } else {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_STANDARD;
                DocumentHeaderAnalyser headerAnalyser = new DocumentHeaderAnalyser(this.matcher);
                headerAnalyser.analyse(subject);
            }
            subject.getMetaData().set(documentCategory);
        }
    }
}

