/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.license;

import java.util.regex.Pattern;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.license.BaseLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;

public class CopyrightHeader
extends BaseLicense
implements IHeaderMatcher {
    public static final String COPYRIGHT_PREFIX_PATTERN_DEFN = ".*Copyright [0-9]{4}(\\-[0-9]{4})? ";
    private Pattern copyrightPattern;
    private String copyrightOwner;
    private boolean copyrightMatch = false;

    public CopyrightHeader() {
    }

    protected CopyrightHeader(MetaData.Datum licenseFamilyCategory, MetaData.Datum licenseFamilyName, String notes) {
        super(licenseFamilyCategory, licenseFamilyName, notes);
    }

    protected CopyrightHeader(MetaData.Datum licenseFamilyCategory, MetaData.Datum licenseFamilyName, String notes, String copyrightOwner) {
        this(licenseFamilyCategory, licenseFamilyName, notes);
        this.setCopyrightOwner(copyrightOwner);
    }

    public final void setCopyrightOwner(String copyrightOwner) {
        this.copyrightOwner = copyrightOwner;
        this.copyrightPattern = Pattern.compile(COPYRIGHT_PREFIX_PATTERN_DEFN + copyrightOwner + ".*", 2);
    }

    public String getCopyRightOwner() {
        return this.copyrightOwner;
    }

    public boolean hasCopyrightPattern() {
        return this.copyrightPattern != null;
    }

    protected boolean isCopyrightMatch() {
        return this.copyrightMatch;
    }

    protected boolean matchCopyright(String s) {
        if (!this.copyrightMatch) {
            this.copyrightMatch = this.copyrightPattern.matcher(s).matches();
        }
        return this.copyrightMatch;
    }

    @Override
    public boolean match(Document subject, String s) throws RatHeaderAnalysisException {
        if (!this.copyrightMatch && this.matchCopyright(s)) {
            this.reportOnLicense(subject);
        }
        return this.copyrightMatch;
    }

    @Override
    public void reset() {
        this.copyrightMatch = false;
    }
}

