/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.io.nativeio;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.ratis.io.nativeio.Errno;
import org.apache.ratis.io.nativeio.NativeIOException;
import org.apache.ratis.protocol.AlreadyExistsException;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.NativeCodeLoader;
import org.apache.ratis.util.PlatformUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeIO {
    private static final Logger LOG = LoggerFactory.getLogger(NativeIO.class);
    private static boolean workaroundNonThreadSafePasswdCalls = false;
    private static boolean nativeLoaded = false;
    private static boolean initialized;

    private static void initNativeLib() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                NativeIO.initNative();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                LOG.debug("Unable to initialize NativeIO libraries", t);
            }
        }
    }

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    private static native void initNative();

    static long getMemlockLimit() {
        return NativeIO.isAvailable() ? NativeIO.getMemlockLimit0() : 0L;
    }

    private static native long getMemlockLimit0();

    private static String stripDomain(String name) {
        int i = name.indexOf(92);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static FileInputStream getShareDeleteFileInputStream(File f) throws IOException {
        if (!PlatformUtils.WINDOWS) {
            return new FileInputStream(f);
        }
        FileDescriptor fd = Windows.createFile(f.getAbsolutePath(), 0x80000000L, 7L, 3L);
        return new FileInputStream(fd);
    }

    public static FileInputStream getShareDeleteFileInputStream(File f, long seekOffset) throws IOException {
        if (!PlatformUtils.WINDOWS) {
            RandomAccessFile rf = new RandomAccessFile(f, "r");
            if (seekOffset > 0L) {
                rf.seek(seekOffset);
            }
            return new FileInputStream(rf.getFD());
        }
        FileDescriptor fd = Windows.createFile(f.getAbsolutePath(), 0x80000000L, 7L, 3L);
        if (seekOffset > 0L) {
            Windows.setFilePointer(fd, seekOffset, 0L);
        }
        return new FileInputStream(fd);
    }

    public static FileOutputStream getCreateForWriteFileOutputStream(File f, int permissions) throws IOException {
        if (!PlatformUtils.WINDOWS) {
            try {
                FileDescriptor fd = POSIX.open(f.getAbsolutePath(), POSIX.O_WRONLY | POSIX.O_CREAT | POSIX.O_EXCL, permissions);
                return new FileOutputStream(fd);
            }
            catch (NativeIOException nioe) {
                if (nioe.getErrno() == Errno.EEXIST) {
                    throw new AlreadyExistsException(nioe);
                }
                throw nioe;
            }
        }
        try {
            FileDescriptor fd = Windows.createFile(f.getCanonicalPath(), 0x40000000L, 7L, 1L);
            POSIX.chmod(f.getCanonicalPath(), permissions);
            return new FileOutputStream(fd);
        }
        catch (NativeIOException nioe) {
            if (nioe.getErrorCode() == 80L) {
                throw new AlreadyExistsException(nioe);
            }
            throw nioe;
        }
    }

    public static void renameTo(File src, File dst) throws IOException {
        if (!nativeLoaded) {
            if (!src.renameTo(dst)) {
                throw new IOException("renameTo(src=" + src + ", dst=" + dst + ") failed.");
            }
        } else {
            NativeIO.renameTo0(src.getAbsolutePath(), dst.getAbsolutePath());
        }
    }

    private static native void renameTo0(String var0, String var1) throws NativeIOException;

    private static native void link0(String var0, String var1) throws NativeIOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFileUnbuffered(File src, File dst) throws IOException {
        if (nativeLoaded && PlatformUtils.WINDOWS) {
            NativeIO.copyFileUnbuffered0(src.getAbsolutePath(), dst.getAbsolutePath());
            return;
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            long transferred;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dst);
            input = fis.getChannel();
            output = fos.getChannel();
            long position = 0L;
            for (long remaining = input.size(); remaining > 0L; remaining -= transferred, position += transferred) {
                transferred = input.transferTo(position, remaining, output);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(LOG, output, fos, input, fis);
            throw throwable;
        }
        IOUtils.cleanup(LOG, output, fos, input, fis);
    }

    private static native void copyFileUnbuffered0(String var0, String var1) throws NativeIOException;

    static {
        NativeIO.initNativeLib();
        initialized = false;
    }

    private static class CachedUid {
        final long timestamp;
        final String username;

        public CachedUid(String username, long timestamp) {
            this.timestamp = timestamp;
            this.username = username;
        }
    }

    public static class Windows {
        public static final long GENERIC_READ = 0x80000000L;
        public static final long GENERIC_WRITE = 0x40000000L;
        public static final long FILE_SHARE_READ = 1L;
        public static final long FILE_SHARE_WRITE = 2L;
        public static final long FILE_SHARE_DELETE = 4L;
        public static final long CREATE_NEW = 1L;
        public static final long CREATE_ALWAYS = 2L;
        public static final long OPEN_EXISTING = 3L;
        public static final long OPEN_ALWAYS = 4L;
        public static final long TRUNCATE_EXISTING = 5L;
        public static final long FILE_BEGIN = 0L;
        public static final long FILE_CURRENT = 1L;
        public static final long FILE_END = 2L;
        public static final long FILE_ATTRIBUTE_NORMAL = 128L;

        public static void createDirectoryWithMode(File path, int mode) throws IOException {
            Windows.createDirectoryWithMode0(path.getAbsolutePath(), mode);
        }

        private static native void createDirectoryWithMode0(String var0, int var1) throws NativeIOException;

        public static native FileDescriptor createFile(String var0, long var1, long var3, long var5) throws IOException;

        public static FileOutputStream createFileOutputStreamWithMode(File path, boolean append, int mode) throws IOException {
            long shareMode = 3L;
            long creationDisposition = append ? 4L : 2L;
            return new FileOutputStream(Windows.createFileWithMode0(path.getAbsolutePath(), 0x40000000L, shareMode, creationDisposition, mode));
        }

        private static native FileDescriptor createFileWithMode0(String var0, long var1, long var3, long var5, int var7) throws NativeIOException;

        public static native long setFilePointer(FileDescriptor var0, long var1, long var3) throws IOException;

        private static native String getOwner(FileDescriptor var0) throws IOException;

        private static native boolean access0(String var0, int var1);

        public static boolean access(String path, AccessRight desiredAccess) throws IOException {
            return Windows.access0(path, desiredAccess.accessRight());
        }

        public static native void extendWorkingSetSize(long var0) throws IOException;

        static {
            NativeIO.initNativeLib();
        }

        public static enum AccessRight {
            ACCESS_READ(1),
            ACCESS_WRITE(2),
            ACCESS_EXECUTE(32);

            private final int accessRight;

            private AccessRight(int access) {
                this.accessRight = access;
            }

            public int accessRight() {
                return this.accessRight;
            }
        }
    }

    public static class POSIX {
        public static int O_RDONLY = -1;
        public static int O_WRONLY = -1;
        public static int O_RDWR = -1;
        public static int O_CREAT = -1;
        public static int O_EXCL = -1;
        public static int O_NOCTTY = -1;
        public static int O_TRUNC = -1;
        public static int O_APPEND = -1;
        public static int O_NONBLOCK = -1;
        public static int O_SYNC = -1;
        public static int POSIX_FADV_NORMAL = -1;
        public static int POSIX_FADV_RANDOM = -1;
        public static int POSIX_FADV_SEQUENTIAL = -1;
        public static int POSIX_FADV_WILLNEED = -1;
        public static int POSIX_FADV_DONTNEED = -1;
        public static int POSIX_FADV_NOREUSE = -1;
        public static int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
        public static int SYNC_FILE_RANGE_WRITE = 2;
        public static int SYNC_FILE_RANGE_WAIT_AFTER = 4;
        public static boolean fadvisePossible = false;
        private static boolean nativeLoaded = false;
        private static boolean syncFileRangePossible = true;
        private static long cacheTimeout = -1L;
        private static CacheManipulator cacheManipulator = new CacheManipulator();
        public static final int MMAP_PROT_READ = 1;
        public static final int MMAP_PROT_WRITE = 2;
        public static final int MMAP_PROT_EXEC = 4;

        public static CacheManipulator getCacheManipulator() {
            return cacheManipulator;
        }

        public static void setCacheManipulator(CacheManipulator cacheManipulator) {
            POSIX.cacheManipulator = cacheManipulator;
        }

        public static boolean isAvailable() {
            return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
        }

        private static void assertCodeLoaded() throws IOException {
            if (!POSIX.isAvailable()) {
                throw new IOException("NativeIO was not loaded");
            }
        }

        public static native FileDescriptor open(String var0, int var1, int var2) throws IOException;

        private static native Stat fstat(FileDescriptor var0) throws IOException;

        private static native void chmodImpl(String var0, int var1) throws IOException;

        public static void chmod(String path, int mode) throws IOException {
            if (!PlatformUtils.WINDOWS) {
                POSIX.chmodImpl(path, mode);
            } else {
                try {
                    POSIX.chmodImpl(path, mode);
                }
                catch (NativeIOException nioe) {
                    if (nioe.getErrorCode() == 3L) {
                        throw new NativeIOException("No such file or directory", Errno.ENOENT);
                    }
                    LOG.warn(String.format("NativeIO.chmod error (%d): %s", nioe.getErrorCode(), nioe.getMessage()));
                    throw new NativeIOException("Unknown error", Errno.UNKNOWN);
                }
            }
        }

        static native void posix_fadvise(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

        static native void sync_file_range(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

        static void posixFadviseIfPossible(String identifier, FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
            if (nativeLoaded && fadvisePossible) {
                try {
                    POSIX.posix_fadvise(fd, offset, len, flags);
                }
                catch (UnsatisfiedLinkError ule) {
                    fadvisePossible = false;
                }
            }
        }

        public static void syncFileRangeIfPossible(FileDescriptor fd, long offset, long nbytes, int flags) throws NativeIOException {
            if (nativeLoaded && syncFileRangePossible) {
                try {
                    POSIX.sync_file_range(fd, offset, nbytes, flags);
                }
                catch (UnsatisfiedLinkError | UnsupportedOperationException uoe) {
                    syncFileRangePossible = false;
                }
            }
        }

        static native void mlock_native(ByteBuffer var0, long var1) throws NativeIOException;

        static void mlock(ByteBuffer buffer, long len) throws IOException {
            POSIX.assertCodeLoaded();
            if (!buffer.isDirect()) {
                throw new IOException("Cannot mlock a non-direct ByteBuffer");
            }
            POSIX.mlock_native(buffer, len);
        }

        private static native long getUIDforFDOwnerforOwner(FileDescriptor var0) throws IOException;

        private static native String getUserName(long var0) throws IOException;

        public static native long mmap(FileDescriptor var0, int var1, boolean var2, long var3) throws IOException;

        public static native void munmap(long var0, long var2) throws IOException;

        static {
            NativeIO.initNativeLib();
        }

        private static class CachedName {
            final long timestamp;
            final String name;

            public CachedName(String name, long timestamp) {
                this.name = name;
                this.timestamp = timestamp;
            }
        }

        public static class Stat {
            private int ownerId;
            private int groupId;
            private String owner;
            private String group;
            private int mode;
            public static int S_IFMT = -1;
            public static int S_IFIFO = -1;
            public static int S_IFCHR = -1;
            public static int S_IFDIR = -1;
            public static int S_IFBLK = -1;
            public static int S_IFREG = -1;
            public static int S_IFLNK = -1;
            public static int S_IFSOCK = -1;
            public static int S_ISUID = -1;
            public static int S_ISGID = -1;
            public static int S_ISVTX = -1;
            public static int S_IRUSR = -1;
            public static int S_IWUSR = -1;
            public static int S_IXUSR = -1;

            Stat(int ownerId, int groupId, int mode) {
                this.ownerId = ownerId;
                this.groupId = groupId;
                this.mode = mode;
            }

            Stat(String owner, String group, int mode) {
                this.owner = !PlatformUtils.WINDOWS ? owner : NativeIO.stripDomain(owner);
                this.group = !PlatformUtils.WINDOWS ? group : NativeIO.stripDomain(group);
                this.mode = mode;
            }

            public String toString() {
                return "Stat(owner='" + this.owner + "', group='" + this.group + "', mode=" + this.mode + ")";
            }

            public String getOwner() {
                return this.owner;
            }

            public String getGroup() {
                return this.group;
            }

            public int getMode() {
                return this.mode;
            }
        }

        public static class NoMlockCacheManipulator
        extends CacheManipulator {
            @Override
            public void mlock(String identifier, ByteBuffer buffer, long len) throws IOException {
                LOG.info("mlocking " + identifier);
            }

            @Override
            public long getMemlockLimit() {
                return 0x4000000000000L;
            }

            public long getOperatingSystemPageSize() {
                return 4096L;
            }

            @Override
            public boolean verifyCanMlock() {
                return true;
            }
        }

        public static class CacheManipulator {
            public void mlock(String identifier, ByteBuffer buffer, long len) throws IOException {
                POSIX.mlock(buffer, len);
            }

            public long getMemlockLimit() {
                return NativeIO.getMemlockLimit();
            }

            public void posixFadviseIfPossible(String identifier, FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
                POSIX.posixFadviseIfPossible(identifier, fd, offset, len, flags);
            }

            public boolean verifyCanMlock() {
                return NativeIO.isAvailable();
            }
        }
    }
}

