/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface JavaUtils {
    public static final Logger LOG = LoggerFactory.getLogger(JavaUtils.class);
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
    public static final CompletableFuture[] EMPTY_COMPLETABLE_FUTURE_ARRAY = new CompletableFuture[0];
    public static final Supplier<ThreadGroup> ROOT_THREAD_GROUP = JavaUtils.memoize(() -> {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        ThreadGroup p;
        while ((p = g.getParent()) != null) {
            g = p;
        }
        return g;
    });

    public static String date() {
        return DATE_FORMAT.format(new Date());
    }

    public static <T> T cast(Object obj, Class<T> clazz) {
        return clazz.isInstance(obj) ? (T)clazz.cast(obj) : null;
    }

    public static <T> T cast(Object obj) {
        Object t = obj;
        return (T)t;
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return trace[3];
    }

    public static StackTraceElement getCurrentStackTraceElement() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return trace[2];
    }

    public static <T extends Throwable> void runAsUnchecked(CheckedRunnable<T> runnable) {
        JavaUtils.runAsUnchecked(runnable, RuntimeException::new);
    }

    public static <THROWABLE extends Throwable> void runAsUnchecked(CheckedRunnable<THROWABLE> runnable, Function<THROWABLE, ? extends RuntimeException> converter) {
        try {
            runnable.run();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw converter.apply(JavaUtils.cast(t));
        }
    }

    public static <T> T callAsUnchecked(Callable<T> callable) {
        return (T)JavaUtils.callAsUnchecked(callable::call, RuntimeException::new);
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT callAsUnchecked(CheckedSupplier<OUTPUT, THROWABLE> checkedSupplier, Function<THROWABLE, ? extends RuntimeException> converter) {
        try {
            return checkedSupplier.get();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw converter.apply(JavaUtils.cast(t));
        }
    }

    public static <T> MemoizedSupplier<T> memoize(Supplier<T> initializer) {
        return MemoizedSupplier.valueOf(initializer);
    }

    public static ThreadGroup getRootThreadGroup() {
        return ROOT_THREAD_GROUP.get();
    }

    public static <RETURN, THROWABLE extends Throwable> RETURN attemptRepeatedly(CheckedSupplier<RETURN, THROWABLE> supplier, int numAttempts, TimeDuration sleepTime, String name, Logger log) throws THROWABLE, InterruptedException {
        return JavaUtils.attempt(supplier, numAttempts, sleepTime, () -> name, log);
    }

    public static <RETURN, THROWABLE extends Throwable> RETURN attempt(CheckedSupplier<RETURN, THROWABLE> supplier, int numAttempts, TimeDuration sleepTime, Supplier<?> name, Logger log) throws THROWABLE, InterruptedException {
        Objects.requireNonNull(supplier, "supplier == null");
        Preconditions.assertTrue(numAttempts > 0, () -> "numAttempts = " + numAttempts + " <= 0");
        Preconditions.assertTrue(!sleepTime.isNegative(), () -> "sleepTime = " + sleepTime + " < 0");
        for (int i = 1; i <= numAttempts; ++i) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                if (i == numAttempts) {
                    throw t;
                }
                if (log != null && log.isWarnEnabled()) {
                    log.warn("FAILED \"" + name.get() + "\", attempt #" + i + "/" + numAttempts + ": " + t + ", sleep " + sleepTime + " and then retry.", t);
                }
                sleepTime.sleep();
                continue;
            }
        }
        throw new IllegalStateException("BUG: this line should be unreachable.");
    }

    public static <THROWABLE extends Throwable> void attempt(CheckedRunnable<THROWABLE> runnable, int numAttempts, TimeDuration sleepTime, String name, Logger log) throws THROWABLE, InterruptedException {
        JavaUtils.attemptRepeatedly(CheckedRunnable.asCheckedSupplier(runnable), numAttempts, sleepTime, name, log);
    }

    public static void attemptUntilTrue(BooleanSupplier condition, int numAttempts, TimeDuration sleepTime, String name, Logger log) throws InterruptedException {
        Objects.requireNonNull(condition, "condition == null");
        JavaUtils.attempt(() -> {
            if (!condition.getAsBoolean()) {
                throw new IllegalStateException("Condition " + name + " is false.");
            }
        }, numAttempts, sleepTime, name, log);
    }

    public static Timer runRepeatedly(final Runnable runnable, long delay, long period, TimeUnit unit) {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                runnable.run();
            }
        }, unit.toMillis(delay), unit.toMillis(period));
        return timer;
    }

    public static void dumpAllThreads(Consumer<String> println) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : threadMxBean.dumpAllThreads(true, true)) {
            println.accept(ti.toString());
        }
    }

    public static <E> CompletableFuture<E> completeExceptionally(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static Throwable unwrapCompletionException(Throwable t) {
        Objects.requireNonNull(t, "t == null");
        return t instanceof CompletionException && t.getCause() != null ? t.getCause() : t;
    }

    public static <T> CompletableFuture<Void> allOf(Collection<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(EMPTY_COMPLETABLE_FUTURE_ARRAY));
    }

    public static <OUTPUT, THROWABLE extends Throwable> OUTPUT supplyAndWrapAsCompletionException(CheckedSupplier<OUTPUT, THROWABLE> supplier) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CompletionException(t);
        }
    }

    public static boolean sleep(long sleepMs, long thresholdMs) throws InterruptedException {
        Timestamp t = Timestamp.currentTime();
        Thread.sleep(sleepMs);
        long elapsedMs = t.elapsedTimeMs();
        if (elapsedMs - sleepMs > thresholdMs) {
            LOG.warn("Unexpected long sleep: sleep({}ms) actually took {}ms which is over the threshold {}ms", new Object[]{sleepMs, elapsedMs, thresholdMs});
            return false;
        }
        return true;
    }
}

