/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.nio.ByteBuffer;
import org.apache.ratis.protocol.ChecksumException;
import org.apache.ratis.util.NativeCodeLoader;

final class NativeCrc32 {
    public static final int CHECKSUM_CRC32 = 1;
    public static final int CHECKSUM_CRC32C = 2;

    private NativeCrc32() {
    }

    public static boolean isAvailable() {
        if (System.getProperty("os.arch").toLowerCase().startsWith("sparc")) {
            return false;
        }
        return NativeCodeLoader.isNativeCodeLoaded();
    }

    public static void verifyChunkedSums(int bytesPerSum, int checksumType, ByteBuffer sums, ByteBuffer data, String fileName, long basePos) throws ChecksumException {
        NativeCrc32.nativeComputeChunkedSums(bytesPerSum, checksumType, sums, sums.position(), data, data.position(), data.remaining(), fileName, basePos, true);
    }

    public static void verifyChunkedSumsByteArray(int bytesPerSum, int checksumType, byte[] sums, int sumsOffset, byte[] data, int dataOffset, int dataLength, String fileName, long basePos) throws ChecksumException {
        NativeCrc32.nativeComputeChunkedSumsByteArray(bytesPerSum, checksumType, sums, sumsOffset, data, dataOffset, dataLength, fileName, basePos, true);
    }

    public static void calculateChunkedSums(int bytesPerSum, int checksumType, ByteBuffer sums, ByteBuffer data) {
        NativeCrc32.nativeComputeChunkedSums(bytesPerSum, checksumType, sums, sums.position(), data, data.position(), data.remaining(), "", 0L, false);
    }

    public static void calculateChunkedSumsByteArray(int bytesPerSum, int checksumType, byte[] sums, int sumsOffset, byte[] data, int dataOffset, int dataLength) {
        NativeCrc32.nativeComputeChunkedSumsByteArray(bytesPerSum, checksumType, sums, sumsOffset, data, dataOffset, dataLength, "", 0L, false);
    }

    private static native void nativeComputeChunkedSums(int var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, String var7, long var8, boolean var10);

    private static native void nativeComputeChunkedSumsByteArray(int var0, int var1, byte[] var2, int var3, byte[] var4, int var5, int var6, String var7, long var8, boolean var10);
}

