/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import org.apache.ratis.io.StandardWriteOption;
import org.apache.ratis.io.WriteOption;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamPacketHeader;
import org.apache.ratis.protocol.DataStreamRequest;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataStreamRequestHeader
extends DataStreamPacketHeader
implements DataStreamRequest {
    private static final Logger LOG = LoggerFactory.getLogger(DataStreamRequestHeader.class);
    private final WriteOption[] options;

    public static DataStreamRequestHeader read(ByteBuf buf) {
        if (DataStreamRequestHeader.getSizeOfHeaderBodyLen() > buf.readableBytes()) {
            return null;
        }
        long headerBodyBufLen = buf.readLong();
        if (headerBodyBufLen > (long)buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        int headerBufLen = buf.readInt();
        if (headerBufLen > buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        try {
            ByteBuf headerBuf = buf.slice(buf.readerIndex(), headerBufLen);
            RaftProtos.DataStreamRequestHeaderProto header = RaftProtos.DataStreamRequestHeaderProto.parseFrom((ByteBuffer)headerBuf.nioBuffer());
            RaftProtos.DataStreamPacketHeaderProto h = header.getPacketHeader();
            if (h.getDataLength() + (long)headerBufLen <= (long)buf.readableBytes()) {
                buf.readerIndex(buf.readerIndex() + headerBufLen);
                WriteOption[] options = new WriteOption[h.getOptionsCount()];
                for (int i = 0; i < options.length; ++i) {
                    options[i] = StandardWriteOption.values()[h.getOptions(i).ordinal()];
                }
                return new DataStreamRequestHeader(ClientId.valueOf((ByteString)h.getClientId()), h.getType(), h.getStreamId(), h.getStreamOffset(), h.getDataLength(), options);
            }
            buf.resetReaderIndex();
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode request header:", (Throwable)e);
            buf.resetReaderIndex();
            return null;
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DataStreamRequestHeader(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, long dataLength, WriteOption ... options) {
        super(clientId, type, streamId, streamOffset, dataLength);
        this.options = options;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public WriteOption[] getWriteOptions() {
        return this.options;
    }
}

