/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.util.ProtoUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftClientRequest
extends RaftClientMessage {
    private static final Type DATA_STREAM_DEFAULT = new Type(RaftProtos.DataStreamRequestTypeProto.getDefaultInstance(), null);
    private static final Type FORWARD_DEFAULT = new Type(RaftProtos.ForwardRequestTypeProto.getDefaultInstance(), null);
    private static final Type WRITE_DEFAULT = new Type(RaftProtos.WriteRequestTypeProto.getDefaultInstance(), null);
    private static final Type WATCH_DEFAULT = new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(0L).setReplication(RaftProtos.ReplicationLevel.MAJORITY).build(), null);
    private static final Type READ_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.getDefaultInstance(), null);
    private static final Type STALE_READ_DEFAULT = new Type(RaftProtos.StaleReadRequestTypeProto.getDefaultInstance(), null);
    private final Message message;
    private final Type type;
    private final RaftProtos.SlidingWindowEntry slidingWindowEntry;
    private final RoutingTable routingTable;
    private final long timeoutMs;

    public static Type writeRequestType() {
        return WRITE_DEFAULT;
    }

    public static Type dataStreamRequestType() {
        return DATA_STREAM_DEFAULT;
    }

    public static Type forwardRequestType() {
        return FORWARD_DEFAULT;
    }

    public static Type messageStreamRequestType(long streamId, long messageId, boolean endOfRequest) {
        return new Type(RaftProtos.MessageStreamRequestTypeProto.newBuilder().setStreamId(streamId).setMessageId(messageId).setEndOfRequest(endOfRequest).build(), null);
    }

    public static Type readRequestType() {
        return READ_DEFAULT;
    }

    public static Type staleReadRequestType(long minIndex) {
        return minIndex == 0L ? STALE_READ_DEFAULT : new Type(RaftProtos.StaleReadRequestTypeProto.newBuilder().setMinIndex(minIndex).build(), null);
    }

    public static Type watchRequestType() {
        return WATCH_DEFAULT;
    }

    public static Type watchRequestType(long index, RaftProtos.ReplicationLevel replication) {
        return new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(index).setReplication(replication).build(), null);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RaftClientRequest toWriteRequest(RaftClientRequest r, Message message) {
        return RaftClientRequest.newBuilder().setClientId(r.getClientId()).setServerId(r.getServerId()).setGroupId(r.getRaftGroupId()).setCallId(r.getCallId()).setMessage(message).setType(RaftClientRequest.writeRequestType()).setSlidingWindowEntry(r.getSlidingWindowEntry()).build();
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type) {
        this(clientId, serverId, groupId, callId, null, type, null, null, 0L);
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type, long timeoutMs) {
        this(clientId, serverId, groupId, callId, null, type, null, null, timeoutMs);
    }

    private RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Message message, Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry, RoutingTable routingTable, long timeoutMs) {
        super(clientId, serverId, groupId, callId);
        this.message = message;
        this.type = type;
        this.slidingWindowEntry = slidingWindowEntry != null ? slidingWindowEntry : RaftProtos.SlidingWindowEntry.getDefaultInstance();
        this.routingTable = routingTable;
        this.timeoutMs = timeoutMs;
    }

    public final boolean isRequest() {
        return true;
    }

    public RaftProtos.SlidingWindowEntry getSlidingWindowEntry() {
        return this.slidingWindowEntry;
    }

    public Message getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public boolean is(RaftProtos.RaftClientRequestProto.TypeCase typeCase) {
        return this.getType().is(typeCase);
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public String toString() {
        return super.toString() + ", seq=" + ProtoUtils.toString((RaftProtos.SlidingWindowEntry)this.slidingWindowEntry) + ", " + this.type + ", " + this.getMessage();
    }

    static /* synthetic */ Type access$700() {
        return WRITE_DEFAULT;
    }

    static /* synthetic */ Type access$800() {
        return DATA_STREAM_DEFAULT;
    }

    static /* synthetic */ Type access$900() {
        return FORWARD_DEFAULT;
    }

    static /* synthetic */ Type access$1000() {
        return READ_DEFAULT;
    }

    static /* synthetic */ Type access$1100() {
        return STALE_READ_DEFAULT;
    }
}

