/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RaftId {
    static final UUID ZERO_UUID = new UUID(0L, 0L);
    static final ByteString ZERO_UUID_BYTESTRING = RaftId.toByteString((UUID)ZERO_UUID);
    private static final int BYTE_LENGTH = 16;
    private final UUID uuid;
    private final Supplier<ByteString> uuidBytes;
    private final Supplier<String> uuidString;

    private static void checkLength(int length, String name) {
        Preconditions.assertTrue((length == 16 ? 1 : 0) != 0, (String)"%s = %s != BYTE_LENGTH = %s", (Object[])new Object[]{name, length, 16});
    }

    private static UUID toUuid(ByteString bytes) {
        Objects.requireNonNull(bytes, "bytes == null");
        RaftId.checkLength((int)bytes.size(), (String)"bytes.size()");
        ByteBuffer buf = bytes.asReadOnlyByteBuffer();
        return new UUID(buf.getLong(), buf.getLong());
    }

    private static ByteString toByteString(UUID uuid) {
        Objects.requireNonNull(uuid, "uuid == null");
        ByteBuffer buf = ByteBuffer.wrap(new byte[16]);
        buf.putLong(uuid.getMostSignificantBits());
        buf.putLong(uuid.getLeastSignificantBits());
        return ByteString.copyFrom((byte[])buf.array());
    }

    private RaftId(UUID uuid, Supplier<ByteString> uuidBytes) {
        this.uuid = (UUID)Preconditions.assertNotNull((Object)uuid, (String)"uuid");
        this.uuidBytes = uuidBytes;
        this.uuidString = JavaUtils.memoize(() -> this.createUuidString(uuid));
    }

    RaftId(UUID uuid) {
        this(uuid, (Supplier)JavaUtils.memoize(() -> RaftId.toByteString((UUID)uuid)));
        Preconditions.assertTrue((!uuid.equals(ZERO_UUID) ? 1 : 0) != 0, () -> "Failed to create " + JavaUtils.getClassSimpleName(this.getClass()) + ": UUID " + ZERO_UUID + " is reserved.");
    }

    RaftId(ByteString uuidBytes) {
        this(RaftId.toUuid((ByteString)uuidBytes), () -> uuidBytes);
    }

    String createUuidString(UUID id) {
        String s = id.toString().toUpperCase();
        int i = s.lastIndexOf(45);
        return s.substring(i + 1);
    }

    public ByteString toByteString() {
        return (ByteString)this.uuidBytes.get();
    }

    public String toString() {
        return (String)this.uuidString.get();
    }

    public boolean equals(Object other) {
        return other == this || other instanceof RaftId && this.getClass() == other.getClass() && this.uuid.equals(((RaftId)other).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

