/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.Collections;
import java.util.Map;
import org.apache.ratis.retry.ExceptionDependentRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.Preconditions;

public final class ExceptionDependentRetry
implements RetryPolicy {
    private final RetryPolicy defaultPolicy;
    private final Map<String, RetryPolicy> exceptionNameToPolicyMap;
    private final int maxAttempts;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ExceptionDependentRetry(RetryPolicy defaultPolicy, Map<String, RetryPolicy> policyMap, int maxAttempts) {
        Preconditions.assertTrue((defaultPolicy != null ? 1 : 0) != 0, (Object)"Default Policy should not be null");
        this.defaultPolicy = defaultPolicy;
        this.exceptionNameToPolicyMap = Collections.unmodifiableMap(policyMap);
        this.maxAttempts = maxAttempts;
    }

    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        RetryPolicy policy = null;
        if (event.getCause() != null) {
            policy = (RetryPolicy)this.exceptionNameToPolicyMap.get(event.getCause().getClass().getName());
        }
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        return event.getAttemptCount() < this.maxAttempts ? policy.handleAttemptFailure(() -> ((RetryPolicy.Event)event).getCauseCount()) : NO_RETRY_ACTION;
    }
}

