/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ratis.retry.MultipleLinearRandomRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class MultipleLinearRandomRetry
implements RetryPolicy {
    static final Logger LOG = LoggerFactory.getLogger(MultipleLinearRandomRetry.class);
    private final List<Pair> pairs;
    private final Supplier<String> myString;

    private MultipleLinearRandomRetry(List<Pair> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            throw new IllegalArgumentException("pairs must be neither null nor empty.");
        }
        this.pairs = Collections.unmodifiableList(pairs);
        this.myString = JavaUtils.memoize(() -> JavaUtils.getClassSimpleName(this.getClass()) + pairs);
    }

    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        Pair p = this.searchPair(event.getAttemptCount());
        return p == null ? NO_RETRY_ACTION : () -> ((Pair)p).getRandomSleepTime();
    }

    private Pair searchPair(int curRetry) {
        int i;
        for (i = 0; i < this.pairs.size() && curRetry > Pair.access$000((Pair)((Pair)this.pairs.get(i))); curRetry -= Pair.access$000((Pair)((Pair)this.pairs.get(i))), ++i) {
        }
        return i == this.pairs.size() ? null : (Pair)this.pairs.get(i);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.toString().equals(that.toString());
    }

    public String toString() {
        return (String)this.myString.get();
    }

    public static MultipleLinearRandomRetry parseCommaSeparated(String input) {
        String[] elements = input.split(",");
        if (elements.length == 0) {
            LOG.warn("Illegal value: there is no element in \"{}\".", (Object)input);
            return null;
        }
        if (elements.length % 2 != 0) {
            LOG.warn("Illegal value: the number of elements in \"{}\" is {} but an even number of elements is expected.", (Object)input, (Object)elements.length);
            return null;
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        int i = 0;
        while (i < elements.length) {
            Integer retries;
            TimeDuration sleep;
            if ((sleep = (TimeDuration)MultipleLinearRandomRetry.parseElement((String[])elements, (int)i++, (String)input, MultipleLinearRandomRetry::parsePositiveTime)) == null) {
                return null;
            }
            if ((retries = (Integer)MultipleLinearRandomRetry.parseElement((String[])elements, (int)i++, (String)input, MultipleLinearRandomRetry::parsePositiveInt)) == null) {
                return null;
            }
            pairs.add(new Pair(retries.intValue(), sleep));
        }
        return new MultipleLinearRandomRetry(pairs);
    }

    private static TimeDuration parsePositiveTime(String s) {
        TimeDuration t = TimeDuration.valueOf((String)s, (TimeUnit)TimeUnit.MILLISECONDS);
        if (t.isNonPositive()) {
            throw new IllegalArgumentException("Non-positive value: " + t);
        }
        return t;
    }

    private static int parsePositiveInt(String trimmed) {
        int n = Integer.parseInt(trimmed);
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive value: " + n);
        }
        return n;
    }

    private static <E> E parseElement(String[] elements, int i, String input, Function<String, E> parser) {
        String s = elements[i].trim().replace("_", "");
        try {
            return parser.apply(s);
        }
        catch (Exception t) {
            LOG.warn("Failed to parse \"{}\", which is the index {} element in \"{}\"", new Object[]{s, i, input, t});
            return null;
        }
    }
}

