/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.TimeoutIOException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public interface IOUtils {
    public static InterruptedIOException toInterruptedIOException(String message, InterruptedException e) {
        InterruptedIOException iioe = new InterruptedIOException(message);
        iioe.initCause(e);
        return iioe;
    }

    public static IOException asIOException(Throwable t) {
        return t == null ? null : (t instanceof IOException ? (IOException)t : new IOException(t));
    }

    public static IOException toIOException(ExecutionException e) {
        Throwable cause = e.getCause();
        return cause != null ? IOUtils.asIOException((Throwable)cause) : new IOException(e);
    }

    public static <T> T getFromFuture(CompletableFuture<T> future, Supplier<Object> name) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)(name.get() + " interrupted."), (InterruptedException)e);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException((ExecutionException)e);
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException((Throwable)JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    public static <T> T getFromFuture(CompletableFuture<T> future, Supplier<Object> name, TimeDuration timeout) throws IOException {
        try {
            return future.get(timeout.getDuration(), timeout.getUnit());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)(name.get() + " interrupted."), (InterruptedException)e);
        }
        catch (ExecutionException e) {
            throw IOUtils.toIOException((ExecutionException)e);
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException((Throwable)JavaUtils.unwrapCompletionException((Throwable)e));
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException("Timeout " + timeout + ": " + name.get(), (Throwable)e);
        }
    }

    public static boolean shouldReconnect(Throwable e) {
        return ReflectionUtils.isInstance((Object)e, (Class[])new Class[]{SocketException.class, SocketTimeoutException.class, ClosedChannelException.class, EOFException.class, AlreadyClosedException.class});
    }

    public static void readFully(InputStream in, int buffSize) throws IOException {
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            bytesRead = in.read(buf);
        }
    }

    public static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                int read = len - toRead;
                throw new EOFException("Premature EOF: read length is " + len + " but encountered EOF at " + read);
            }
            toRead -= ret;
            off += ret;
        }
    }

    public static void writeFully(FileChannel fc, ByteBuffer buf, long offset) throws IOException {
        do {
            offset += (long)fc.write(buf, offset);
        } while (buf.remaining() > 0);
    }

    public static long preallocate(FileChannel fc, long size, ByteBuffer fill) throws IOException {
        long allocated;
        int n;
        Preconditions.assertSame((long)0L, (long)fill.position(), (String)"fill.position");
        Preconditions.assertSame((long)fill.capacity(), (long)fill.limit(), (String)"fill.limit");
        int remaining = fill.remaining();
        for (allocated = 0L; allocated < size; allocated += (long)n) {
            long required = size - allocated;
            n = (long)remaining < required ? remaining : Math.toIntExact(required);
            ByteBuffer buffer = fill.slice();
            buffer.limit(n);
            IOUtils.writeFully((FileChannel)fc, (ByteBuffer)buffer, (long)fc.size());
        }
        return allocated;
    }

    public static void skipFully(InputStream in, long len) throws IOException {
        long ret;
        for (long amt = len; amt > 0L; amt -= ret) {
            ret = in.skip(amt);
            if (ret != 0L) continue;
            int b = in.read();
            if (b == -1) {
                throw new EOFException("Premature EOF from inputStream after skipping " + (len - amt) + " byte(s).");
            }
            ret = 1L;
        }
    }

    public static void cleanup(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception e) {
                if (log == null || !log.isDebugEnabled()) continue;
                log.debug("Exception in closing " + c, (Throwable)e);
            }
        }
    }

    public static byte[] object2Bytes(Object obj) {
        return ProtoUtils.writeObject2ByteString((Object)obj).toByteArray();
    }

    public static <T> T bytes2Object(byte[] bytes, Class<T> clazz) {
        return (T)IOUtils.readObject((InputStream)new ByteArrayInputStream(bytes), clazz);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObject(InputStream in, Class<T> clazz) {
        try {
            Throwable throwable = null;
            try (ObjectInputStream oin = new ObjectInputStream(in);){
                T t;
                Object obj = oin.readObject();
                try {
                    t = clazz.cast(obj);
                }
                catch (ClassCastException e) {
                    try {
                        throw new IllegalStateException("Failed to cast to " + clazz + ", object=" + (obj instanceof Throwable ? StringUtils.stringifyException((Throwable)((Throwable)obj)) : obj), e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return t;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Failed to read an object.", e);
        }
    }
}

