/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.PeerProxyMap;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerProxyMap<PROXY extends Closeable>
implements RaftPeer.Add,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(PeerProxyMap.class);
    private final String name;
    private final Map<RaftPeerId, PeerAndProxy> peers = new ConcurrentHashMap();
    private final Object resetLock = new Object();
    private final CheckedFunction<RaftPeer, PROXY, IOException> createProxy;

    public PeerProxyMap(String name, CheckedFunction<RaftPeer, PROXY, IOException> createProxy) {
        this.name = name;
        this.createProxy = createProxy;
    }

    public PeerProxyMap(String name) {
        this.name = name;
        this.createProxy = arg_0 -> this.createProxyImpl(arg_0);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PROXY getProxy(RaftPeerId id) throws IOException {
        Objects.requireNonNull(id, "id == null");
        PeerAndProxy p = (PeerAndProxy)this.peers.get(id);
        if (p == null) {
            Object object = this.resetLock;
            synchronized (object) {
                p = (PeerAndProxy)Objects.requireNonNull(this.peers.get(id), () -> this.name + ": Server " + id + " not found: peers=" + this.peers.keySet());
            }
        }
        return (PROXY)p.getProxy();
    }

    public void addRaftPeers(Collection<RaftPeer> newPeers) {
        for (RaftPeer p : newPeers) {
            this.computeIfAbsent(p);
        }
    }

    public void computeIfAbsent(RaftPeer p) {
        this.peers.computeIfAbsent(p.getId(), k -> new PeerAndProxy(this, p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProxy(RaftPeerId id) {
        PeerAndProxy pp;
        LOG.debug("{}: reset proxy for {}", (Object)this.name, (Object)id);
        Optional optional = Optional.empty();
        Object object = this.resetLock;
        synchronized (object) {
            pp = (PeerAndProxy)this.peers.remove(id);
            if (pp != null) {
                RaftPeer peer = pp.getPeer();
                optional = pp.setNullProxyAndClose();
                this.computeIfAbsent(peer);
            }
        }
        optional.ifPresent(proxy -> this.closeProxy(proxy, pp));
    }

    public boolean handleException(RaftPeerId serverId, Throwable e, boolean reconnect) {
        if (reconnect || IOUtils.shouldReconnect((Throwable)e)) {
            this.resetProxy(serverId);
            return true;
        }
        return false;
    }

    public PROXY createProxyImpl(RaftPeer peer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.peers.values().parallelStream().forEach(pp -> pp.setNullProxyAndClose().ifPresent(proxy -> this.closeProxy(proxy, pp)));
    }

    private void closeProxy(PROXY proxy, PeerAndProxy pp) {
        try {
            LOG.debug("{}: Closing proxy for peer {}", (Object)this.name, (Object)pp);
            proxy.close();
        }
        catch (IOException e) {
            LOG.warn("{}: Failed to close proxy for peer {}, proxy class: {}", new Object[]{this.name, pp, proxy.getClass(), e});
        }
    }

    static /* synthetic */ String access$000(PeerProxyMap x0) {
        return x0.name;
    }

    static /* synthetic */ CheckedFunction access$100(PeerProxyMap x0) {
        return x0.createProxy;
    }
}

