/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.ServiceException;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ReflectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public interface ProtoUtils {
    public static ByteString writeObject2ByteString(Object obj) {
        ByteString.Output byteOut = ByteString.newOutput();
        try (ObjectOutputStream objOut = new ObjectOutputStream((OutputStream)byteOut);){
            objOut.writeObject(obj);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException when writing an object to a ByteString.", e);
        }
        return byteOut.toByteString();
    }

    public static Object toObject(ByteString bytes) {
        return IOUtils.readObject((InputStream)bytes.newInput(), Object.class);
    }

    public static RaftProtos.ThrowableProto toThrowableProto(Throwable t) {
        RaftProtos.ThrowableProto.Builder builder = RaftProtos.ThrowableProto.newBuilder().setClassName(t.getClass().getName()).setErrorMessage(t.getMessage()).setStackTrace(ProtoUtils.writeObject2ByteString((Object)t.getStackTrace()));
        Optional.ofNullable(t.getCause()).map(ProtoUtils::writeObject2ByteString).ifPresent(arg_0 -> ((RaftProtos.ThrowableProto.Builder)builder).setCause(arg_0));
        return builder.build();
    }

    public static <T extends Throwable> T toThrowable(RaftProtos.ThrowableProto proto, Class<T> clazz) {
        Throwable throwable;
        Preconditions.assertTrue((boolean)clazz.getName().equals(proto.getClassName()), () -> "Unexpected class " + proto.getClassName() + ", expecting " + clazz + ", proto=" + proto);
        try {
            throwable = ReflectionUtils.instantiateException(clazz, (String)proto.getErrorMessage());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create a new object from " + clazz + ", proto=" + proto, e);
        }
        Optional.ofNullable(proto.getStackTrace()).filter(b -> !b.isEmpty()).map(ProtoUtils::toObject).map(obj -> (StackTraceElement[])JavaUtils.cast((Object)obj, StackTraceElement[].class)).ifPresent(throwable::setStackTrace);
        Optional.ofNullable(proto.getCause()).filter(b -> !b.isEmpty()).map(ProtoUtils::toObject).map(obj -> (Throwable)JavaUtils.cast((Object)obj, Throwable.class)).ifPresent(throwable::initCause);
        return (T)throwable;
    }

    public static ByteString toByteString(String string) {
        return ByteString.copyFromUtf8((String)string);
    }

    public static ByteString toByteString(byte[] bytes) {
        return ProtoUtils.toByteString((byte[])bytes, (int)0, (int)bytes.length);
    }

    public static ByteString toByteString(byte[] bytes, int offset, int size) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes, (int)offset, (int)size);
    }

    public static RaftPeer toRaftPeer(RaftProtos.RaftPeerProto p) {
        return RaftPeer.newBuilder().setId(RaftPeerId.valueOf((ByteString)p.getId())).setAddress(p.getAddress()).setDataStreamAddress(p.getDataStreamAddress()).setClientAddress(p.getClientAddress()).setAdminAddress(p.getAdminAddress()).setPriority(p.getPriority()).build();
    }

    public static List<RaftPeer> toRaftPeers(List<RaftProtos.RaftPeerProto> protos) {
        return protos.stream().map(ProtoUtils::toRaftPeer).collect(Collectors.toList());
    }

    public static RaftPeerId toRaftPeerId(RaftProtos.RaftPeerIdProto p) {
        return RaftPeerId.valueOf((ByteString)p.getId());
    }

    public static List<RaftPeerId> toRaftPeerIds(List<RaftProtos.RaftPeerIdProto> protos) {
        return protos.stream().map(ProtoUtils::toRaftPeerId).collect(Collectors.toList());
    }

    public static Iterable<RaftProtos.RaftPeerProto> toRaftPeerProtos(Collection<RaftPeer> peers) {
        return () -> new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Iterable<RaftProtos.RaftPeerIdProto> toRaftPeerIdProtos(Collection<RaftPeerId> peers) {
        return () -> new /* Unavailable Anonymous Inner Class!! */;
    }

    public static Iterable<RaftProtos.RouteProto> toRouteProtos(Map<RaftPeerId, Set<RaftPeerId>> routingTable) {
        return () -> new /* Unavailable Anonymous Inner Class!! */;
    }

    public static RaftGroupId toRaftGroupId(RaftProtos.RaftGroupIdProto proto) {
        return RaftGroupId.valueOf((ByteString)proto.getId());
    }

    public static RaftProtos.RaftGroupIdProto.Builder toRaftGroupIdProtoBuilder(RaftGroupId id) {
        return RaftProtos.RaftGroupIdProto.newBuilder().setId(id.toByteString());
    }

    public static RaftGroup toRaftGroup(RaftProtos.RaftGroupProto proto) {
        return RaftGroup.valueOf((RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)proto.getGroupId()), (Collection)ProtoUtils.toRaftPeers((List)proto.getPeersList()));
    }

    public static RaftProtos.RaftGroupProto.Builder toRaftGroupProtoBuilder(RaftGroup group) {
        return RaftProtos.RaftGroupProto.newBuilder().setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)group.getGroupId())).addAllPeers(ProtoUtils.toRaftPeerProtos((Collection)group.getPeers()));
    }

    public static RaftGroupMemberId toRaftGroupMemberId(ByteString peerId, RaftProtos.RaftGroupIdProto groupId) {
        return RaftGroupMemberId.valueOf((RaftPeerId)RaftPeerId.valueOf((ByteString)peerId), (RaftGroupId)ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)groupId));
    }

    public static RaftGroupMemberId toRaftGroupMemberId(RaftProtos.RaftGroupMemberIdProto memberId) {
        return ProtoUtils.toRaftGroupMemberId((ByteString)memberId.getPeerId(), (RaftProtos.RaftGroupIdProto)memberId.getGroupId());
    }

    public static RaftProtos.RaftGroupMemberIdProto.Builder toRaftGroupMemberIdProtoBuilder(RaftGroupMemberId memberId) {
        return RaftProtos.RaftGroupMemberIdProto.newBuilder().setPeerId(memberId.getPeerId().toByteString()).setGroupId(ProtoUtils.toRaftGroupIdProtoBuilder((RaftGroupId)memberId.getGroupId()));
    }

    public static RaftProtos.CommitInfoProto toCommitInfoProto(RaftPeer peer, long commitIndex) {
        return RaftProtos.CommitInfoProto.newBuilder().setServer(peer.getRaftPeerProto()).setCommitIndex(commitIndex).build();
    }

    public static void addCommitInfos(Collection<RaftProtos.CommitInfoProto> commitInfos, Consumer<RaftProtos.CommitInfoProto> accumulator) {
        if (commitInfos != null && !commitInfos.isEmpty()) {
            commitInfos.forEach(accumulator);
        }
    }

    public static String toString(RaftProtos.CommitInfoProto proto) {
        return RaftPeerId.valueOf((ByteString)proto.getServer().getId()) + ":c" + proto.getCommitIndex();
    }

    public static String toString(Collection<RaftProtos.CommitInfoProto> protos) {
        return protos.stream().map(ProtoUtils::toString).collect(Collectors.toList()).toString();
    }

    public static RaftProtos.SlidingWindowEntry toSlidingWindowEntry(long seqNum, boolean isFirst) {
        return RaftProtos.SlidingWindowEntry.newBuilder().setSeqNum(seqNum).setIsFirst(isFirst).build();
    }

    public static String toString(RaftProtos.SlidingWindowEntry proto) {
        return proto.getSeqNum() + (proto.getIsFirst() ? "*" : "");
    }

    public static IOException toIOException(ServiceException se) {
        Throwable t = se.getCause();
        if (t == null) {
            return new IOException((Throwable)se);
        }
        return t instanceof IOException ? (IOException)t : new IOException((Throwable)se);
    }

    public static String toString(RaftProtos.RaftRpcRequestProto proto) {
        return proto.getRequestorId().toStringUtf8() + "->" + proto.getReplyId().toStringUtf8() + "#" + proto.getCallId();
    }

    public static String toString(RaftProtos.RaftRpcReplyProto proto) {
        return proto.getRequestorId().toStringUtf8() + "<-" + proto.getReplyId().toStringUtf8() + "#" + proto.getCallId() + ":" + (proto.getSuccess() ? "OK" : "FAIL");
    }
}

