/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ratis.util.Preconditions;

public class ResourceSemaphore
extends Semaphore {
    private final int limit;
    private final AtomicBoolean reducePermits = new AtomicBoolean();
    private final AtomicBoolean isClosed = new AtomicBoolean();

    public ResourceSemaphore(int limit) {
        super(limit, true);
        Preconditions.assertTrue((limit > 0 ? 1 : 0) != 0, () -> "limit = " + limit + " <= 0");
        this.limit = limit;
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.assertRelease(permits);
        super.release(permits);
        this.assertAvailable();
    }

    private void assertRelease(int toRelease) {
        Preconditions.assertTrue((toRelease >= 0 ? 1 : 0) != 0, () -> "toRelease = " + toRelease + " < 0");
        int available = this.assertAvailable();
        int permits = Math.addExact(available, toRelease);
        Preconditions.assertTrue((permits <= this.limit ? 1 : 0) != 0, () -> "permits = " + permits + " > limit = " + this.limit);
    }

    private int assertAvailable() {
        int available = this.availablePermits();
        Preconditions.assertTrue((available >= 0 ? 1 : 0) != 0, () -> "available = " + available + " < 0");
        return available;
    }

    public int used() {
        return this.limit - this.availablePermits();
    }

    public void close() {
        if (this.reducePermits.compareAndSet(false, true)) {
            this.reducePermits(this.limit);
            this.isClosed.set(true);
        }
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public String toString() {
        return (this.isClosed() ? "closed/" : this.availablePermits() + "/") + this.limit;
    }
}

