/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public class RaftClientRequest
extends RaftClientMessage {
    private static final Type DATA_STREAM_DEFAULT = new Type(RaftProtos.DataStreamRequestTypeProto.getDefaultInstance());
    private static final Type FORWARD_DEFAULT = new Type(RaftProtos.ForwardRequestTypeProto.getDefaultInstance());
    private static final Type WRITE_DEFAULT = new Type(RaftProtos.WriteRequestTypeProto.getDefaultInstance());
    private static final Type WATCH_DEFAULT = new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(0L).setReplication(RaftProtos.ReplicationLevel.MAJORITY).build());
    private static final Type READ_DEFAULT = new Type(RaftProtos.ReadRequestTypeProto.getDefaultInstance());
    private static final Type STALE_READ_DEFAULT = new Type(RaftProtos.StaleReadRequestTypeProto.getDefaultInstance());
    private final Message message;
    private final Type type;
    private final RaftProtos.SlidingWindowEntry slidingWindowEntry;
    private final RoutingTable routingTable;
    private final long timeoutMs;

    public static Type writeRequestType() {
        return WRITE_DEFAULT;
    }

    public static Type dataStreamRequestType() {
        return DATA_STREAM_DEFAULT;
    }

    public static Type forwardRequestType() {
        return FORWARD_DEFAULT;
    }

    public static Type messageStreamRequestType(long streamId, long messageId, boolean endOfRequest) {
        return new Type(RaftProtos.MessageStreamRequestTypeProto.newBuilder().setStreamId(streamId).setMessageId(messageId).setEndOfRequest(endOfRequest).build());
    }

    public static Type readRequestType() {
        return READ_DEFAULT;
    }

    public static Type staleReadRequestType(long minIndex) {
        return minIndex == 0L ? STALE_READ_DEFAULT : new Type(RaftProtos.StaleReadRequestTypeProto.newBuilder().setMinIndex(minIndex).build());
    }

    public static Type watchRequestType() {
        return WATCH_DEFAULT;
    }

    public static Type watchRequestType(long index, RaftProtos.ReplicationLevel replication) {
        return new Type(RaftProtos.WatchRequestTypeProto.newBuilder().setIndex(index).setReplication(replication).build());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RaftClientRequest toWriteRequest(RaftClientRequest r, Message message) {
        return RaftClientRequest.newBuilder().setClientId(r.getClientId()).setServerId(r.getServerId()).setGroupId(r.getRaftGroupId()).setCallId(r.getCallId()).setMessage(message).setType(RaftClientRequest.writeRequestType()).setSlidingWindowEntry(r.getSlidingWindowEntry()).build();
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type) {
        this(clientId, serverId, groupId, callId, null, type, null, null, 0L);
    }

    protected RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Type type, long timeoutMs) {
        this(clientId, serverId, groupId, callId, null, type, null, null, timeoutMs);
    }

    private RaftClientRequest(ClientId clientId, RaftPeerId serverId, RaftGroupId groupId, long callId, Message message, Type type, RaftProtos.SlidingWindowEntry slidingWindowEntry, RoutingTable routingTable, long timeoutMs) {
        super(clientId, serverId, groupId, callId);
        this.message = message;
        this.type = type;
        this.slidingWindowEntry = slidingWindowEntry != null ? slidingWindowEntry : RaftProtos.SlidingWindowEntry.getDefaultInstance();
        this.routingTable = routingTable;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public final boolean isRequest() {
        return true;
    }

    public RaftProtos.SlidingWindowEntry getSlidingWindowEntry() {
        return this.slidingWindowEntry;
    }

    public Message getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public boolean is(RaftProtos.RaftClientRequestProto.TypeCase typeCase) {
        return this.getType().is(typeCase);
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public String toString() {
        return super.toString() + ", seq=" + ProtoUtils.toString(this.slidingWindowEntry) + ", " + this.type + ", " + this.getMessage();
    }

    public static class Builder {
        private ClientId clientId;
        private RaftPeerId serverId;
        private RaftGroupId groupId;
        private long callId;
        private Message message;
        private Type type;
        private RaftProtos.SlidingWindowEntry slidingWindowEntry;
        private RoutingTable routingTable;
        private long timeoutMs;

        public RaftClientRequest build() {
            return new RaftClientRequest(this.clientId, this.serverId, this.groupId, this.callId, this.message, this.type, this.slidingWindowEntry, this.routingTable, this.timeoutMs);
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setServerId(RaftPeerId serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder setGroupId(RaftGroupId groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setCallId(long callId) {
            this.callId = callId;
            return this;
        }

        public Builder setMessage(Message message) {
            this.message = message;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setSlidingWindowEntry(RaftProtos.SlidingWindowEntry slidingWindowEntry) {
            this.slidingWindowEntry = slidingWindowEntry;
            return this;
        }

        public Builder setRoutingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder setTimeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }
    }

    public static final class Type {
        private final RaftProtos.RaftClientRequestProto.TypeCase typeCase;
        private final Object proto;

        public static Type valueOf(RaftProtos.WriteRequestTypeProto write) {
            return WRITE_DEFAULT;
        }

        public static Type valueOf(RaftProtos.DataStreamRequestTypeProto dataStream) {
            return DATA_STREAM_DEFAULT;
        }

        public static Type valueOf(RaftProtos.ForwardRequestTypeProto forward) {
            return FORWARD_DEFAULT;
        }

        public static Type valueOf(RaftProtos.ReadRequestTypeProto read) {
            return READ_DEFAULT;
        }

        public static Type valueOf(RaftProtos.StaleReadRequestTypeProto staleRead) {
            return staleRead.getMinIndex() == 0L ? STALE_READ_DEFAULT : new Type(staleRead);
        }

        public static Type valueOf(RaftProtos.WatchRequestTypeProto watch) {
            return RaftClientRequest.watchRequestType(watch.getIndex(), watch.getReplication());
        }

        public static Type valueOf(RaftProtos.MessageStreamRequestTypeProto messageStream) {
            return RaftClientRequest.messageStreamRequestType(messageStream.getStreamId(), messageStream.getMessageId(), messageStream.getEndOfRequest());
        }

        private Type(RaftProtos.RaftClientRequestProto.TypeCase typeCase, Object proto) {
            this.typeCase = Objects.requireNonNull(typeCase, "typeCase == null");
            this.proto = Objects.requireNonNull(proto, "proto == null");
        }

        private Type(RaftProtos.WriteRequestTypeProto write) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.WRITE, write);
        }

        private Type(RaftProtos.DataStreamRequestTypeProto dataStream) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.DATASTREAM, dataStream);
        }

        private Type(RaftProtos.ForwardRequestTypeProto forward) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD, forward);
        }

        private Type(RaftProtos.MessageStreamRequestTypeProto messageStream) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM, messageStream);
        }

        private Type(RaftProtos.ReadRequestTypeProto read) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.READ, read);
        }

        private Type(RaftProtos.StaleReadRequestTypeProto staleRead) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD, staleRead);
        }

        private Type(RaftProtos.WatchRequestTypeProto watch) {
            this(RaftProtos.RaftClientRequestProto.TypeCase.WATCH, watch);
        }

        public boolean is(RaftProtos.RaftClientRequestProto.TypeCase tCase) {
            return this.getTypeCase().equals((Object)tCase);
        }

        public RaftProtos.RaftClientRequestProto.TypeCase getTypeCase() {
            return this.typeCase;
        }

        public RaftProtos.WriteRequestTypeProto getWrite() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.WRITE));
            return (RaftProtos.WriteRequestTypeProto)this.proto;
        }

        public RaftProtos.DataStreamRequestTypeProto getDataStream() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.DATASTREAM));
            return (RaftProtos.DataStreamRequestTypeProto)this.proto;
        }

        public RaftProtos.ForwardRequestTypeProto getForward() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD));
            return (RaftProtos.ForwardRequestTypeProto)this.proto;
        }

        public RaftProtos.MessageStreamRequestTypeProto getMessageStream() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM), () -> "proto = " + this.proto);
            return (RaftProtos.MessageStreamRequestTypeProto)this.proto;
        }

        public RaftProtos.ReadRequestTypeProto getRead() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.READ));
            return (RaftProtos.ReadRequestTypeProto)this.proto;
        }

        public RaftProtos.StaleReadRequestTypeProto getStaleRead() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD));
            return (RaftProtos.StaleReadRequestTypeProto)this.proto;
        }

        public RaftProtos.WatchRequestTypeProto getWatch() {
            Preconditions.assertTrue(this.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH));
            return (RaftProtos.WatchRequestTypeProto)this.proto;
        }

        public static String toString(RaftProtos.ReplicationLevel replication) {
            return replication == RaftProtos.ReplicationLevel.MAJORITY ? "" : "-" + replication;
        }

        public static String toString(RaftProtos.WatchRequestTypeProto w) {
            return "Watch" + Type.toString(w.getReplication()) + "(" + w.getIndex() + ")";
        }

        public static String toString(RaftProtos.MessageStreamRequestTypeProto s) {
            return "MessageStream" + s.getStreamId() + "-" + s.getMessageId() + (s.getEndOfRequest() ? "-eor" : "");
        }

        public String toString() {
            switch (this.typeCase) {
                case WRITE: {
                    return "RW";
                }
                case DATASTREAM: {
                    return "DataStream";
                }
                case FORWARD: {
                    return "Forward";
                }
                case MESSAGESTREAM: {
                    return Type.toString(this.getMessageStream());
                }
                case READ: {
                    return "RO";
                }
                case STALEREAD: {
                    return "StaleRead(" + this.getStaleRead().getMinIndex() + ")";
                }
                case WATCH: {
                    return Type.toString(this.getWatch());
                }
            }
            throw new IllegalStateException("Unexpected request type: " + this.typeCase);
        }
    }
}

