/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.datastream.impl;

import java.nio.ByteBuffer;
import org.apache.ratis.datastream.impl.DataStreamPacketByteBuffer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamPacket;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.protocol.DataStreamReplyHeader;

public final class DataStreamReplyByteBuffer
extends DataStreamPacketByteBuffer
implements DataStreamReply {
    private final boolean success;
    private final long bytesWritten;

    public static Builder newBuilder() {
        return new Builder();
    }

    private DataStreamReplyByteBuffer(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, ByteBuffer buffer, boolean success, long bytesWritten) {
        super(clientId, type, streamId, streamOffset, buffer);
        this.success = success;
        this.bytesWritten = bytesWritten;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public String toString() {
        return super.toString() + "," + (this.success ? "SUCCESS" : "FAILED") + ",bytesWritten=" + this.bytesWritten;
    }

    public static final class Builder {
        private ClientId clientId;
        private RaftProtos.DataStreamPacketHeaderProto.Type type;
        private long streamId;
        private long streamOffset;
        private ByteBuffer buffer;
        private boolean success;
        private long bytesWritten;

        private Builder() {
        }

        public Builder setClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setType(RaftProtos.DataStreamPacketHeaderProto.Type type) {
            this.type = type;
            return this;
        }

        public Builder setStreamId(long streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder setStreamOffset(long streamOffset) {
            this.streamOffset = streamOffset;
            return this;
        }

        public Builder setBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
            return this;
        }

        public Builder setSuccess(boolean success) {
            this.success = success;
            return this;
        }

        public Builder setBytesWritten(long bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        public Builder setDataStreamReplyHeader(DataStreamReplyHeader header) {
            return this.setDataStreamPacket(header).setSuccess(header.isSuccess()).setBytesWritten(header.getBytesWritten());
        }

        public Builder setDataStreamPacket(DataStreamPacket packet) {
            return this.setClientId(packet.getClientId()).setType(packet.getType()).setStreamId(packet.getStreamId()).setStreamOffset(packet.getStreamOffset());
        }

        public DataStreamReplyByteBuffer build() {
            return new DataStreamReplyByteBuffer(this.clientId, this.type, this.streamId, this.streamOffset, this.buffer, this.success, this.bytesWritten);
        }
    }
}

