/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ReflectionUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftProperties {
    private static final Logger LOG = LoggerFactory.getLogger(RaftProperties.class);
    private final ConcurrentMap<String, String> properties = new ConcurrentHashMap();
    private static final int MAX_SUBST = 20;
    private static final int SUB_START_IDX = 0;
    private static final int SUB_END_IDX = 1;

    public RaftProperties() {
    }

    public RaftProperties(RaftProperties other) {
        this.properties.putAll(other.properties);
    }

    private static int[] findSubVariable(String eval) {
        int[] result = new int[]{-1, -1};
        int matchStart = 1;
        int leftBrace = eval.indexOf(123, matchStart);
        block4: while (leftBrace > 0 && leftBrace + "{c".length() < eval.length()) {
            block8: {
                int matchedLen = 0;
                if (eval.charAt(leftBrace - 1) == '$') {
                    int subStart;
                    int i = subStart = leftBrace + 1;
                    while (i < eval.length()) {
                        switch (eval.charAt(i)) {
                            case '}': {
                                if (matchedLen > 0) {
                                    result[0] = subStart;
                                    result[1] = subStart + matchedLen;
                                    break block4;
                                }
                            }
                            case ' ': 
                            case '$': {
                                matchStart = i + 1;
                                break block8;
                            }
                            default: {
                                ++matchedLen;
                                ++i;
                                break;
                            }
                        }
                    }
                    break;
                }
                matchStart = leftBrace + 1;
            }
            leftBrace = eval.indexOf(123, matchStart);
        }
        return result;
    }

    private String substituteVars(String expr) {
        if (expr == null) {
            return null;
        }
        String eval = expr;
        HashSet<String> evalSet = null;
        for (int s = 0; s < 20; ++s) {
            int[] varBounds = RaftProperties.findSubVariable((String)eval);
            if (varBounds[0] == -1) {
                return eval;
            }
            String var = eval.substring(varBounds[0], varBounds[1]);
            String val = null;
            try {
                if (var.startsWith("env.") && 4 < var.length()) {
                    int i;
                    String v = var.substring(4);
                    for (i = 0; i < v.length(); ++i) {
                        char c = v.charAt(i);
                        if (c == ':' && i < v.length() - 1 && v.charAt(i + 1) == '-') {
                            val = this.getenv(v.substring(0, i));
                            if (val != null && val.length() != 0) break;
                            val = v.substring(i + 2);
                            break;
                        }
                        if (c != '-') continue;
                        val = this.getenv(v.substring(0, i));
                        if (val != null) break;
                        val = v.substring(i + 1);
                        break;
                    }
                    if (i == v.length()) {
                        val = this.getenv(v);
                    }
                } else {
                    val = this.getProperty(var);
                }
            }
            catch (SecurityException se) {
                LOG.warn("Unexpected SecurityException in Configuration", (Throwable)se);
            }
            if (val == null) {
                val = this.getRaw(var);
            }
            if (val == null) {
                return eval;
            }
            int dollar = varBounds[0] - "${".length();
            int afterRightBrace = varBounds[1] + "}".length();
            String refVar = eval.substring(dollar, afterRightBrace);
            if (evalSet == null) {
                evalSet = new HashSet<String>();
            }
            if (!evalSet.add(refVar)) {
                return expr;
            }
            eval = eval.substring(0, dollar) + val + eval.substring(afterRightBrace);
        }
        throw new IllegalStateException("Variable substitution depth too large: 20 " + expr);
    }

    String getenv(String name) {
        return System.getenv(name);
    }

    String getProperty(String key) {
        return System.getProperty(key);
    }

    public String get(String name) {
        return this.substituteVars(this.getRaw(name));
    }

    public String getTrimmed(String name) {
        String value = this.get(name);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public String getRaw(String name) {
        return (String)this.properties.get(Objects.requireNonNull(name, "name == null").trim());
    }

    public void set(String name, String value) {
        String trimmed = Objects.requireNonNull(name, "name == null").trim();
        Objects.requireNonNull(value, () -> "value == null for " + trimmed);
        this.properties.put(trimmed, value);
    }

    public void unset(String name) {
        this.properties.remove(name);
    }

    public synchronized void setIfUnset(String name, String value) {
        if (this.get(name) == null) {
            this.set(name, value);
        }
    }

    public String get(String name, String defaultValue) {
        return this.substituteVars(this.properties.getOrDefault(name, defaultValue));
    }

    public int getInt(String name, int defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Integer.parseInt(hexString, 16);
        }
        return Integer.parseInt(valueString);
    }

    public void setInt(String name, int value) {
        this.set(name, Integer.toString(value));
    }

    public long getLong(String name, long defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        String hexString = this.getHexDigits(valueString);
        if (hexString != null) {
            return Long.parseLong(hexString, 16);
        }
        return Long.parseLong(valueString);
    }

    public File getFile(String name, File defaultValue) {
        String valueString = this.getTrimmed(name);
        return valueString == null ? defaultValue : new File(valueString);
    }

    public List<File> getFiles(String name, List<File> defaultValue) {
        String valueString = this.getRaw(name);
        if (null == valueString) {
            return defaultValue;
        }
        String[] paths = this.getTrimmedStrings(name);
        return Arrays.stream(paths).map(File::new).collect(Collectors.toList());
    }

    public void setFile(String name, File value) {
        try {
            this.set(name, value.getCanonicalPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to get canonical path from file " + value + " for " + name, e);
        }
    }

    public void setFiles(String name, List<File> value) {
        String paths = value.stream().map(File::getAbsolutePath).collect(Collectors.joining(","));
        this.set(name, paths);
    }

    public SizeInBytes getSizeInBytes(String name, SizeInBytes defaultValue) {
        String valueString = this.getTrimmed(name);
        return valueString == null ? defaultValue : SizeInBytes.valueOf((String)valueString);
    }

    private String getHexDigits(String value) {
        boolean negative = false;
        String str = value;
        if (value.startsWith("-")) {
            negative = true;
            str = value.substring(1);
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            String hexString = str.substring(2);
            if (negative) {
                hexString = "-" + hexString;
            }
            return hexString;
        }
        return null;
    }

    public void setLong(String name, long value) {
        this.set(name, Long.toString(value));
    }

    public double getDouble(String name, double defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        return Double.parseDouble(valueString);
    }

    public void setDouble(String name, double value) {
        this.set(name, Double.toString(value));
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String valueString = this.getTrimmed(name);
        return StringUtils.string2boolean((String)valueString, (boolean)defaultValue);
    }

    public void setBoolean(String name, boolean value) {
        this.set(name, Boolean.toString(value));
    }

    public <T extends Enum<T>> void setEnum(String name, T value) {
        this.set(name, value.toString());
    }

    public <T extends Enum<T>> T getEnum(String name, T defaultValue) {
        String val = this.getTrimmed(name);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public void setTimeDuration(String name, TimeDuration value) {
        this.set(name, value.toString());
    }

    public TimeDuration getTimeDuration(String name, TimeDuration defaultValue, TimeUnit defaultUnit) {
        String value = this.getTrimmed(name);
        if (null == value) {
            return defaultValue;
        }
        try {
            return TimeDuration.valueOf((String)value, (TimeUnit)defaultUnit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse " + name + " = " + value, e);
        }
    }

    public BiFunction<String, TimeDuration, TimeDuration> getTimeDuration(TimeUnit defaultUnit) {
        return (key, defaultValue) -> this.getTimeDuration(key, defaultValue, defaultUnit);
    }

    public String[] getTrimmedStrings(String name) {
        String valueString = this.get(name);
        return StringUtils.getTrimmedStrings((String)valueString);
    }

    public Class<?>[] getClasses(String name, Class<?> ... defaultValue) {
        String valueString = this.getRaw(name);
        if (null == valueString) {
            return defaultValue;
        }
        String[] classnames = this.getTrimmedStrings(name);
        try {
            Class[] classes = new Class[classnames.length];
            for (int i = 0; i < classnames.length; ++i) {
                classes[i] = ReflectionUtils.getClassByName((String)classnames[i]);
            }
            return classes;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String valueString = this.getTrimmed(name);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return ReflectionUtils.getClassByName((String)valueString);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <BASE> Class<? extends BASE> getClass(String name, Class<? extends BASE> defaultValue, Class<BASE> xface) {
        try {
            Class theClass = this.getClass(name, defaultValue);
            if (theClass != null && !xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            if (theClass != null) {
                return theClass.asSubclass(xface);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setClass(String name, Class<?> theClass, Class<?> xface) {
        if (!xface.isAssignableFrom(theClass)) {
            throw new RuntimeException(theClass + " not " + xface.getName());
        }
        this.set(name, theClass.getName());
    }

    public int size() {
        return this.properties.size();
    }

    public void clear() {
        this.properties.clear();
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + ":" + this.size();
    }
}

