/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.retry;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.ratis.retry.ExponentialBackoffRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.util.TimeDuration;

public final class ExponentialBackoffRetry
implements RetryPolicy {
    private final TimeDuration baseSleepTime;
    private final TimeDuration maxSleepTime;
    private final int maxAttempts;

    private ExponentialBackoffRetry(TimeDuration baseSleepTime, TimeDuration maxSleepTime, int maxAttempts) {
        this.baseSleepTime = baseSleepTime;
        this.maxSleepTime = maxSleepTime;
        this.maxAttempts = maxAttempts;
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }

    private TimeDuration getSleepTime(int attemptCount) {
        TimeDuration sleepTime = this.baseSleepTime.multiply(Math.pow(2.0, attemptCount));
        sleepTime = this.maxSleepTime != null && sleepTime.compareTo(this.maxSleepTime) > 0 ? this.maxSleepTime : sleepTime;
        return sleepTime.multiply(ThreadLocalRandom.current().nextDouble() + 0.5);
    }

    public RetryPolicy.Action handleAttemptFailure(RetryPolicy.Event event) {
        TimeDuration sleepTime = this.getSleepTime(event.getAttemptCount());
        return event.getAttemptCount() < this.maxAttempts ? () -> sleepTime : NO_RETRY_ACTION;
    }
}

