/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.security;

import java.io.File;
import java.net.URL;
import java.util.Optional;
import org.apache.ratis.security.TlsConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public interface SecurityTestUtils {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityTestUtils.class);
    public static final ClassLoader CLASS_LOADER = SecurityTestUtils.class.getClassLoader();

    public static File getResource(String name) {
        File file = Optional.ofNullable(CLASS_LOADER.getResource(name)).map(URL::getFile).map(File::new).orElse(null);
        LOG.info("Getting resource {}: {}", (Object)name, (Object)file);
        return file;
    }

    public static TlsConf newServerTlsConfig(boolean mutualAuthn) {
        LOG.info("newServerTlsConfig: mutualAuthn? {}", (Object)mutualAuthn);
        return new TlsConf.Builder().setName("server").setPrivateKey(new TlsConf.PrivateKeyConf(SecurityTestUtils.getResource((String)"ssl/server.pem"))).setKeyCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource((String)"ssl/server.crt"))).setTrustCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource((String)"ssl/client.crt"))).setMutualTls(mutualAuthn).build();
    }

    public static TlsConf newClientTlsConfig(boolean mutualAuthn) {
        LOG.info("newClientTlsConfig: mutualAuthn? {}", (Object)mutualAuthn);
        return new TlsConf.Builder().setName("client").setPrivateKey(new TlsConf.PrivateKeyConf(SecurityTestUtils.getResource((String)"ssl/client.pem"))).setKeyCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource((String)"ssl/client.crt"))).setTrustCertificates(new TlsConf.CertificatesConf(SecurityTestUtils.getResource((String)"ssl/ca.crt"))).setMutualTls(mutualAuthn).build();
    }
}

