/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.util.JavaUtils;

public class AwaitForSignal {
    private final String name;
    private final AtomicReference<CompletableFuture<Void>> future = new AtomicReference(new CompletableFuture());

    public AwaitForSignal(Object name) {
        this.name = name + "-" + JavaUtils.getClassSimpleName(this.getClass());
    }

    public void await() throws InterruptedException {
        try {
            ((CompletableFuture)this.future.get()).get();
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        if (time <= 0L) {
            return false;
        }
        try {
            ((CompletableFuture)this.future.get()).get(time, unit);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException ignored) {
            return false;
        }
        return true;
    }

    public void signal() {
        this.future.getAndSet(new CompletableFuture()).complete(null);
    }

    public String toString() {
        return this.name;
    }
}

