/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.ratis.util.Preconditions;

/*
 * Exception performing whole class analysis ignored.
 */
public interface CollectionUtils {
    public static <T> T min(T left, T right, Comparator<T> comparator) {
        return comparator.compare(left, right) < 0 ? left : right;
    }

    public static <T extends Comparable<T>> T min(T left, T right) {
        return (T)((Comparable)CollectionUtils.min(left, right, Comparator.naturalOrder()));
    }

    public static <T> T next(T given, Iterable<T> iteration) {
        T first;
        Objects.requireNonNull(given, "given == null");
        Iterator<T> i = Objects.requireNonNull(iteration, "iteration == null").iterator();
        Preconditions.assertTrue((boolean)i.hasNext(), (Object)"iteration is empty.");
        T current = first = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (given.equals(current)) {
                return next;
            }
            current = next;
        }
        return first;
    }

    public static <T> T random(T given, Iterable<T> iteration) {
        Objects.requireNonNull(given, "given == null");
        Objects.requireNonNull(iteration, "iteration == null");
        List list = StreamSupport.stream(iteration.spliterator(), false).filter(e -> !given.equals(e)).collect(Collectors.toList());
        int size = list.size();
        return size == 0 ? null : (T)list.get(ThreadLocalRandom.current().nextInt(size));
    }

    public static <T> T random(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        Iterator<T> i = elements.iterator();
        for (int n = ThreadLocalRandom.current().nextInt(elements.size()); n > 0; --n) {
            i.next();
        }
        return i.next();
    }

    public static <INPUT, OUTPUT> Iterable<OUTPUT> as(Iterable<INPUT> iteration, Function<INPUT, OUTPUT> converter) {
        return () -> new /* Unavailable Anonymous Inner Class!! */;
    }

    public static <INPUT, OUTPUT> Iterable<OUTPUT> as(INPUT[] array, Function<INPUT, OUTPUT> converter) {
        return CollectionUtils.as(Arrays.asList(array), converter);
    }

    public static <K, V> V putNew(K key, V value, Map<K, V> map, Supplier<Object> name) {
        V returned = map.put(key, value);
        Preconditions.assertTrue((returned == null ? 1 : 0) != 0, () -> "Entry already exists for key " + key + " in map " + name.get());
        return value;
    }

    public static <K, V> void replaceExisting(K key, V oldValue, V newValue, Map<K, V> map, Supplier<Object> name) {
        boolean replaced = map.replace(key, oldValue, newValue);
        Preconditions.assertTrue((boolean)replaced, () -> "Entry not found for key " + key + " in map " + name.get());
    }

    public static <K, V> void removeExisting(K key, V value, Map<K, V> map, Supplier<Object> name) {
        boolean removed = map.remove(key, value);
        Preconditions.assertTrue((boolean)removed, () -> "Entry not found for key " + key + " in map " + name.get());
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Supplier<V> supplier, Runnable actionIfAbsent) {
        Object v = map.get(key);
        if (v != null) {
            return v;
        }
        V newValue = supplier.get();
        v = map.putIfAbsent(key, newValue);
        if (v != null) {
            return v;
        }
        actionIfAbsent.run();
        return newValue;
    }

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Supplier<V> supplier) {
        return (V)CollectionUtils.computeIfAbsent(map, key, supplier, () -> {});
    }
}

