/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import org.apache.ratis.util.CollectionUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.StringUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;
import org.apache.ratis.util.function.CheckedBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TimeDuration
implements Comparable<TimeDuration> {
    static final Logger LOG = LoggerFactory.getLogger(TimeDuration.class);
    public static final TimeDuration ZERO = TimeDuration.valueOf((long)0L, (TimeUnit)TimeUnit.NANOSECONDS);
    public static final TimeDuration ONE_MILLISECOND = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
    public static final TimeDuration ONE_SECOND = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.SECONDS);
    public static final TimeDuration ONE_MINUTE = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.MINUTES);
    public static final TimeDuration ONE_DAY = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.DAYS);
    static final double ERROR_THRESHOLD = 0.001;
    private final long duration;
    private final TimeUnit unit;

    public static TimeUnit lowerUnit(TimeUnit unit) {
        int ordinal = unit.ordinal();
        return ordinal == 0 ? unit : TimeUnit.values()[ordinal - 1];
    }

    public static TimeUnit higherUnit(TimeUnit unit) {
        TimeUnit[] timeUnits;
        int ordinal = unit.ordinal();
        return ordinal == (timeUnits = TimeUnit.values()).length - 1 ? unit : timeUnits[ordinal + 1];
    }

    public static long parse(String timeString, TimeUnit targetUnit) {
        return TimeDuration.valueOf((String)timeString, (TimeUnit)targetUnit).toLong(targetUnit);
    }

    public static TimeDuration valueOf(String timeString, TimeUnit defaultUnit) {
        Objects.requireNonNull(timeString, "timeString = null");
        String lower = timeString.trim().replace("_", "").toLowerCase();
        for (Abbreviation a : Abbreviation.values()) {
            for (String s : a.getSymbols()) {
                if (!lower.endsWith(s)) continue;
                String value = lower.substring(0, lower.length() - s.length()).trim();
                try {
                    return TimeDuration.valueOf((long)Long.parseLong(value), (TimeUnit)a.unit());
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return TimeDuration.valueOf((long)Long.parseLong(lower), (TimeUnit)defaultUnit);
    }

    public static TimeDuration valueOf(long duration, TimeUnit unit) {
        return new TimeDuration(duration, unit);
    }

    private TimeDuration(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = Objects.requireNonNull(unit, "unit = null");
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toLong(TimeUnit targetUnit) {
        return targetUnit.convert(this.duration, this.unit);
    }

    public int toIntExact(TimeUnit targetUnit) {
        return Math.toIntExact(this.toLong(targetUnit));
    }

    public TimeDuration to(TimeUnit targetUnit) {
        if (this.unit == targetUnit) {
            return this;
        }
        TimeDuration t = TimeDuration.valueOf((long)this.toLong(targetUnit), (TimeUnit)targetUnit);
        LOG.debug("{}.to({}) = {}", new Object[]{this, targetUnit, t});
        return t;
    }

    public TimeDuration add(TimeDuration that) {
        Objects.requireNonNull(that, "that == null");
        TimeUnit minUnit = (TimeUnit)((Object)CollectionUtils.min((Comparable)((Object)this.unit), (Comparable)((Object)that.unit)));
        return TimeDuration.valueOf((long)(this.toLong(minUnit) + that.toLong(minUnit)), (TimeUnit)minUnit);
    }

    public TimeDuration add(long thatDuration, TimeUnit thatUnit) {
        return this.add(TimeDuration.valueOf((long)thatDuration, (TimeUnit)thatUnit));
    }

    public TimeDuration subtract(TimeDuration that) {
        Objects.requireNonNull(that, "that == null");
        TimeUnit minUnit = (TimeUnit)((Object)CollectionUtils.min((Comparable)((Object)this.unit), (Comparable)((Object)that.unit)));
        return TimeDuration.valueOf((long)(this.toLong(minUnit) - that.toLong(minUnit)), (TimeUnit)minUnit);
    }

    private static boolean isMagnitudeLarge(long n) {
        return n > 1000000000000L || n < -1000000000000L;
    }

    public TimeDuration multiply(double multiplier) {
        double product = (double)this.duration * multiplier;
        long rounded = Math.round(product);
        if (this.unit.ordinal() != TimeUnit.values().length - 1 && (rounded == Long.MAX_VALUE || rounded == Long.MIN_VALUE)) {
            if (Math.abs(multiplier) > 2.0) {
                return this.multiply(2.0).multiply(multiplier / 2.0);
            }
            return this.to(TimeDuration.higherUnit((TimeUnit)this.unit)).multiply(multiplier);
        }
        if (this.unit.ordinal() != 0 && Math.abs(product - (double)rounded) > Math.abs(product) * 0.001) {
            if (TimeDuration.isMagnitudeLarge((long)this.duration) && Math.abs(multiplier) < 0.5) {
                return this.multiply(0.5).multiply(multiplier * 2.0);
            }
            return this.to(TimeDuration.lowerUnit((TimeUnit)this.unit)).multiply(multiplier);
        }
        TimeDuration t = TimeDuration.valueOf((long)rounded, (TimeUnit)this.unit);
        LOG.debug("{} * {} = {}", new Object[]{this, multiplier, t});
        return t;
    }

    public TimeDuration negate() {
        if (this.duration == Long.MIN_VALUE) {
            return TimeDuration.valueOf((long)Long.MAX_VALUE, (TimeUnit)this.unit);
        }
        return TimeDuration.valueOf((long)Math.negateExact(this.duration), (TimeUnit)this.unit);
    }

    public long roundUpNanos(long nanos) {
        if (this.duration <= 0L) {
            throw new ArithmeticException("Rounding up to a non-positive " + JavaUtils.getClassSimpleName(this.getClass()) + " (=" + this + ")");
        }
        long divisor = this.toLong(TimeUnit.NANOSECONDS);
        if (nanos == 0L || divisor == 1L) {
            return nanos;
        }
        long remainder = nanos % divisor;
        if (remainder > 0L) {
            remainder -= divisor;
        }
        return nanos - remainder;
    }

    public TimeDuration apply(LongUnaryOperator operator) {
        return TimeDuration.valueOf((long)operator.applyAsLong(this.duration), (TimeUnit)this.unit);
    }

    public <OUTPUT, THROWABLE extends Throwable> OUTPUT apply(CheckedBiFunction<Long, TimeUnit, OUTPUT, THROWABLE> function) throws THROWABLE {
        return (OUTPUT)function.apply((Object)this.getDuration(), (Object)this.getUnit());
    }

    public boolean isNegative() {
        return this.duration < 0L;
    }

    public boolean isNonPositive() {
        return this.duration <= 0L;
    }

    public TimeDuration sleep() throws InterruptedException {
        return this.sleep(null);
    }

    public TimeDuration sleep(Consumer<Object> log) throws InterruptedException {
        if (log != null) {
            log.accept(StringUtils.stringSupplierAsObject(() -> "Start sleeping " + this));
        }
        Timestamp start = Timestamp.currentTime();
        try {
            this.unit.sleep(this.duration);
            if (log != null) {
                log.accept(StringUtils.stringSupplierAsObject(() -> "Completed sleeping " + this));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            if (log != null) {
                log.accept(StringUtils.stringSupplierAsObject(() -> "Interrupted sleeping " + this));
            }
            throw ie;
        }
        return start.elapsedTime().subtract(this);
    }

    @Override
    public int compareTo(TimeDuration that) {
        if (this.unit.compareTo(that.unit) > 0) {
            return Integer.compare(0, that.compareTo(this));
        }
        if (this.unit == that.unit) {
            return Long.compare(this.duration, that.duration);
        }
        long thisDurationInThatUnit = this.toLong(that.unit);
        if (thisDurationInThatUnit == that.duration) {
            long thatDurationInThisUnit = that.toLong(this.unit);
            return Long.compare(this.duration, thatDurationInThisUnit);
        }
        return Long.compare(thisDurationInThatUnit, that.duration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeDuration)) {
            return false;
        }
        TimeDuration that = (TimeDuration)obj;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Long.hashCode(this.toLong(TimeUnit.NANOSECONDS));
    }

    public String toString() {
        return this.duration + Abbreviation.valueOf((TimeUnit)this.unit).getDefault();
    }
}

