/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.io.Closeable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutScheduler;
import org.apache.ratis.util.function.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutScheduler
implements Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(TimeoutScheduler.class);
    static final TimeDuration DEFAULT_GRACE_PERIOD = TimeDuration.valueOf((long)1L, (TimeUnit)TimeUnit.MINUTES);
    private static final Supplier<TimeoutScheduler> INSTANCE = JavaUtils.memoize(TimeoutScheduler::new);
    private final AtomicReference<TimeDuration> gracePeriod = new AtomicReference<TimeDuration>(DEFAULT_GRACE_PERIOD);
    private int numTasks = 0;
    private int scheduleID = 0;
    private ShutdownTask shutdownTask = null;
    private final Scheduler scheduler = new Scheduler(null);

    public static TimeoutScheduler getInstance() {
        return (TimeoutScheduler)INSTANCE.get();
    }

    static TimeoutScheduler newInstance() {
        return new TimeoutScheduler();
    }

    private TimeoutScheduler() {
    }

    int getQueueSize() {
        return this.scheduler.getQueueSize();
    }

    TimeDuration getGracePeriod() {
        return (TimeDuration)this.gracePeriod.get();
    }

    void setGracePeriod(TimeDuration gracePeriod) {
        this.gracePeriod.set(gracePeriod);
    }

    boolean hasScheduler() {
        return this.scheduler.hasExecutor();
    }

    public <THROWABLE extends Throwable> void onTimeout(TimeDuration timeout, CheckedRunnable<THROWABLE> task, Consumer<THROWABLE> errorHandler) {
        this.onTimeout(timeout, sid -> {
            LOG.debug("run a task: sid {}", sid);
            try {
                task.run();
            }
            catch (Throwable t) {
                errorHandler.accept(JavaUtils.cast((Object)t));
            }
            finally {
                this.onTaskCompleted();
            }
        });
    }

    private synchronized void onTimeout(TimeDuration timeout, Consumer<Integer> toSchedule) {
        ++this.numTasks;
        int sid = this.scheduleID++;
        LOG.debug("schedule a task: timeout {}, sid {}", (Object)timeout, (Object)sid);
        this.scheduler.schedule(() -> toSchedule.accept(sid), () -> "task #" + sid, timeout);
    }

    private synchronized void onTaskCompleted() {
        if (--this.numTasks > 0) {
            return;
        }
        int sid = this.scheduleID;
        if (this.shutdownTask != null) {
            if (this.shutdownTask.getSid() == sid) {
                return;
            }
            this.shutdownTask.cancel();
        }
        TimeDuration grace = this.getGracePeriod();
        LOG.debug("Schedule a shutdown task: grace {}, sid {}", (Object)grace, (Object)sid);
        ScheduledFuture future = this.scheduler.schedule(() -> this.tryShutdownScheduler(sid), () -> "shutdown task #" + sid, grace);
        this.shutdownTask = new ShutdownTask(sid, future);
    }

    private synchronized void tryShutdownScheduler(int sid) {
        if (sid == this.scheduleID) {
            LOG.debug("shutdown scheduler: sid {}", (Object)sid);
            this.scheduler.shutdown();
        } else {
            LOG.debug("shutdown cancelled: scheduleID has changed from {} to {}", (Object)sid, (Object)this.scheduleID);
        }
    }

    public void onTimeout(TimeDuration timeout, CheckedRunnable<?> task, Logger log, Supplier<String> errorMessage) {
        this.onTimeout(timeout, task, t -> log.error((String)errorMessage.get(), t));
    }

    @Override
    public synchronized void close() {
        this.tryShutdownScheduler(this.scheduleID);
    }
}

